/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeBaseMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.wltea.analyzer.lucene.IKAnalyzer;

@Service(value="knowledgeBaseService")
public class KnowledgeBaseServiceImpl
extends BaseServiceImpl<KnowledgeBaseMapper, KnowledgeBaseEntity>
implements IKnowledgeBaseService {
    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;

    @Override
    public KnowledgeBaseEntity queryBaseDataByItemId(Long embeddingId) {
        return this.knowledgeBaseMapper.queryBaseDataByItemId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByEmbeddingId(Long embeddingId) {
        return this.knowledgeBaseMapper.queryBaseDataByEmbeddingId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByPointsId(Long embeddingId) {
        return this.knowledgeBaseMapper.queryBaseDataByPointsId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByTableIndexId(Long embeddingId) {
        return this.knowledgeBaseMapper.queryBaseDataByTableIndexId(embeddingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<JSONArray> hitTest(Long baseId, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new BusinessException("\u7f3a\u5c11\u547d\u4e2d\u6d4b\u8bd5\u6570\u636e");
        }
        KnowledgeBaseEntity entity = (KnowledgeBaseEntity)((Object)this.selectById(baseId));
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(entity.getCode());
        Embedding queryEmbedding = (Embedding)embeddingModel.embed(text).content();
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(entity.getCode());
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(Double.valueOf(entity.getRetrieveMinScore().doubleValue())).maxResults(entity.getRetrieveMaxResults()).build();
        EmbeddingSearchResult embeddedEmbeddingSearchResult = embeddingStore.search(embeddingSearchRequest);
        List embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
        JSONArray result = new JSONArray();
        if (embeddingMatcheList.size() > 0) {
            HashMap embeddingMap = new HashMap();
            HashMap itemMap = new HashMap();
            ArrayList<String> words = new ArrayList<String>();
            TokenStream tokenStream = null;
            try {
                IKAnalyzer analyzer = new IKAnalyzer(true);
                tokenStream = analyzer.tokenStream("content", (Reader)new StringReader(text));
                tokenStream.reset();
                CharTermAttribute termAttr = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                while (tokenStream.incrementToken()) {
                    words.add(termAttr.toString());
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (tokenStream != null) {
                    try {
                        tokenStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            block12: for (EmbeddingMatch embeddingMatch : embeddingMatcheList) {
                TextSegment textSegment = (TextSegment)embeddingMatch.embedded();
                for (String word : words) {
                    if (!textSegment.text().contains(word)) continue;
                    JSONObject json = new JSONObject();
                    json.put("content", (Object)textSegment.text());
                    BigDecimal matchScore = new BigDecimal(embeddingMatch.score());
                    matchScore = matchScore.setScale(3, RoundingMode.HALF_UP);
                    json.put("matchScore", (Object)matchScore);
                    json.put("embeddingId", (Object)embeddingMatch.embeddingId());
                    QueryWrapper pointsWrapper = new QueryWrapper();
                    pointsWrapper.like((Object)"uuid", (Object)embeddingMatch.embeddingId());
                    List pointsList = this.knowledgeEmbeddingPointsService.list((Wrapper)pointsWrapper);
                    if (pointsList != null && pointsList.size() > 0) {
                        json.put("embeddingPointsContent", (Object)((KnowledgeEmbeddingPointsEntity)((Object)pointsList.get(0))).getContent());
                        KnowledgeEmbeddingEntity embedding = null;
                        embedding = embeddingMap.get(((KnowledgeEmbeddingPointsEntity)((Object)pointsList.get(0))).getEmbeddingId()) != null ? (KnowledgeEmbeddingEntity)((Object)embeddingMap.get(pointsList.get(0))) : (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(((KnowledgeEmbeddingPointsEntity)((Object)pointsList.get(0))).getEmbeddingId()));
                        json.put("type", (Object)embedding.getType());
                        json.put("embeddingContent", (Object)embedding.getContent());
                        json.put("sequence", (Object)embedding.getSequence());
                        KnowledgeItemEntity item = null;
                        item = itemMap.get(embedding.getItemId()) != null ? (KnowledgeItemEntity)((Object)itemMap.get(embedding.getItemId())) : (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(embedding.getItemId()));
                        json.put("fileName", (Object)item.getFileName());
                    }
                    result.add((Object)json);
                    continue block12;
                }
            }
        }
        return CommonResponse.success((Object)result);
    }
}

