/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemTableIndexEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.service.IKnowledgeItemTableIndexService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeEmbeddingService")
public class KnowledgeEmbeddingServiceImpl
extends BaseServiceImpl<KnowledgeEmbeddingMapper, KnowledgeEmbeddingEntity>
implements IKnowledgeEmbeddingService {
    @Autowired
    private KnowledgeEmbeddingMapper embeddingMapper;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public KnowledgeEmbeddingVO saveData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeEmbeddingEntity.class));
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setType(2);
            entity.setSliceState(1);
            entity.setInitContent(entity.getContent());
            Integer maxSequence = this.embeddingMapper.selectMaxSequence(saveOrUpdateVO.getItemId());
            entity.setSequence(maxSequence + 1);
            this.generateStore(indexName, entity);
        } else {
            if (entity.getType() == 1) {
                entity.setType(3);
            }
            entity.setContent(saveOrUpdateVO.getContent());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)saveOrUpdateVO.getId());
            wrapper.in((Object)"type", new Object[]{1, 3});
            List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                KnowledgeEmbeddingPointsEntity en = (KnowledgeEmbeddingPointsEntity)((Object)list.get(0));
                EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
                EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.remove(en.getUuid());
                JSONObject json = this.documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                entity.setUuid(indexName + ":" + redisId);
                entity.setInitContent(saveOrUpdateVO.getContent());
                en.setUuid(indexName + ":" + redisId);
                en.setContent(saveOrUpdateVO.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            } else {
                this.generateStore(indexName, entity);
            }
        }
        this.saveOrUpdate((Object)entity, false);
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(entity.getItemId()));
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
        return vo;
    }

    private void generateStore(String indexName, KnowledgeEmbeddingEntity entity) {
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        JSONObject json = this.documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
        Embedding embedding = (Embedding)json.get((Object)"embedding");
        String redisId = (String)json.get((Object)"redisId");
        entity.setId(IdWorker.getId());
        entity.setUuid(indexName + ":" + redisId);
        if (entity.getType() == null) {
            entity.setType(2);
        }
        KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
        en.setEmbeddingId(entity.getId());
        en.setUuid(indexName + ":" + redisId);
        en.setContent(entity.getContent());
        en.setInitContent(entity.getContent());
        en.setVector(Arrays.toString(embedding.vector()));
        en.setSequence(1);
        en.setType(1);
        this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
    }

    @Override
    public void delData(Long id) {
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)this.selectById(id));
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(id);
        String indexName = knowledgeBase.getCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)id);
        List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            ArrayList rids = new ArrayList();
            list.forEach(item -> rids.add(item.getUuid()));
            EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
            embeddingStore.removeAll(rids);
            this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapper);
        }
        this.removeById(id);
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(entity.getItemId()));
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
    }

    @Override
    public KnowledgeEmbeddingVO saveTableData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        String tableContent = saveOrUpdateVO.getTableContent();
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper tableWrapper = new QueryWrapper();
        tableWrapper.eq((Object)"item_id", (Object)saveOrUpdateVO.getItemId());
        List indexList = this.knowledgeItemTableIndexService.list((Wrapper)tableWrapper);
        String indexs = null;
        String titles = null;
        if (indexList == null || indexList.size() <= 0) {
            throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
        }
        indexs = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getIndexs();
        titles = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getTitles();
        if (StringUtils.isBlank((CharSequence)indexs)) {
            throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
        }
        if (StringUtils.isBlank((CharSequence)titles)) {
            throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e");
        }
        String[] titlesArray = titles.split(",");
        String[] indexsArray = indexs.split(",");
        JSONObject ob = JSONObject.parseObject((String)tableContent);
        String o = "";
        for (int j = 0; j < titlesArray.length; ++j) {
            o = o + titlesArray[j] + ": " + ob.get((Object)titlesArray[j]) + " ";
        }
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setSliceState(1);
            saveOrUpdateVO.setContent(o);
            saveOrUpdateVO.setInitContent(tableContent);
            Integer maxSequence = this.embeddingMapper.selectMaxSequence(saveOrUpdateVO.getItemId());
            saveOrUpdateVO.setSequence(maxSequence + 1);
        }
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeEmbeddingEntity.class));
        this.saveOrUpdate((Object)entity, false);
        KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)saveOrUpdateVO.getId());
        wrapper.in((Object)"type", new Object[]{1, 3});
        List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        if (list != null && list.size() > 0) {
            ArrayList delredisIds = new ArrayList();
            list.forEach(e -> delredisIds.add(e.getUuid()));
            embeddingStore.removeAll(delredisIds);
            this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapper);
        }
        List allRedisIds = new ArrayList();
        try {
            ArrayList<TextSegment> documents = new ArrayList<TextSegment>();
            ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
            TextSegment s = TextSegment.from(o);
            documents.add(s);
            for (int j = 0; j < indexsArray.length; ++j) {
                String index = indexsArray[j];
                documents.add(TextSegment.from(index + ": " + ob.getString(index)));
            }
            EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
            JSONObject json = this.documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
            List embeddings = (List)json.get((Object)"embeddings");
            allRedisIds = (List)json.get((Object)"redisIds");
            for (int j = 0; j < documents.size(); ++j) {
                TextSegment segment = (TextSegment)documents.get(j);
                Embedding embedding = (Embedding)embeddings.get(j);
                String id = (String)allRedisIds.get(j);
                KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                p.setEmbeddingId(entity.getId());
                p.setUuid(indexName + ":" + id);
                p.setContent(segment.text());
                p.setInitContent(segment.text());
                p.setVector(Arrays.toString(embedding.vector()));
                p.setType(1);
                p.setSequence(documents.size() - j);
                listPoints.add(p);
            }
            if (listPoints != null && listPoints.size() > 0) {
                this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
            }
        }
        catch (Exception e2) {
            embeddingStore.removeAll(allRedisIds);
            throw new BusinessException("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
        }
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(entity.getItemId()));
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO enableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)this.selectById(data.getId()));
        entity.setSliceState(1);
        this.saveOrUpdate((Object)entity, false);
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)data.getId());
        List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
            EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
            for (KnowledgeEmbeddingPointsEntity pEntity : list) {
                JSONObject json = this.documentSplitUtil.documentStoreSingle(pEntity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                pEntity.setUuid(indexName + ":" + redisId);
                pEntity.setVector(Arrays.toString(embedding.vector()));
            }
            if (list != null && list.size() > 0) {
                this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(list, list.size(), false);
            }
        }
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(entity.getItemId()));
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO disableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)this.selectById((Serializable)((Object)data)));
        entity.setSliceState(0);
        this.saveOrUpdate((Object)entity, false);
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)data.getId());
        List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
            ArrayList delredisIds = new ArrayList();
            list.forEach(e -> delredisIds.add(e.getUuid()));
            embeddingStore.removeAll(delredisIds);
        }
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(entity.getItemId()));
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO restoreData(KnowledgeEmbeddingVO data) {
        data.setType(1);
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(data.getItemId()));
        if (itemEntity.getKnowledgeType() == 1) {
            KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)this.selectById(data.getId()));
            KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
            String indexName = knowledgeBase.getCode();
            entity.setContent(entity.getInitContent());
            entity.setType(1);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)entity.getId());
            wrapper.in((Object)"type", new Object[]{1, 3});
            List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                KnowledgeEmbeddingPointsEntity en = (KnowledgeEmbeddingPointsEntity)((Object)list.get(0));
                EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
                EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.remove(en.getUuid());
                JSONObject json = this.documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                entity.setUuid(indexName + ":" + redisId);
                en.setUuid(indexName + ":" + redisId);
                en.setContent(entity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            } else {
                this.generateStore(indexName, entity);
            }
            QueryWrapper delwrapper = new QueryWrapper();
            delwrapper.eq((Object)"embedding_id", (Object)entity.getId());
            delwrapper.eq((Object)"type", (Object)2);
            this.saveOrUpdate((Object)entity, false);
            Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
            itemEntity.setEmbeddingCount(embeddingCount);
            this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
            KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
            return vo;
        }
        return this.saveTableData(data);
    }
}

