/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.AgentEntity;
import com.ejianc.foundation.ai.bean.KnowledgeMessageEntity;
import com.ejianc.foundation.ai.bean.KnowledgeMessageHistoryEntity;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.foundation.ai.service.IKnowledgeMessageHistoryService;
import com.ejianc.foundation.ai.service.IKnowledgeMessageService;
import com.ejianc.foundation.ai.vo.AgentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"agent"})
public class AgentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAgentService service;
    @Autowired
    private IKnowledgeMessageHistoryService KnowledgeMessageHistoryService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;

    public String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode() {
        String code = "";
        try {
            String str;
            code = str = this.generateRandomString(10);
            boolean flag = true;
            while (flag) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"code", (Object)code);
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                List list = this.service.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    code = str + this.generateRandomString(4);
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7f16\u7801\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u7f16\u7801\u5931\u8d25");
        }
        return code;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AgentVO> saveOrUpdate(@RequestBody AgentVO saveOrUpdateVO) {
        AgentEntity entity = (AgentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), AgentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String code = this.generateCode();
            entity.setCode(code);
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        AgentEntity uniqueBean = (AgentEntity)((Object)this.service.selectById(entity.getId()));
        uniqueBean.setName(entity.getName());
        uniqueBean.setAgentState(entity.getAgentState());
        uniqueBean.setDescription(entity.getDescription());
        uniqueBean.setRoleInstruction(entity.getRoleInstruction());
        uniqueBean.setModelId(entity.getModelId());
        if (1 == entity.getKnowledgeGyyFlag()) {
            uniqueBean.setKnowledgeIds("");
            uniqueBean.setKnowledgeNames("");
        } else {
            uniqueBean.setKnowledgeIds(entity.getKnowledgeIds());
            uniqueBean.setKnowledgeNames(entity.getKnowledgeNames());
        }
        uniqueBean.setMatchScore(entity.getMatchScore());
        uniqueBean.setCallBackNum(entity.getCallBackNum());
        uniqueBean.setIcon(entity.getIcon());
        uniqueBean.setStrictFlag(entity.getStrictFlag());
        uniqueBean.setTemperature(entity.getTemperature());
        uniqueBean.setKnowledgeGyyFlag(entity.getKnowledgeGyyFlag());
        this.service.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AgentVO> queryDetail(Long id) {
        AgentEntity entity = (AgentEntity)((Object)this.service.selectById(id));
        AgentVO vo = (AgentVO)((Object)BeanMapper.map((Object)((Object)entity), AgentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AgentVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AgentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AgentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refAgentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AgentVO>> refAgentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AgentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getDialogRecordsByAgent"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> getDialogRecordsByAgent(@RequestParam Long agentId, @RequestParam String searchValue, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        Long userId = InvocationInfoProxy.getUserid();
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("agentId", new Parameter("eq", (Object)agentId));
        queryParam.getParams().put("userId", new Parameter("eq", (Object)userId));
        queryParam.getOrderMap().put("topFlag", "desc");
        queryParam.getOrderMap().put("topOptDate", "asc");
        queryParam.getOrderMap().put("createTime", "desc");
        if (StringUtils.isNotBlank((CharSequence)searchValue)) {
            queryParam.getParams().put("title", new Parameter("like", (Object)searchValue));
        }
        if ("true".equals(reloadFlag)) {
            queryParam.setPageIndex(pageIndex.intValue());
            queryParam.setPageSize(20);
        } else {
            queryParam.setPageIndex(1);
            queryParam.setPageSize(pageIndex * 20);
        }
        IPage pageData = this.KnowledgeMessageHistoryService.queryPage(queryParam, false);
        List dialogRecords = pageData.getRecords();
        return CommonResponse.success((String)"\u67e5\u8be2\u667a\u80fd\u5bf9\u8bdd\u8bb0\u5f55\u6210\u529f\uff01", (Object)dialogRecords);
    }

    @RequestMapping(value={"/getDialogRecordsByDialogId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageEntity>> getDialogRecordsByDialogId(@RequestParam Long dialogId) {
        Long userId = InvocationInfoProxy.getUserid();
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("message_history_id", new Parameter("eq", (Object)dialogId));
        queryParam.getParams().put("userId", new Parameter("eq", (Object)userId));
        queryParam.getParams().put("parentId", new Parameter("eq", null));
        queryParam.getOrderMap().put("createTime", "asc");
        List knowledgeMessageRecords = this.knowledgeMessageService.queryList(queryParam, false);
        if (knowledgeMessageRecords != null && knowledgeMessageRecords.size() > 0) {
            for (KnowledgeMessageEntity contentRecord : knowledgeMessageRecords) {
                queryParam.getParams().put("parentId", new Parameter("eq", (Object)contentRecord.getId()));
                List childContentRecords = this.knowledgeMessageService.queryList(queryParam, false);
                contentRecord.setChildren(childContentRecords);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5bf9\u8bdd\u8bb0\u5f55\u6210\u529f\uff01", (Object)knowledgeMessageRecords);
    }

    @RequestMapping(value={"/dialogTopUp"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> dialogTopUp(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam Integer topFlag, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = (KnowledgeMessageHistoryEntity)((Object)this.KnowledgeMessageHistoryService.getById(dialogId));
        dialogEntity.setTopFlag(topFlag);
        if (1 == topFlag) {
            dialogEntity.setTopOptDate(new Date());
        } else {
            dialogEntity.setTopOptDate(null);
        }
        this.KnowledgeMessageHistoryService.saveOrUpdate((Object)dialogEntity, false);
        return this.getDialogRecordsByAgent(dialogEntity.getAgentId(), searchValue, pageIndex, reloadFlag);
    }

    @RequestMapping(value={"/updateDialogName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> updateDialogName(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam String title, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = (KnowledgeMessageHistoryEntity)((Object)this.KnowledgeMessageHistoryService.getById(dialogId));
        dialogEntity.setTitle(title);
        this.KnowledgeMessageHistoryService.saveOrUpdate((Object)dialogEntity, false);
        return this.getDialogRecordsByAgent(dialogEntity.getAgentId(), searchValue, pageIndex, reloadFlag);
    }

    @RequestMapping(value={"/deleteDialog"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> deleteDialog(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = (KnowledgeMessageHistoryEntity)((Object)this.KnowledgeMessageHistoryService.getById(dialogId));
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"message_history_id", (Object)dialogId);
        this.knowledgeMessageService.remove((Wrapper)wrapper);
        this.KnowledgeMessageHistoryService.removeById(dialogId);
        return this.getDialogRecordsByAgent(dialogEntity.getAgentId(), searchValue, pageIndex, reloadFlag);
    }
}

