/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.api.param.ChunkParam;
import com.ejianc.foundation.ai.api.param.UpdateChunkParam;
import com.ejianc.foundation.ai.api.result.ChunkResult;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemTableIndexEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.service.IKnowledgeItemTableIndexService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"knowledge"})
public class KnowledgeRestController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeEmbeddingMapper embeddingMapper;

    @RequestMapping(value={"/createChunk"}, method={RequestMethod.POST})
    public CommonResponse<ChunkResult> createChunk(@RequestBody ChunkParam chunkParam) {
        Integer maxSequence;
        List chunkContent = chunkParam.getChunkContent();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)chunkParam.getKnowledgeBaseCode());
        KnowledgeBaseEntity knowledgeBaseEntity = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.getOne((Wrapper)queryWrapper));
        if (knowledgeBaseEntity == null) {
            throw new BusinessException("\u77e5\u8bc6\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        QueryWrapper itemWrapper = new QueryWrapper();
        itemWrapper.eq((Object)"code", (Object)chunkParam.getKnowledgeItemCode());
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.getOne((Wrapper)itemWrapper));
        if (itemEntity == null) {
            throw new BusinessException("\u6587\u4ef6\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        String indexName = knowledgeBaseEntity.getCode();
        KnowledgeEmbeddingEntity entity = new KnowledgeEmbeddingEntity();
        entity.setType(2);
        entity.setSliceState(1);
        Integer n = maxSequence = this.embeddingMapper.selectMaxSequence(itemEntity.getId());
        Integer n2 = maxSequence = Integer.valueOf(maxSequence + 1);
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        ArrayList<JSONObject> chunkInfo = new ArrayList<JSONObject>();
        for (String content : chunkContent) {
            if (1 == knowledgeBaseEntity.getKnowledgeType()) {
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                JSONObject json = this.documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                entity.setId(IdWorker.getId());
                entity.setUuid(indexName + ":" + redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(entity.getId());
                en.setUuid(indexName + ":" + redisId);
                en.setContent(entity.getContent());
                en.setInitContent(entity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            } else if (2 == knowledgeBaseEntity.getKnowledgeType()) {
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                QueryWrapper tableWrapper = new QueryWrapper();
                tableWrapper.eq((Object)"item_id", (Object)itemEntity.getId());
                List indexList = this.knowledgeItemTableIndexService.list((Wrapper)tableWrapper);
                String indexs = null;
                String titles = null;
                if (indexList == null || indexList.size() <= 0) {
                    throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
                }
                indexs = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getIndexs();
                titles = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getTitles();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)indexs)) {
                    throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)titles)) {
                    throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e");
                }
                String[] titlesArray = titles.split(",");
                String[] indexsArray = indexs.split(",");
                JSONObject ob = JSONObject.parseObject((String)content);
                String o = "";
                for (int j = 0; j < titlesArray.length; ++j) {
                    o = o + titlesArray[j] + ": " + ob.get((Object)titlesArray[j]) + " ";
                }
                entity.setSliceState(1);
                entity.setContent(o);
                entity.setInitContent(content);
                this.knowledgeEmbeddingService.saveOrUpdate((Object)entity, false);
                List allRedisIds = new ArrayList();
                try {
                    ArrayList<TextSegment> documents = new ArrayList<TextSegment>();
                    ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
                    TextSegment s = TextSegment.from(o);
                    documents.add(s);
                    for (int j = 0; j < indexsArray.length; ++j) {
                        String index = indexsArray[j];
                        documents.add(TextSegment.from(index + ": " + ob.getString(index)));
                    }
                    JSONObject json = this.documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                    List embeddings = (List)json.get((Object)"embeddings");
                    allRedisIds = (List)json.get((Object)"redisIds");
                    for (int j = 0; j < documents.size(); ++j) {
                        TextSegment segment = (TextSegment)documents.get(j);
                        Embedding embedding = (Embedding)embeddings.get(j);
                        String id = (String)allRedisIds.get(j);
                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(entity.getId());
                        p.setUuid(indexName + ":" + id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(documents.size() - j);
                        listPoints.add(p);
                    }
                    if (listPoints != null && listPoints.size() > 0) {
                        this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                }
                catch (Exception e) {
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
                }
            }
            JSONObject re = new JSONObject();
            re.put("id", (Object)entity.getId());
            re.put("content", (Object)content);
            chunkInfo.add(re);
        }
        Integer embeddingCount = this.knowledgeEmbeddingPointsService.countEmbeddingByItemId(itemEntity.getId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        ChunkResult result = new ChunkResult();
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/updateChunk"}, method={RequestMethod.POST})
    public CommonResponse<ChunkResult> updateChunk(@RequestBody UpdateChunkParam updateChunkParam) {
        String content = updateChunkParam.getChunkContent();
        if (StringUtils.isBlank((String)content)) {
            throw new BusinessException("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById((Serializable)((Object)updateChunkParam.getChunkId())));
        if (embeddingEntity == null) {
            throw new BusinessException("\u77e5\u8bc6\u5207\u7247\u4e0d\u5b58\u5728");
        }
        KnowledgeBaseEntity knowledgeBaseEntity = this.knowledgeBaseService.queryBaseDataByEmbeddingId(embeddingEntity.getId());
        String indexName = knowledgeBaseEntity.getCode();
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        if (1 == knowledgeBaseEntity.getKnowledgeType()) {
            embeddingEntity.setInitContent(content);
            embeddingEntity.setContent(content);
            embeddingEntity.setType(3);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)embeddingEntity.getId());
            wrapper.in((Object)"type", new Object[]{1, 3});
            List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                KnowledgeEmbeddingPointsEntity en = (KnowledgeEmbeddingPointsEntity)((Object)list.get(0));
                embeddingStore.remove(en.getUuid());
                JSONObject json = this.documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                embeddingEntity.setUuid(indexName + ":" + redisId);
                en.setUuid(indexName + ":" + redisId);
                en.setContent(content);
                en.setVector(Arrays.toString(embedding.vector()));
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            } else {
                JSONObject json = this.documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                embeddingEntity.setUuid(indexName + ":" + redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(embeddingEntity.getId());
                en.setUuid(indexName + ":" + redisId);
                en.setContent(embeddingEntity.getContent());
                en.setInitContent(embeddingEntity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            }
            this.knowledgeEmbeddingService.saveOrUpdate((Object)embeddingEntity, false);
        } else if (2 == knowledgeBaseEntity.getKnowledgeType()) {
            embeddingEntity.setInitContent(content);
            QueryWrapper tableWrapper = new QueryWrapper();
            tableWrapper.eq((Object)"item_id", (Object)embeddingEntity.getItemId());
            List indexList = this.knowledgeItemTableIndexService.list((Wrapper)tableWrapper);
            String indexs = null;
            String titles = null;
            if (indexList == null || indexList.size() <= 0) {
                throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
            }
            indexs = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getIndexs();
            titles = ((KnowledgeItemTableIndexEntity)((Object)indexList.get(0))).getTitles();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)indexs)) {
                throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u7d22\u5f15\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e\u7d22\u5f15");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)titles)) {
                throw new BusinessException("\u4e3a\u83b7\u53d6\u5230\u8be5\u6587\u6863\u7684\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)embeddingEntity.getId());
            wrapper.in((Object)"type", new Object[]{1, 3});
            List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                ArrayList delredisIds = new ArrayList();
                list.forEach(e -> delredisIds.add(e.getUuid()));
                embeddingStore.removeAll(delredisIds);
                this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapper);
            }
            String[] titlesArray = titles.split(",");
            String[] indexsArray = indexs.split(",");
            JSONObject ob = JSONObject.parseObject((String)content);
            String o = "";
            for (int j = 0; j < titlesArray.length; ++j) {
                o = o + titlesArray[j] + ": " + ob.get((Object)titlesArray[j]) + " ";
            }
            embeddingEntity.setSliceState(1);
            embeddingEntity.setContent(o);
            embeddingEntity.setInitContent(content);
            this.knowledgeEmbeddingService.saveOrUpdate((Object)embeddingEntity, false);
            List allRedisIds = new ArrayList();
            try {
                ArrayList<TextSegment> documents = new ArrayList<TextSegment>();
                ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
                TextSegment s = TextSegment.from(o);
                documents.add(s);
                for (int j = 0; j < indexsArray.length; ++j) {
                    String index = indexsArray[j];
                    documents.add(TextSegment.from(index + ": " + ob.getString(index)));
                }
                JSONObject json = this.documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                List embeddings = (List)json.get((Object)"embeddings");
                allRedisIds = (List)json.get((Object)"redisIds");
                for (int j = 0; j < documents.size(); ++j) {
                    TextSegment segment = (TextSegment)documents.get(j);
                    Embedding embedding = (Embedding)embeddings.get(j);
                    String id = (String)allRedisIds.get(j);
                    KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                    p.setEmbeddingId(embeddingEntity.getId());
                    p.setUuid(indexName + ":" + id);
                    p.setContent(segment.text());
                    p.setInitContent(segment.text());
                    p.setVector(Arrays.toString(embedding.vector()));
                    p.setType(1);
                    p.setSequence(documents.size() - j);
                    listPoints.add(p);
                }
                if (listPoints != null && listPoints.size() > 0) {
                    this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                }
            }
            catch (Exception e2) {
                embeddingStore.removeAll(allRedisIds);
                throw new BusinessException("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
            }
        }
        ChunkResult result = new ChunkResult();
        ArrayList<JSONObject> chunkInfo = new ArrayList<JSONObject>();
        JSONObject re = new JSONObject();
        re.put("id", (Object)updateChunkParam.getChunkId());
        re.put("content", (Object)content);
        chunkInfo.add(re);
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/deleteChunk"}, method={RequestMethod.POST})
    public CommonResponse<String> deleteChunk(@RequestBody Long chunkId) {
        this.knowledgeEmbeddingService.delData(chunkId);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

