/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.ai.bean.ModelEntity;
import com.ejianc.foundation.ai.service.IModelService;
import com.ejianc.foundation.ai.vo.ModelVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"model"})
public class ModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IModelService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ModelVO> saveOrUpdate(@RequestBody ModelVO saveOrUpdateVO) {
        ModelEntity entity = (ModelEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ModelEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        if (1 == entity.getEmbeddingModelFlag()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.set((Object)"embedding_model_flag", (Object)0);
            this.service.update((Wrapper)updateWrapper);
        }
        ModelEntity uniqueBean = (ModelEntity)((Object)this.service.selectById(entity.getId()));
        uniqueBean.setTitle(entity.getTitle());
        uniqueBean.setModelName(entity.getModelName());
        uniqueBean.setPlatform(entity.getPlatform());
        uniqueBean.setAppConfig(entity.getAppConfig());
        uniqueBean.setBaseUrl(entity.getBaseUrl());
        uniqueBean.setContextWindow(entity.getContextWindow());
        uniqueBean.setMaxInputTokens(entity.getMaxInputTokens());
        uniqueBean.setMaxOutputTokens(entity.getMaxOutputTokens());
        uniqueBean.setModelState(entity.getModelState());
        uniqueBean.setEmbeddingModelFlag(entity.getEmbeddingModelFlag());
        this.service.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ModelVO> queryDetail(Long id) {
        ModelEntity entity = (ModelEntity)((Object)this.service.selectById(id));
        ModelVO vo = (ModelVO)((Object)BeanMapper.map((Object)((Object)entity), ModelVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ModelEntity>> queryList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getOrderMap().put("createTime", "asc");
        IPage page = this.service.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ModelEntity>> queryAllList() {
        QueryParam queryParam = QueryParam.getInstance();
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("modelState", new Parameter("eq", (Object)1));
        queryParam.getOrderMap().put("createTime", "asc");
        List page = this.service.queryList(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/refModelData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ModelEntity>> refModelData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("modelState", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

