/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.service.ReceiptAiService;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptResultVO;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/receiptAi/"})
public class ReceiptAiApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${ejc.ai.receipt.appBuilderAppID:88796cca-a864-4617-ba72-850e333352ea}")
    private String APP_ID;
    @Value(value="${ejc.ai.receipt.appBuilderSecretKey:Bearer bce-v3/ALTAK-l39HjVaikGeUyvhYR3fJ9/acf6cc3782f9b3d9fc5dd58be0d8dd244655e50c}")
    private String SECRET_KEY;
    @Value(value="${ejc.ai.receipt.knowledgeBaseId:99feac29-1056-4c1b-9580-ddc1af599487}")
    private String KNOWLEDGE_BASE_ID;
    @Autowired
    private ReceiptAiService receiptAiService;

    @RequestMapping(value={"identify"}, method={RequestMethod.GET})
    public AiReceiptResultVO identify(@RequestParam String imageUrl, @RequestParam String imageName, @RequestParam(required=false, defaultValue="false") Boolean reIdentify) {
        String fileId = imageUrl.split("fileId=")[1];
        AiReceiptResultVO result = this.receiptAiService.getResultFromCache(fileId);
        if (result != null && !reIdentify.booleanValue()) {
            this.logger.info("\u83b7\u53d6\u5386\u53f2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return result;
        }
        AiReceiptResultVO resultVO = new AiReceiptResultVO();
        resultVO.setFileId(fileId);
        resultVO.setImageUrl(imageUrl);
        resultVO.setImageName(imageName);
        this.receiptAiService.saveResultToCache(resultVO);
        try {
            ArrayList<AiReceiptVO> resList = new ArrayList<AiReceiptVO>();
            String conversationId = QianfanAppBuilderUtil.getNewConversationId(this.APP_ID, this.SECRET_KEY);
            String confileId = QianfanAppBuilderUtil.uploadLocalFile(this.APP_ID, this.SECRET_KEY, conversationId, imageUrl, imageName);
            JSONObject para = new JSONObject();
            para.put("app_id", (Object)this.APP_ID);
            para.put("query", (Object)"\u4ece\u56fe\u7247\u4e2d\u63d0\u53d6\u51fa\u591a\u6761\u7269\u6599\u540d\u79f0\u3001\u89c4\u683c\u578b\u53f7\u3001\u5355\u4f4d\u3001\u6570\u91cf\u3001\u5355\u4ef7\u3001\u91d1\u989d\uff0c\u7ed3\u679c\u4ee5JSONArray\u6570\u7ec4\u683c\u5f0f\u7ed9\u51fa\uff0c\u672a\u8bc6\u522b\u5230\u8fd4\u56de\u7a7a\u6570\u636e\uff0c\u4ee5\u4fbf\u53ef\u4ee5\u76f4\u63a5\u4f7f\u7528JSONArray.parseArray()\u65b9\u6cd5\u89e3\u6790\u7ed3\u679c\uff0c\u4e0d\u8981\u9644\u52a0\u5176\u4ed6\u5206\u6790\u6027\u8bed\u53e5\u3002");
            para.put("conversation_id", (Object)conversationId);
            para.put("stream", (Object)false);
            para.put("file_ids", Arrays.asList(confileId));
            this.logger.info("================\u53c2\u6570=============================");
            this.logger.info(JSONObject.toJSONString((Object)para, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.info("================================================");
            JSONObject qFanContent = JSON.parseObject((String)QianfanAppBuilderUtil.postChatMsg(para, this.APP_ID, this.SECRET_KEY));
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank((String)answer) && answer.contains("```json")) {
                answer = answer.split("```json")[1];
                answer = answer.split("```")[0];
                List jsonObjects = JSONArray.parseArray((String)answer, JSONObject.class);
                this.logger.info("=================\u56fe\u7247\u8bc6\u522b\u7ed3\u679c===========================");
                for (JSONObject obj : jsonObjects) {
                    AiReceiptVO aiReceiptVO = new AiReceiptVO();
                    aiReceiptVO.setName(obj.getString("\u7269\u6599\u540d\u79f0"));
                    aiReceiptVO.setSpec(obj.getString("\u89c4\u683c\u578b\u53f7"));
                    aiReceiptVO.setUnitName(obj.getString("\u5355\u4f4d"));
                    aiReceiptVO.setNum(ReceiptAiApi.toBigDecimal(obj.get((Object)"\u6570\u91cf")));
                    aiReceiptVO.setPrice(ReceiptAiApi.toBigDecimal(obj.get((Object)"\u5355\u4ef7")));
                    aiReceiptVO.setMoney(ReceiptAiApi.toBigDecimal(obj.get((Object)"\u91d1\u989d")));
                    if (!StringUtils.isNotBlank((String)aiReceiptVO.getName())) continue;
                    resList.add(aiReceiptVO);
                }
                resultVO.setReceiptVOS(resList);
                this.logger.info(JSONObject.toJSONString((Object)resultVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                this.logger.info("================================================");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List receiptVOS = resultVO.getReceiptVOS();
        if (CollectionUtils.isEmpty((Collection)receiptVOS)) {
            resultVO.setMsg("\u672a\u8bc6\u522b\u5230\u56fe\u7247\u4e2d\u7684\u7269\u6599\u4fe1\u606f\uff01");
            resultVO.setCode(Integer.valueOf(1));
        } else {
            resultVO.setMsg("\u7269\u6599\u5339\u914d\u4e2d...");
            this.receiptAiService.identifyMaterial(resultVO, this.APP_ID, this.SECRET_KEY);
        }
        this.receiptAiService.saveResultToCache(resultVO);
        return resultVO;
    }

    @RequestMapping(value={"queryResult"}, method={RequestMethod.GET})
    public AiReceiptResultVO queryResult(@RequestParam String fileId) {
        return this.receiptAiService.getResultFromCache(fileId);
    }

    public static BigDecimal toBigDecimal(Object x) {
        if (x == null) {
            return null;
        }
        BigDecimal result = null;
        try {
            result = new BigDecimal(x.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

