/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.ExtDictRelationMapper;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IExtDictService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="extDictRelationService")
public class ExtDictRelationServiceImpl
extends BaseServiceImpl<ExtDictRelationMapper, ExtDictRelationEntity>
implements IExtDictRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeEmbeddingPointsService pointsService;
    @Autowired
    private IExtDictService extDictService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private IExtDictRelationService extDictRelationService;

    @Override
    public List<ExtDictRelationVO> queryListByEmbeddingIds(List<Long> embeddingIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"embedding_id", embeddingIds);
        List list = this.list((Wrapper)wrapper);
        ArrayList<ExtDictRelationVO> result = new ArrayList<ExtDictRelationVO>();
        if (list != null && list.size() > 0) {
            for (ExtDictRelationEntity entity : list) {
                ExtDictRelationVO vo = (ExtDictRelationVO)((Object)BeanMapper.map((Object)((Object)entity), ExtDictRelationVO.class));
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public void saveList(List<ExtDictRelationVO> list) {
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(list.get(0).getEmbeddingId());
        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        QueryWrapper pointsWrapper = new QueryWrapper();
        pointsWrapper.eq((Object)"embedding_id", (Object)list.get(0).getEmbeddingId());
        pointsWrapper.eq((Object)"type", (Object)3);
        List points = this.pointsService.list((Wrapper)pointsWrapper);
        KnowledgeEmbeddingPointsEntity point = null;
        if (points != null && points.size() > 0) {
            point = (KnowledgeEmbeddingPointsEntity)((Object)points.get(0));
            embeddingStore.remove(point.getUuid());
            String content = point.getInitContent();
            QueryWrapper relationWrapper = new QueryWrapper();
            relationWrapper.eq((Object)"embedding_id", (Object)point.getEmbeddingId());
            relationWrapper.eq((Object)"type", (Object)2);
            List relationList = this.extDictRelationService.list((Wrapper)relationWrapper);
            if (relationList != null && relationList.size() > 0) {
                for (ExtDictRelationEntity en : relationList) {
                    content = "\u3010" + en.getField() + "\u3011" + content;
                }
            }
            for (ExtDictRelationVO vo : list) {
                content = "\u3010" + vo.getField() + "\u3011" + content;
            }
            point.setContent(content);
            JSONObject json = this.documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
            Embedding embedding = (Embedding)json.get((Object)"embedding");
            String redisId = (String)json.get((Object)"redisId");
            point.setUuid(indexName + ":" + redisId);
            point.setVector(Arrays.toString(embedding.vector()));
            this.pointsService.saveOrUpdate((Object)point, false);
        } else {
            point = new KnowledgeEmbeddingPointsEntity();
            point.setType(3);
            KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(point.getEmbeddingId()));
            String content = embeddingEntity.getInitContent();
            for (ExtDictRelationVO vo : list) {
                content = "\u3010" + vo.getField() + "\u3011" + content;
            }
            point.setContent(content);
            point.setInitContent(embeddingEntity.getInitContent());
            JSONObject json = this.documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
            Embedding embedding = (Embedding)json.get((Object)"embedding");
            String redisId = (String)json.get((Object)"redisId");
            point.setUuid(indexName + ":" + redisId);
            point.setVector(Arrays.toString(embedding.vector()));
            this.pointsService.saveOrUpdate((Object)point, false);
        }
        List entitys = BeanMapper.mapList(list, ExtDictRelationEntity.class);
        this.saveOrUpdateBatch(entitys, entitys.size(), false);
    }
}

