/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.api.IKbmApi;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemTableIndexEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeItemMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.service.IKnowledgeItemTableIndexService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.utils.EjcThreadPoolUtils;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.CookieUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentByRegexSplitter;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="knowledgeItemService")
public class KnowledgeItemServiceImpl
extends BaseServiceImpl<KnowledgeItemMapper, KnowledgeItemEntity>
implements IKnowledgeItemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeItemMapper knowledgeItemMapper;
    @Autowired
    private IKbmApi kbmApi;
    @Autowired
    private EjcThreadPoolUtils ejcThreadPoolUtils;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IKnowledgeCategoryService knowledgeCategoryService;
    @Value(value="${common.env.base-host:#{null}}")
    private String baseHost;

    public String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode() {
        String code = "";
        try {
            String str;
            code = str = this.generateRandomString(10);
            boolean flag = true;
            while (flag) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"file_code", (Object)code);
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                List list = this.knowledgeItemMapper.selectList((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    code = str + this.generateRandomString(4);
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7f16\u7801\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u7f16\u7801\u5931\u8d25");
        }
        return code;
    }

    @Override
    public KnowledgeItemVO insert(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeBaseEntity knowledgeBase = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById(saveOrUpdateVO.getKnowledgeBaseId()));
        String indexName = knowledgeBase.getCode();
        KnowledgeItemEntity entity = (KnowledgeItemEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeItemEntity.class));
        if (saveOrUpdateVO.getId() == null) {
            entity.setId(IdWorker.getId());
            entity.setFileCode(this.generateCode());
            entity.setUploadUserId(InvocationInfoProxy.getUserid());
        }
        Document document = this.documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
        if (StringUtils.isBlank((CharSequence)entity.getBrief()) && StringUtils.isNotBlank((CharSequence)document.text())) {
            if (document.text().length() > 300) {
                entity.setBrief(document.text().substring(0, 300));
            } else {
                entity.setBrief(document.text());
            }
        }
        if (entity.getKnowledgeType() == 1) {
            entity.setEmbeddingStatus(2);
            this.saveOrUpdate((Object)entity, false);
            HashMap<String, Object> invocationInfo = new HashMap<String, Object>();
            invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute((String)"authority"));
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());
            Runnable task = () -> {
                InvocationInfoProxy.setCallid(invocationInfo.get("callid") != null ? invocationInfo.get("callid").toString() : null);
                InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("tenantid").toString())) : null);
                InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("employeeId").toString())) : null);
                InvocationInfoProxy.setLocale(invocationInfo.get("locale") != null ? invocationInfo.get("locale").toString() : null);
                InvocationInfoProxy.setLogints(invocationInfo.get("logints") != null ? invocationInfo.get("logints").toString() : null);
                InvocationInfoProxy.setOrgId(invocationInfo.get("orgId") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("orgId").toString())) : null);
                InvocationInfoProxy.setSysid(invocationInfo.get("sysid") != null ? invocationInfo.get("sysid").toString() : null);
                InvocationInfoProxy.setTheme(invocationInfo.get("theme") != null ? invocationInfo.get("theme").toString() : null);
                InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone") != null ? invocationInfo.get("timeZone").toString() : null);
                InvocationInfoProxy.setUsercode(invocationInfo.get("usercode") != null ? invocationInfo.get("usercode").toString() : null);
                InvocationInfoProxy.setUserid(invocationInfo.get("userid") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("userid").toString())) : null);
                InvocationInfoProxy.setUserType(invocationInfo.get("userType") != null ? invocationInfo.get("userType").toString() : null);
                InvocationInfoProxy.setExtendAttribute((Object)"authority", invocationInfo.get("authority") != null ? invocationInfo.get("authority").toString() : null);
                List allRedisIds = new ArrayList();
                try {
                    DocumentSplitter documentSplitter = null;
                    if (entity.getSliceStrategy() == 0) {
                        documentSplitter = DocumentSplitters.recursive((int)entity.getSliceMaxLength(), (int)entity.getSliceOverlap());
                    } else {
                        if (StringUtils.isBlank((CharSequence)entity.getSliceIdentifier())) {
                            throw new BusinessException("\u6807\u8bc6\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if ("char".equals(entity.getSliceIdentifier())) {
                            documentSplitter = new DocumentByCharacterSplitter(entity.getSliceMaxLength(), entity.getSliceOverlap());
                        } else if ("paragraph".equals(entity.getSliceIdentifier())) {
                            documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, entity.getSliceOverlap().intValue());
                        } else if ("regex".equals(entity.getSliceIdentifier()) || "fixedChar".equals(entity.getSliceIdentifier())) {
                            documentSplitter = new DocumentByRegexSplitter(entity.getSliceExpression(), "", Integer.MAX_VALUE, entity.getSliceOverlap().intValue());
                        } else {
                            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u5207\u7247\u7b56\u54af");
                        }
                    }
                    EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
                    EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                    JSONObject json = this.documentSplitUtil.documentSplitStore(document, documentSplitter, embeddingModel, embeddingStore);
                    List segments = (List)json.get((Object)"segments");
                    List embeddings = (List)json.get((Object)"embeddings");
                    allRedisIds = (List)json.get((Object)"redisIds");
                    ArrayList<KnowledgeEmbeddingEntity> list = new ArrayList<KnowledgeEmbeddingEntity>();
                    ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
                    for (int i = 0; i < segments.size(); ++i) {
                        TextSegment segment = (TextSegment)segments.get(i);
                        Embedding embedding = (Embedding)embeddings.get(i);
                        String id = (String)allRedisIds.get(i);
                        KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                        e.setId(IdWorker.getId());
                        e.setUuid(indexName + ":" + id);
                        e.setItemId(entity.getId());
                        e.setContent(segment.text());
                        e.setInitContent(segment.text());
                        e.setSliceState(1);
                        e.setType(1);
                        e.setSequence(segments.size() - i);
                        list.add(e);
                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(e.getId());
                        p.setUuid(indexName + ":" + id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(1);
                        listPoints.add(p);
                    }
                    if (list != null && list.size() > 0) {
                        this.knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                        this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    entity.setEmbeddingCount(segments.size());
                    entity.setEmbeddingStatus(3);
                    this.saveOrUpdate((Object)entity, false);
                }
                catch (Exception e) {
                    this.logger.error("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
                    entity.setEmbeddingStatus(4);
                    this.saveOrUpdate((Object)entity, false);
                    EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
                }
            };
            new Thread(task).start();
        } else {
            entity.setEmbeddingStatus(1);
            this.saveOrUpdate((Object)entity, false);
            String[] allText = document.text().split("\n");
            if (allText.length < 2) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u6b63\u786e");
            }
            CharSequence[] titles = allText[1].split("\t");
            KnowledgeItemTableIndexEntity indexEntity = new KnowledgeItemTableIndexEntity();
            indexEntity.setItemId(entity.getId());
            indexEntity.setTitles(String.join((CharSequence)",", titles));
            this.knowledgeItemTableIndexService.saveOrUpdate((Object)indexEntity, false);
        }
        KnowledgeItemVO vo = (KnowledgeItemVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeItemVO.class));
        return vo;
    }

    @Override
    public KnowledgeItemVO saveData(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemEntity entity = (KnowledgeItemEntity)((Object)this.knowledgeItemMapper.selectById(saveOrUpdateVO.getId()));
        entity.setBrief(saveOrUpdateVO.getBrief());
        entity.setFileState(saveOrUpdateVO.getFileState());
        entity.setSequence(saveOrUpdateVO.getSequence());
        this.saveOrUpdate((Object)entity, false);
        KnowledgeItemVO vo = (KnowledgeItemVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeItemVO.class));
        return vo;
    }

    @Override
    public void delData(List<Long> ids) {
        QueryWrapper wrapperEmbedding = new QueryWrapper();
        wrapperEmbedding.in((Object)"item_id", ids);
        List list = this.knowledgeEmbeddingService.list((Wrapper)wrapperEmbedding);
        if (list != null && list.size() > 0) {
            ArrayList embeddingIds = new ArrayList();
            list.forEach(item -> embeddingIds.add(item.getId()));
            QueryWrapper wrapperEmbeddingPoints = new QueryWrapper();
            wrapperEmbeddingPoints.in((Object)"embedding_id", embeddingIds);
            List points = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapperEmbeddingPoints);
            KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(ids.get(0));
            String indexName = knowledgeBase.getCode();
            if (points != null && points.size() > 0) {
                ArrayList rids = new ArrayList();
                points.forEach(item -> rids.add(item.getUuid()));
                EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.removeAll(rids);
            }
            this.knowledgeEmbeddingService.remove((Wrapper)wrapperEmbedding);
            this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapperEmbeddingPoints);
        }
        this.removeByIds(ids, true);
    }

    @Override
    public List<KnowledgeItemEntity> queryKnowlegeItemList(String embeddingIds) {
        List<KnowledgeItemEntity> itemList = this.knowledgeItemMapper.queryKnowlegeItemList(embeddingIds);
        return itemList;
    }

    @Override
    public void updateReferenceCount(Long id) {
        this.knowledgeItemMapper.updateReferenceCount(id);
    }

    private void setInvocation(String authority) {
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            String[] ac;
            HashSet<Cookie> cookieSet = new HashSet<Cookie>();
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                String key = StringUtils.trim((String)cookieArr[0]);
                String value = StringUtils.trim((String)cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            Cookie[] cookies = cookieSet.toArray(new Cookie[0]);
            InvocationInfoProxy.setToken((String)CookieUtil.findCookieValue((Cookie[])cookies, (String)"token"));
            InvocationInfoProxy.setUserid((Long)Long.parseLong(CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_usercode")));
            InvocationInfoProxy.setUsercode((String)CookieUtil.findCookieValue((Cookie[])cookies, (String)"userCode"));
            InvocationInfoProxy.setTenantid((Long)Long.parseLong(CookieUtil.findCookieValue((Cookie[])cookies, (String)"tenantid")));
        }
    }

    @Override
    public void insertKnowledgeItemDispatch(HttpServletRequest request) {
        List kbmResultList;
        final String authority = request.getHeader("authority");
        final RequestAttributes context = RequestContextHolder.getRequestAttributes();
        context.setAttribute("authority", (Object)authority, 0);
        CommonResponse kbmResultResp = this.kbmApi.queryKbmFileList();
        if (kbmResultResp.isSuccess() && (kbmResultList = (List)kbmResultResp.getData()) != null && kbmResultList.size() > 0) {
            Long prevkbmId = null;
            for (int i = 0; i < kbmResultList.size(); ++i) {
                final KbmResult kbmResult = (KbmResult)kbmResultList.get(i);
                if (prevkbmId != null && prevkbmId != kbmResult.getKbmId()) {
                    this.kbmApi.updateKbmEmbeddingState(prevkbmId);
                }
                prevkbmId = kbmResult.getKbmId();
                if (i == kbmResultList.size() - 1) {
                    this.kbmApi.updateKbmEmbeddingState(kbmResult.getKbmId());
                }
                this.ejcThreadPoolUtils.runTask(new Runnable(){

                    @Override
                    public void run() {
                        RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                        KnowledgeItemServiceImpl.this.setInvocation(authority);
                        try {
                            KnowledgeBaseEntity knowledgeBase = (KnowledgeBaseEntity)((Object)KnowledgeItemServiceImpl.this.knowledgeBaseService.selectById(kbmResult.getTenantId()));
                            if (knowledgeBase == null) {
                                knowledgeBase = new KnowledgeBaseEntity();
                                knowledgeBase.setId(kbmResult.getTenantId());
                                knowledgeBase.setCode(kbmResult.getTenantId() + "");
                                CommonResponse tenantResp = KnowledgeItemServiceImpl.this.tenantApi.queryDetail(kbmResult.getTenantId());
                                if (tenantResp.isSuccess()) {
                                    knowledgeBase.setName(((TenantVO)tenantResp.getData()).getName());
                                }
                                knowledgeBase.setKnowledgeType(1);
                                knowledgeBase.setSequence(0);
                                KnowledgeItemServiceImpl.this.knowledgeBaseService.saveOrUpdate((Object)knowledgeBase, false);
                            }
                        }
                        catch (Exception knowledgeBase) {
                            // empty catch block
                        }
                        try {
                            KnowledgeCategoryEntity categoryEntity = new KnowledgeCategoryEntity();
                            categoryEntity.setId(kbmResult.getTenantId());
                            categoryEntity.setName("\u9ed8\u8ba4\u5206\u7c7b");
                            categoryEntity.setKnowledgeBaseId(kbmResult.getTenantId());
                            categoryEntity.setInnerCode(kbmResult.getTenantId() + "");
                            KnowledgeItemServiceImpl.this.knowledgeCategoryService.save((Object)categoryEntity);
                        }
                        catch (Exception categoryEntity) {
                            // empty catch block
                        }
                        String indexName = kbmResult.getTenantId() + "";
                        KnowledgeItemEntity entity = new KnowledgeItemEntity();
                        entity.setId(IdWorker.getId());
                        entity.setKnowledgeBaseId(kbmResult.getTenantId());
                        entity.setCategoryId(kbmResult.getTenantId());
                        entity.setFileCode(KnowledgeItemServiceImpl.this.generateCode());
                        entity.setFileId(kbmResult.getFileId());
                        entity.setFileName(kbmResult.getFileName());
                        entity.setFilePath(kbmResult.getFilePath());
                        entity.setFileSize(kbmResult.getFileSize());
                        entity.setOnlinePath(KnowledgeItemServiceImpl.this.baseHost + "ejc-file-web/onlinePreview?fileId=" + kbmResult.getFileId());
                        entity.setFileSuffix(FilenameUtils.getExtension((String)kbmResult.getFilePath()));
                        entity.setFileState(1);
                        entity.setKnowledgeType(1);
                        entity.setSliceStrategy(1);
                        entity.setSliceIdentifier("paragraph");
                        entity.setSliceMaxLength(400);
                        entity.setSliceOverlap(10);
                        Document document = KnowledgeItemServiceImpl.this.documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
                        if (StringUtils.isBlank((CharSequence)entity.getBrief()) && StringUtils.isNotBlank((CharSequence)document.text())) {
                            if (document.text().length() > 300) {
                                entity.setBrief(document.text().substring(0, 300));
                            } else {
                                entity.setBrief(document.text());
                            }
                        }
                        List allRedisIds = new ArrayList();
                        try {
                            DocumentByParagraphSplitter documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, 10);
                            EmbeddingModel embeddingModel = KnowledgeItemServiceImpl.this.ejcAiEmbeding.getEmbeddingModel(indexName);
                            EmbeddingStore<TextSegment> embeddingStore = KnowledgeItemServiceImpl.this.ejcAiEmbeding.getEmbeddingStore(indexName);
                            JSONObject json = KnowledgeItemServiceImpl.this.documentSplitUtil.documentSplitStore(document, (DocumentSplitter)documentSplitter, embeddingModel, embeddingStore);
                            List segments = (List)json.get((Object)"segments");
                            List embeddings = (List)json.get((Object)"embeddings");
                            allRedisIds = (List)json.get((Object)"redisIds");
                            ArrayList<KnowledgeEmbeddingEntity> list = new ArrayList<KnowledgeEmbeddingEntity>();
                            ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
                            for (int i = 0; i < segments.size(); ++i) {
                                TextSegment segment = (TextSegment)segments.get(i);
                                Embedding embedding = (Embedding)embeddings.get(i);
                                String id = (String)allRedisIds.get(i);
                                KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                                e.setId(IdWorker.getId());
                                e.setUuid(indexName + ":" + id);
                                e.setItemId(entity.getId());
                                e.setContent(segment.text());
                                e.setInitContent(segment.text());
                                e.setSliceState(1);
                                e.setType(1);
                                e.setSequence(segments.size() - i);
                                list.add(e);
                                KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                                p.setEmbeddingId(e.getId());
                                p.setUuid(indexName + ":" + id);
                                p.setContent(segment.text());
                                p.setInitContent(segment.text());
                                p.setVector(Arrays.toString(embedding.vector()));
                                p.setType(1);
                                p.setSequence(1);
                                listPoints.add(p);
                            }
                            if (list != null && list.size() > 0) {
                                KnowledgeItemServiceImpl.this.knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                                KnowledgeItemServiceImpl.this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                            }
                            entity.setEmbeddingCount(segments.size());
                            entity.setEmbeddingStatus(3);
                            KnowledgeItemServiceImpl.this.knowledgeItemMapper.insert((Object)entity);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

