/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemTableIndexEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeItemTableIndexMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.service.IKnowledgeItemTableIndexService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeItemTableIndexVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeItemTableIndexService")
public class KnowledgeItemTableIndexServiceImpl
extends BaseServiceImpl<KnowledgeItemTableIndexMapper, KnowledgeItemTableIndexEntity>
implements IKnowledgeItemTableIndexService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeItemService itemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;

    @Override
    public void configTableIndex(KnowledgeItemTableIndexVO vo) {
        KnowledgeItemTableIndexEntity old = (KnowledgeItemTableIndexEntity)((Object)this.selectById(vo.getId()));
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(old.getItemId());
        String indexName = knowledgeBase.getCode();
        if (StringUtils.isNotBlank((CharSequence)old.getIndexs())) {
            QueryWrapper wrapperEmbedding = new QueryWrapper();
            wrapperEmbedding.eq((Object)"item_id", (Object)vo.getItemId());
            wrapperEmbedding.in((Object)"type", new Object[]{1, 3});
            List items = this.knowledgeEmbeddingService.list((Wrapper)wrapperEmbedding);
            if (items != null && items.size() > 0) {
                ArrayList embeddingIds = new ArrayList();
                items.forEach(item -> embeddingIds.add(item.getId()));
                QueryWrapper wrapperEmbeddingPoints = new QueryWrapper();
                wrapperEmbeddingPoints.in((Object)"embedding_id", embeddingIds);
                wrapperEmbeddingPoints.in((Object)"type", new Object[]{1, 3});
                List points = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapperEmbeddingPoints);
                if (points != null && points.size() > 0) {
                    ArrayList rids = new ArrayList();
                    points.forEach(item -> rids.add(item.getUuid()));
                    EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(rids);
                }
                this.knowledgeEmbeddingService.remove((Wrapper)wrapperEmbedding);
                this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapperEmbeddingPoints);
            }
        }
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.itemService.selectById(vo.getItemId()));
        if (StringUtils.isBlank((CharSequence)vo.getIndexs())) {
            throw new BusinessException("\u7d22\u5f15\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] indexs = vo.getIndexs().split(",");
        itemEntity.setEmbeddingStatus(2);
        this.itemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeItemTableIndexEntity entity = (KnowledgeItemTableIndexEntity)((Object)BeanMapper.map((Object)((Object)vo), KnowledgeItemTableIndexEntity.class));
        this.saveOrUpdate((Object)entity, false);
        HashMap<String, Object> invocationInfo = new HashMap<String, Object>();
        invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute((String)"authority"));
        invocationInfo.put("callid", InvocationInfoProxy.getCallid());
        invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
        invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
        invocationInfo.put("locale", InvocationInfoProxy.getLocale());
        invocationInfo.put("logints", InvocationInfoProxy.getLogints());
        invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
        invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
        invocationInfo.put("theme", InvocationInfoProxy.getTheme());
        invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
        invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
        invocationInfo.put("userid", InvocationInfoProxy.getUserid());
        invocationInfo.put("userType", InvocationInfoProxy.getUserType());
        Runnable task = () -> {
            InvocationInfoProxy.setCallid(invocationInfo.get("callid") != null ? invocationInfo.get("callid").toString() : null);
            InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("tenantid").toString())) : null);
            InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("employeeId").toString())) : null);
            InvocationInfoProxy.setLocale(invocationInfo.get("locale") != null ? invocationInfo.get("locale").toString() : null);
            InvocationInfoProxy.setLogints(invocationInfo.get("logints") != null ? invocationInfo.get("logints").toString() : null);
            InvocationInfoProxy.setOrgId(invocationInfo.get("orgId") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("orgId").toString())) : null);
            InvocationInfoProxy.setSysid(invocationInfo.get("sysid") != null ? invocationInfo.get("sysid").toString() : null);
            InvocationInfoProxy.setTheme(invocationInfo.get("theme") != null ? invocationInfo.get("theme").toString() : null);
            InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone") != null ? invocationInfo.get("timeZone").toString() : null);
            InvocationInfoProxy.setUsercode(invocationInfo.get("usercode") != null ? invocationInfo.get("usercode").toString() : null);
            InvocationInfoProxy.setUserid(invocationInfo.get("userid") != null ? Long.valueOf(Long.parseLong(invocationInfo.get("userid").toString())) : null);
            InvocationInfoProxy.setUserType(invocationInfo.get("userType") != null ? invocationInfo.get("userType").toString() : null);
            InvocationInfoProxy.setExtendAttribute((Object)"authority", invocationInfo.get("authority") != null ? invocationInfo.get("authority").toString() : null);
            ArrayList allRedisIds = new ArrayList();
            try {
                Document document = this.documentSplitUtil.loadDocument(itemEntity.getFileSuffix(), itemEntity.getFilePath());
                String[] allText = document.text().split("\n");
                String[] titles = null;
                Integer embeddingCount = 0;
                for (int i = 1; i < allText.length; ++i) {
                    ArrayList<TextSegment> documents = new ArrayList<TextSegment>();
                    ArrayList<KnowledgeEmbeddingEntity> embeddingEntitys = new ArrayList<KnowledgeEmbeddingEntity>();
                    ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
                    String lineData = allText[i];
                    String[] items = lineData.split("\t");
                    if (i == 1) {
                        titles = items;
                    } else {
                        JSONObject ob = new JSONObject();
                        String o = "";
                        for (int j = 0; j < items.length; ++j) {
                            o = o + titles[j] + ": " + items[j] + " ";
                            ob.put(titles[j], (Object)items[j]);
                        }
                        TextSegment s = TextSegment.from(o);
                        documents.add(s);
                        Long embeddingId = IdWorker.getId();
                        KnowledgeEmbeddingEntity embeddingEntity = new KnowledgeEmbeddingEntity();
                        embeddingEntity.setItemId(itemEntity.getId());
                        embeddingEntity.setId(embeddingId);
                        embeddingEntity.setType(1);
                        embeddingEntity.setSliceState(1);
                        embeddingEntity.setContent(o);
                        embeddingEntity.setInitContent(ob.toJSONString());
                        embeddingEntity.setTableContent(ob.toJSONString());
                        embeddingEntity.setSequence(allText.length - 1 - i);
                        embeddingEntitys.add(embeddingEntity);
                        for (int j = 0; j < indexs.length; ++j) {
                            String index = indexs[j];
                            documents.add(TextSegment.from(index + ": " + ob.getString(index)));
                        }
                        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
                        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                        JSONObject json = this.documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                        List embeddings = (List)json.get((Object)"embeddings");
                        List redisIds = (List)json.get((Object)"redisIds");
                        allRedisIds.addAll(redisIds);
                        for (int j = 0; j < documents.size(); ++j) {
                            TextSegment segment = (TextSegment)documents.get(j);
                            Embedding embedding = (Embedding)embeddings.get(j);
                            String id = (String)redisIds.get(j);
                            KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                            p.setEmbeddingId(embeddingId);
                            p.setUuid(indexName + ":" + id);
                            p.setContent(segment.text());
                            p.setInitContent(segment.text());
                            p.setVector(Arrays.toString(embedding.vector()));
                            p.setType(1);
                            p.setSequence(documents.size() - j);
                            listPoints.add(p);
                        }
                    }
                    if (embeddingEntitys != null && embeddingEntitys.size() > 0) {
                        this.knowledgeEmbeddingService.saveOrUpdateBatch(embeddingEntitys, embeddingEntitys.size(), false);
                    }
                    if (listPoints != null && listPoints.size() > 0) {
                        this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    embeddingCount = embeddingCount + listPoints.size();
                }
                itemEntity.setEmbeddingStatus(3);
                itemEntity.setEmbeddingCount(embeddingCount);
                this.itemService.saveOrUpdate((Object)itemEntity, false);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
                itemEntity.setEmbeddingStatus(4);
                this.itemService.saveOrUpdate((Object)itemEntity, false);
                EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.removeAll(allRedisIds);
                throw new BusinessException("\u751f\u6210\u5411\u91cf\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
            }
        };
        new Thread(task).start();
    }
}

