/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.cache;

import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.cache.utils.LockUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Configuration
@ConfigurationProperties(prefix="ejc.redis")
public class CacheConfiguration {
    private static final String REDIS_DIRECT = "direct://";
    private int maxTotal = 100;
    private int maxIdle = 100;
    private int minIdle = 0;
    private long maxWaitMillis = 30000L;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = true;
    private boolean testWhileIdle = false;
    private String hostName = "127.0.0.1";
    private int port = 6379;
    private String password;
    private int timeout = 10000;
    private int database = 0;

    @Bean
    public GenericObjectPoolConfig<Jedis> getJedisPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        if (this.maxTotal <= 100) {
            config.setMaxTotal(100);
            config.setMaxIdle(100);
        } else {
            config.setMaxTotal(this.maxTotal);
            config.setMaxIdle(this.maxIdle);
        }
        config.setMinIdle(this.minIdle);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestOnReturn(this.testOnReturn);
        config.setTestWhileIdle(this.testWhileIdle);
        config.setMinEvictableIdleTimeMillis(60000L);
        config.setJmxEnabled(false);
        return config;
    }

    @Bean
    public JedisPool getJedisPool() {
        return new JedisPool(this.getJedisPoolConfig(), this.hostName, this.port, this.timeout, this.password, this.database);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisTemplate<String, Object> getRedisTemplate() {
        return new RedisTemplate<String, Object>(this.getJedisPool());
    }

    @Bean(value={"jedisPool"})
    public JedisPool getRedisPoolFactory() {
        JedisPool jedisPool = new JedisPool(this.getJedisPoolConfig(), this.hostName, this.port, 5000, this.password);
        return jedisPool;
    }

    @Bean
    public CacheManager getCacheManager() {
        CacheManager cacheManager = new CacheManager();
        cacheManager.setJedisPool(this.getRedisPoolFactory());
        return cacheManager;
    }

    @Bean(destroyMethod="shutdown")
    public RedissonClient getRedissonClient() {
        Config config = new Config();
        SingleServerConfig serverConfig = ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress("redis://" + this.hostName + ":" + this.port).setTimeout(this.timeout)).setPingConnectionInterval(10000)).setDatabase(0);
        if (StringUtils.isNotBlank((String)this.password)) {
            serverConfig.setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }

    @Bean
    public RedissonLocker getRedissonLocker() {
        RedissonLocker locker = new RedissonLocker(this.getRedissonClient());
        LockUtil.setLocker(locker);
        return locker;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}

