/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import com.ejianc.foundation.ai.config.AuthHeaderUtils;
import com.ejianc.foundation.ai.service.IExtDictService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.cfg.DefaultConfig;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;

public class Dictionary {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _StopWordDict;
    private DictSegment _QuantifierDict;
    private Configuration cfg;

    private Dictionary(Configuration cfg) {
        this.cfg = cfg;
        this.loadMainDict();
        this.loadStopWordDict();
        this.loadQuantifierDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial(Configuration cfg) {
        if (singleton != null) return;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return;
            singleton = new Dictionary(cfg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("\u8bcd\u5178\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initial\u65b9\u6cd5");
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadDic(List<Reader> inputStreamReaderList) {
        if (singleton == null) {
            Configuration cfg = DefaultConfig.getInstance();
            Dictionary.initial(cfg);
        }
        for (Reader in : inputStreamReaderList) {
            try {
                String theWord;
                LineNumberReader br = new LineNumberReader(in);
                while ((theWord = br.readLine()) != null) {
                    if (theWord.trim().length() == 0 || theWord.trim().charAt(0) == '#') continue;
                    Dictionary.singleton._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                }
            }
            catch (IOException ioe) {
                System.err.println("Other Dictionary loading exception.");
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWordDict.match(charArray, begin, length).isMatch();
    }

    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        if (this.cfg.useMainDict()) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.cfg.getMainDictionary());
            if (is == null) {
                throw new RuntimeException("Main Dictionary not found!!!");
            }
            try {
                this.readDict(is, this._MainDict);
            }
            catch (IOException ioe) {
                System.err.println("Main Dictionary loading exception.");
                ioe.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.loadExtDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtDict() {
        List<String> extDictFiles = this.cfg.getExtDictionarys();
        if (extDictFiles != null) {
            for (String extDictName : extDictFiles) {
                System.out.println("Load extended dictionary:" + extDictName);
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(extDictName);
                if (is == null) continue;
                try {
                    this.readDict(is, this._MainDict);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String knowledgeBaseCode = AuthHeaderUtils.getKnowledgeBaseCode();
        IExtDictService extDictService = (IExtDictService)ContextUtil.getBean((String)"extDictService", IExtDictService.class);
        List<String> list = extDictService.getFields(knowledgeBaseCode);
        if (list != null && list.size() > 0) {
            if (extDictFiles != null && extDictFiles.size() > 0) {
                extDictFiles.addAll(list);
            } else {
                extDictFiles = list;
            }
        }
        if (extDictFiles != null && extDictFiles.size() > 0) {
            this.logger.info("\u6269\u5c55\u5b57\u6bb5\uff1a");
            this.logger.info(extDictFiles.stream().collect(Collectors.joining(",")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict() {
        this._StopWordDict = new DictSegment(Character.valueOf('\u0000'));
        List extStopWordDictFiles = this.cfg.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            for (String extStopWordDictName : extStopWordDictFiles) {
                System.out.println("Load stopwords dictionary:" + extStopWordDictName);
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(extStopWordDictName);
                if (is == null) continue;
                try {
                    this.readDict(is, this._StopWordDict);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Stop word Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.cfg.getQuantifierDicionary());
        if (is == null) {
            throw new RuntimeException("Quantifier Dictionary not found!!!");
        }
        try {
            this.readDict(is, this._QuantifierDict);
        }
        catch (IOException ioe) {
            System.err.println("Quantifier Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readDict(InputStream is, DictSegment dictSegment) throws IOException {
        String theWord;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8), 512);
        do {
            if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
            dictSegment.fillSegment(theWord.trim().toLowerCase().toCharArray());
        } while (theWord != null);
    }
}

