/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.vo.KnowledgeBaseVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"knowledgeBase"})
public class KnowledgeBaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeBaseService service;
    @Autowired
    private EnvironmentTools environmentTools;
    @Value(value="${refer.base-host:null}")
    private String baseHost;

    public String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode() {
        String code = "";
        try {
            String str;
            code = str = this.generateRandomString(10);
            boolean flag = true;
            while (flag) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"code", (Object)code);
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                List list = this.service.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    code = str + this.generateRandomString(4);
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7f16\u7801\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u7f16\u7801\u5931\u8d25");
        }
        return code;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> saveOrUpdate(@RequestBody KnowledgeBaseVO saveOrUpdateVO) {
        KnowledgeBaseEntity entity = (KnowledgeBaseEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeBaseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String code = this.generateCode();
            entity.setCode(code);
            entity.setReferenceCount(0);
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        KnowledgeBaseEntity uniqueBean = (KnowledgeBaseEntity)((Object)this.service.selectById(entity.getId()));
        uniqueBean.setName(entity.getName());
        uniqueBean.setKnowledgeType(entity.getKnowledgeType());
        uniqueBean.setRetrieveMaxResults(entity.getRetrieveMaxResults());
        uniqueBean.setRetrieveMinScore(entity.getRetrieveMinScore());
        uniqueBean.setSequence(entity.getSequence());
        uniqueBean.setRemark(entity.getRemark());
        this.service.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> queryDetail(Long id) {
        KnowledgeBaseEntity entity = (KnowledgeBaseEntity)((Object)this.service.selectById(id));
        KnowledgeBaseVO vo = (KnowledgeBaseVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeBaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KnowledgeBaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KnowledgeBaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        String referBaseHost = "";
        referBaseHost = StringUtils.isNotBlank((CharSequence)this.baseHost) && !"null".equals(this.baseHost) ? this.baseHost : this.environmentTools.getBaseHost();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();
        switch (refCode) {
            case "ai_knowledgebase_referList": {
                refer.setRefCode("knowledgeBase");
                refer.setRefName("AI\u77e5\u8bc6\u5e93");
                refer.setRefType("grid");
                refer.setDataurl(referBaseHost + "ejc-ai-web/knowledgeBase/queryKnowledgeBaseRefList");
                refer.setIdField("id");
                refer.setCodeField("code");
                refer.setNameField("name");
                refer.setId(Long.valueOf(new Date().getTime()));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(1));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(Long.valueOf(2L));
                entityHeader.setName("\u77e5\u8bc6\u5e93\u7f16\u7801");
                entityHeader.setCode("code");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(Integer.valueOf(1));
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(Long.valueOf(3L));
                displayHeader.setName("\u77e5\u8bc6\u5e93\u540d\u79f0");
                displayHeader.setCode("name");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(Integer.valueOf(1));
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(Long.valueOf(4L));
                entityFullHeader.setName("\u77e5\u8bc6\u5e93\u7c7b\u578b");
                entityFullHeader.setCode("knowledgeTypeName");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(Integer.valueOf(1));
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)refer);
        return CommonResponse.success((Object)refer);
    }

    @RequestMapping(value={"/queryKnowledgeBaseRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KnowledgeBaseVO>> queryKnowledgeBaseRefList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        IPage pageData = this.service.queryPage(queryParam);
        Page pageResult = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if (pageData != null && pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            ArrayList<KnowledgeBaseVO> knowledgeVos = new ArrayList<KnowledgeBaseVO>();
            for (KnowledgeBaseEntity entity : pageData.getRecords()) {
                KnowledgeBaseVO knowledgeBaseVO = (KnowledgeBaseVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeBaseVO.class));
                if (entity.getKnowledgeType() == 1) {
                    knowledgeBaseVO.setKnowledgeTypeName("\u6587\u672c\u578b\u77e5\u8bc6\u5e93");
                } else {
                    knowledgeBaseVO.setKnowledgeTypeName("\u8868\u683c\u578b\u77e5\u8bc6\u5e93");
                }
                knowledgeVos.add(knowledgeBaseVO);
            }
            pageResult.setRecords(knowledgeVos);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)pageResult);
    }

    @RequestMapping(value={"/hitTest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONArray> hitTest(@RequestParam String text, @RequestParam Long baseId) {
        return this.service.hitTest(baseId, text);
    }
}

