/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.foundation.ai.utils.ThreadPoolUtils;
import com.ejianc.foundation.ai.vo.material.AiMaterialParam;
import com.ejianc.foundation.ai.vo.material.AiMaterialTrainVO;
import com.ejianc.foundation.ai.vo.material.AiMaterialVO;
import com.ejianc.foundation.ai.vo.material.Category;
import com.ejianc.foundation.ai.vo.material.ExtProperty;
import com.ejianc.foundation.ai.vo.material.MatchProperty;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class MaterialAiApi {
    private static final Logger logger = LoggerFactory.getLogger(QianfanUtils.class);
    @Value(value="${ejc.ai.train.driver:com.mysql.jdbc.Driver}")
    private String driver;
    @Value(value="${ejc.ai.train.jdbcaddr:47.93.115.124")
    private String jdbcaddr;
    @Value(value="${ejc.ai.train.jdbcport:30236")
    private String jdbcport;
    @Value(value="${ejc.ai.train.username:root")
    private String username;
    @Value(value="${ejc.ai.train.username:y7rkeucv87no5j9")
    private String password;
    @Value(value="${ejc.ai.material.AppBuilderAppID:e5fcc66c-a174-4efe-9b21-bda373cc8816")
    private static String AppBuilderAppID;
    @Value(value="${ejc.ai.material.AppBuilderSecretKey:Bearer bce-v3/ALTAK-2M4n5pMZ8iRjJiaD7Ww5N/86fae65df7bef687132a4a0606bfe98e0b1e0747")
    private static String AppBuilderSecretKey;

    @RequestMapping(value={"/ai/material/recognize"}, method={RequestMethod.POST})
    CommonResponse<List<AiMaterialVO>> aiMaterialRecognize(@RequestBody List<AiMaterialParam> aiMaterialParams) {
        Future future;
        if (ListUtil.isEmpty(aiMaterialParams)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e3a\u7a7a!");
        }
        logger.info("\u8bf7\u6c42\u6570\u91cf\uff1a" + aiMaterialParams.size());
        ArrayList<AiMaterialVO> resList = new ArrayList<AiMaterialVO>();
        ArrayList<Future> futureList = new ArrayList<Future>();
        ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
        HashMap<String, Future> futureMap = new HashMap<String, Future>();
        for (AiMaterialParam param : aiMaterialParams) {
            future = threadPoolUtils.runTask(() -> {
                StringBuilder content = new StringBuilder();
                content.append("\"\u9879\u76ee\u63cf\u8ff0\":\"").append(param.getItemName()).append("\",");
                content.append("\"\u9879\u76ee\u7279\u5f81\u63cf\u8ff0\":\"").append(param.getItemDesc()).append("\";\n");
                content.append("\u8bf7\u6839\u636e\u63d0\u4f9b\u7684\u6570\u636e\u4fe1\u606f\u8bc6\u522b\u51fa\u5176\u5206\u7c7b\u548c\u5c5e\u6027\uff0c\u5c5e\u6027\u5728\u77e5\u8bc6\u5e93\u4e2d\u5339\u914d\u4e0d\u4e0a\u7684\uff0c\u4f5c\u4e3a\u6269\u5c55\u5c5e\u6027\u5217\u51fa\uff0c\u7ed3\u679c\u4ee5JSON\u683c\u5f0f\u7ed9\u51fa\uff0c\u4ee5\u4fbf\u53ef\u4ee5\u76f4\u63a5\u4f7f\u7528JSON.parse()\u65b9\u6cd5\u89e3\u6790\u7ed3\u679c\uff0c\u4e0d\u8981\u9644\u52a0\u5176\u4ed6\u5206\u6790\u6027\u8bed\u53e5\u3002");
                return QianfanUtils.postChatMsg(content.toString(), AppBuilderAppID, AppBuilderSecretKey);
            });
            futureList.add(future);
            futureMap.put(param.getId(), future);
        }
        for (String key : futureMap.keySet()) {
            future = (Future)futureMap.get(key);
            try {
                String result = (String)future.get();
                JSONObject qFanContent = JSON.parseObject((String)result);
                String answer = qFanContent.getString("answer");
                logger.info("\u8bf7\u6c42 id={},\u8fd4\u56deanswer={}", (Object)key, (Object)answer);
                if (!StringUtils.isNotBlank((String)answer) || !answer.contains("```json")) continue;
                answer = answer.split("```json")[1];
                answer = answer.split("```")[0];
                JSONObject jsonObject = JSON.parseObject((String)answer);
                AiMaterialVO aiMaterialVO = new AiMaterialVO();
                aiMaterialVO.setId(key);
                Category category = new Category();
                category.setCategoryId(jsonObject.getJSONObject("\u5206\u7c7b\u4fe1\u606f").getString("\u5206\u7c7bID"));
                category.setCategoryName(jsonObject.getJSONObject("\u5206\u7c7b\u4fe1\u606f").getString("\u5206\u7c7b\u540d\u79f0"));
                aiMaterialVO.setCategory(category);
                if (jsonObject.getJSONArray("\u5339\u914d\u5c5e\u6027") != null) {
                    ArrayList<MatchProperty> matchProperties = new ArrayList<MatchProperty>();
                    for (Object obj : jsonObject.getJSONArray("\u5339\u914d\u5c5e\u6027")) {
                        JSONObject mp = (JSONObject)obj;
                        MatchProperty matchProperty = new MatchProperty();
                        matchProperty.setPropertyId(mp.getString("\u5c5e\u6027ID"));
                        matchProperty.setPropertyName(mp.getString("\u5c5e\u6027\u540d\u79f0"));
                        matchProperty.setPropertyValueId(mp.getString("\u5c5e\u6027\u503cID"));
                        matchProperty.setPropertyValue(mp.getString("\u5c5e\u6027\u503c"));
                        matchProperties.add(matchProperty);
                    }
                    aiMaterialVO.setMatchProperties(matchProperties);
                }
                if (jsonObject.getJSONArray("\u6269\u5c55\u5c5e\u6027") != null) {
                    ArrayList<ExtProperty> extProperties = new ArrayList<ExtProperty>();
                    for (Object obj : jsonObject.getJSONArray("\u6269\u5c55\u5c5e\u6027")) {
                        JSONObject ep = (JSONObject)obj;
                        ExtProperty extProperty = new ExtProperty();
                        extProperty.setPropertyKey(ep.getString("\u5c5e\u6027\u540d\u79f0"));
                        extProperty.setPropertyValue(ep.getString("\u5c5e\u6027\u503c"));
                        extProperties.add(extProperty);
                    }
                    aiMaterialVO.setExtProperties(extProperties);
                }
                resList.add(aiMaterialVO);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        logger.info("\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u6570\u91cf\uff1a{}\uff0c\u8bf7\u6c42\u6570\u91cf\uff1a{}", (Object)resList.size(), (Object)aiMaterialParams.size());
        return CommonResponse.success(resList);
    }

    @RequestMapping(value={"/ai/material/train"}, method={RequestMethod.POST})
    CommonResponse<String> putMaterial2AiTrain(@RequestBody List<AiMaterialTrainVO> aiMaterialTrainVos) {
        if (aiMaterialTrainVos != null && aiMaterialTrainVos.size() > 0) {
            for (AiMaterialTrainVO aiMaterialTrainVO : aiMaterialTrainVos) {
                if (aiMaterialTrainVO.getCategoryId() == null || StringUtils.isBlank((String)aiMaterialTrainVO.getCategoryName()) || aiMaterialTrainVO.getPropertyId() == null || StringUtils.isBlank((String)aiMaterialTrainVO.getPropertyName())) continue;
                String insertSql = "insert into ejc_ai_material(id,categoryid,categoryname,propertyid,propertyname)  values(" + IdWorker.getId() + ",'" + aiMaterialTrainVO.getCategoryId() + "','" + aiMaterialTrainVO.getCategoryName() + "' ,'" + aiMaterialTrainVO.getPropertyId() + "','" + aiMaterialTrainVO.getPropertyName() + "')";
                String string = "jdbc:mysql://" + this.jdbcaddr + ":" + this.jdbcport + "/ejc-ai?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false&allowMultiQueries=true";
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f!");
    }
}

