/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/receiptAi1"})
public class ReceiptAiApi1 {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().readTimeout(180L, TimeUnit.SECONDS).build();
    @Value(value="${ejc.ai.train.AppBuilderAppID:88796cca-a864-4617-ba72-850e333352ea}")
    private String AppBuilderAppID;
    @Value(value="${ejc.ai.train.AppBuilderSecretKey:Bearer bce-v3/ALTAK-l39HjVaikGeUyvhYR3fJ9/acf6cc3782f9b3d9fc5dd58be0d8dd244655e50c}")
    private String AppBuilderSecretKey;

    @RequestMapping(value={"identify"}, method={RequestMethod.GET})
    public CommonResponse<String> identify(String imageUrl, String imageName) {
        String conversationId = QianfanAppBuilderUtil.getNewConversationId(this.AppBuilderAppID, this.AppBuilderSecretKey);
        try {
            String fileId = QianfanAppBuilderUtil.uploadLocalFile(this.AppBuilderAppID, this.AppBuilderSecretKey, conversationId, imageUrl, imageName);
            JSONObject para = new JSONObject();
            para.put("app_id", (Object)this.AppBuilderAppID);
            para.put("query", (Object)"\u4ece\u56fe\u7247\u4e2d\u63d0\u53d6\u51fa\u591a\u6761\u7269\u6599\u540d\u79f0\u3001\u89c4\u683c\u578b\u53f7\u3001\u5355\u4f4d\u3001\u6570\u91cf\u3001\u5355\u4ef7\u3001\u91d1\u989d\uff0c\u5e76\u4ee5JSON\u6570\u7ec4\u8f93\u51fa");
            para.put("conversation_id", (Object)conversationId);
            para.put("stream", (Object)false);
            para.put("file_ids", Arrays.asList(fileId));
            this.logger.info("================\u53c2\u6570=============================");
            this.logger.info(JSONObject.toJSONString((Object)para, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.info("================================================");
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)para.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation/runs").method("POST", body).addHeader("Content-Type", "application/json").addHeader("X-Appbuilder-Authorization", this.AppBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject((String)response.body().string());
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank((String)answer) && answer.contains("```json")) {
                answer = answer.split("```json")[1];
                answer = answer.split("```")[0];
                JSONArray objects = JSONArray.parseArray((String)answer);
                this.logger.info("=================\u7ed3\u679c===========================");
                for (Object object : objects) {
                    this.logger.info(JSONObject.toJSONString(object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                this.logger.info("================================================");
                return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)objects.toJSONString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"identifyMaterial"}, method={RequestMethod.GET})
    public CommonResponse<String> identifyMaterial() {
        String conversationId = QianfanAppBuilderUtil.getNewConversationId(this.AppBuilderAppID, this.AppBuilderSecretKey);
        try {
            JSONObject para = new JSONObject();
            para.put("app_id", (Object)this.AppBuilderAppID);
            para.put("query", (Object)"\u5728\u77e5\u8bc6\u5e93\u6587\u6863\u4e2d\uff0c\u6839\u636e\u7269\u6599\u540d\u79f0\uff1a\u5361\u677f\u52a0\u6c14\u781619600*200*190\u3001\u89c4\u683c\u578b\u53f7\uff1a19600*200*190\u3001\u8ba1\u91cf\u5355\u4f4d\uff1a\u5757\uff0c\u5339\u914d\u67e5\u8be2\u51fa\u591a\u6761\u7269\u6599\u4fe1\u606f\uff0c\u7269\u6599\u4fe1\u606f\u7ed3\u4fe1\u606f\u5c01\u88c5\u6210JSON\u6570\u7ec4\u8fd4\u56de");
            para.put("conversation_id", (Object)conversationId);
            para.put("stream", (Object)false);
            this.logger.info("================\u53c2\u6570=============================");
            this.logger.info(JSONObject.toJSONString((Object)para, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.info("================================================");
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)para.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation/runs").method("POST", body).addHeader("Content-Type", "application/json").addHeader("X-Appbuilder-Authorization", this.AppBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject((String)response.body().string());
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank((String)answer) && answer.contains("```json")) {
                answer = answer.split("```json")[1];
                answer = answer.split("```")[0];
                JSONArray objects = JSONArray.parseArray((String)answer);
                this.logger.info("=================\u7ed3\u679c===========================");
                for (Object object : objects) {
                    this.logger.info(JSONObject.toJSONString(object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                this.logger.info("================================================");
                return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)objects.toJSONString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", null);
    }
}

