/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.ChatExcelEntity;
import com.ejianc.foundation.ai.bean.MergedResult;
import com.ejianc.foundation.ai.mapper.ChatExcelMapper;
import com.ejianc.foundation.ai.service.IChatExcelService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="chatExcelService")
public class ChatExcelServiceImpl
extends BaseServiceImpl<ChatExcelMapper, ChatExcelEntity>
implements IChatExcelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ChatExcelMapper chatExcelMapper;

    @Override
    public Map<String, Object> importExcel(String chatExcelId, MultipartFile file) {
        try {
            ChatExcelEntity chatExcelEntity = (ChatExcelEntity)((Object)this.chatExcelMapper.selectById((Serializable)((Object)chatExcelId)));
            if (chatExcelEntity == null) {
                throw new BusinessException("ChatExcelId\u5728\u6570\u636e\u5e93\u4e0d\u5b58\u5728!");
            }
            String dataTableName = "chatexcel_data_" + chatExcelEntity.getExcelCode();
            this.dropChatExcelTable(dataTableName);
            String createTableSql = "CREATE TABLE `" + dataTableName + "` ( `id` bigint(20) NOT NULL COMMENT '\u4e3b\u952eID', ";
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheetAt = xssfWorkbook.getSheetAt(0);
            IdentityHashMap<String, Object> resultMap = new IdentityHashMap<String, Object>();
            IdentityHashMap<String, Map<String, Object>> styleMap = new IdentityHashMap<String, Map<String, Object>>();
            IdentityHashMap rowMap = new IdentityHashMap();
            int index = 0;
            Iterator rows = sheetAt.iterator();
            boolean isTableHeader = true;
            boolean isInitColumnList = false;
            ArrayList headerColumn = new ArrayList();
            ArrayList allDataList = new ArrayList();
            int rowCellCount = 0;
            int tableHeaderRowCount = 0;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                int rowNumber = row.getRowNum();
                if (rowNumber > 0) {
                    isTableHeader = false;
                }
                ArrayList<String> columnDataList = new ArrayList<String>();
                IdentityHashMap<String, Serializable> cellsMap = new IdentityHashMap<String, Serializable>();
                IdentityHashMap columnMap = new IdentityHashMap();
                int cellIndex = 0;
                for (Cell cell : row) {
                    Map<String, Object> mergeCell;
                    int[] merges;
                    int columnIndex;
                    IdentityHashMap<String, Object> cellMap = new IdentityHashMap<String, Object>();
                    MergedResult mergedResult = null;
                    if (cell.getCellTypeEnum() != CellType.BLANK) {
                        switch (cell.getCellTypeEnum()) {
                            case STRING: {
                                String cellValue = cell.getRichStringCellValue().toString();
                                cellMap.put("text", cellValue);
                                if (StringUtils.isNotBlank((String)cellValue)) {
                                    cellValue = cellValue.replace("(", "\uff08");
                                    cellValue = cellValue.replace(")", "\uff09");
                                    cellValue = cellValue.replace("'", "");
                                    cellValue = cellValue.replace("\"", "");
                                    cellValue = cellValue.replace(",", "\uff0c");
                                    cellValue = cellValue.replace(";", "\uff1b");
                                    if ((cellValue = cellValue.replace("\\", "")).length() > 250) {
                                        columnDataList.add(cellValue.substring(0, 250));
                                        break;
                                    }
                                    columnDataList.add(cellValue);
                                    break;
                                }
                                columnDataList.add("");
                                break;
                            }
                            case NUMERIC: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    String numCellValue;
                                    SimpleDateFormat simpleDateFormat;
                                    DataFormatter formatter = new DataFormatter();
                                    String formattedDate = formatter.formatCellValue(cell);
                                    if (formattedDate.contains(":")) {
                                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        numCellValue = simpleDateFormat.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                                        cellMap.put("text", numCellValue);
                                        columnDataList.add(numCellValue);
                                        break;
                                    }
                                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    numCellValue = simpleDateFormat.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                                    cellMap.put("text", numCellValue);
                                    columnDataList.add(numCellValue);
                                    break;
                                }
                                BigDecimal bigDecimal = BigDecimal.valueOf(cell.getNumericCellValue());
                                cellMap.put("text", bigDecimal.toString());
                                columnDataList.add(bigDecimal.toString());
                                break;
                            }
                            case BOOLEAN: {
                                cellMap.put("text", cell.getBooleanCellValue());
                                columnDataList.add(cell.getBooleanCellValue() + "");
                                break;
                            }
                            default: {
                                columnDataList.add("");
                            }
                        }
                        columnIndex = cell.getColumnIndex();
                        mergedResult = this.toMergedResult((Sheet)sheetAt, rowNumber, columnIndex);
                        if (mergedResult.isMerged()) {
                            merges = new int[]{mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol()};
                            cellMap.put("merge", merges);
                        }
                        mergeCell = this.parseCell(cell, mergedResult.isMerged());
                        styleMap.put(Integer.valueOf(++index).toString(), mergeCell);
                        cellMap.put("style", index);
                        columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                    } else {
                        columnDataList.add("");
                        columnIndex = cell.getColumnIndex();
                        mergedResult = this.toMergedResult((Sheet)sheetAt, rowNumber, columnIndex);
                        if (mergedResult.isMerged()) {
                            isTableHeader = true;
                            merges = new int[]{mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol()};
                            cellMap.put("merge", merges);
                        }
                        if (!mergedResult.isMerged()) {
                            mergeCell = this.parseCell(cell, mergedResult.isMerged());
                            styleMap.put(Integer.valueOf(++index).toString(), mergeCell);
                            cellMap.put("style", index);
                            columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                        }
                    }
                    if (!isTableHeader) {
                        ++cellIndex;
                    }
                    if (!isTableHeader && cellIndex >= rowCellCount) {
                        cellIndex = 0;
                        break;
                    }
                    resultMap.put("styles", styleMap);
                }
                cellsMap.put("cells", columnMap);
                cellsMap.put("height", Float.valueOf(Float.valueOf(row.getHeightInPoints()).floatValue() > 30.0f ? Float.valueOf(row.getHeightInPoints()).floatValue() : 30.0f));
                rowMap.put(Integer.valueOf(rowNumber).toString(), cellsMap);
                resultMap.put("rows", rowMap);
                if (isTableHeader) {
                    ++tableHeaderRowCount;
                    if (!columnDataList.isEmpty()) {
                        rowCellCount = columnDataList.size();
                        for (int i = 0; i < columnDataList.size(); ++i) {
                            if (!isInitColumnList) {
                                headerColumn.add(columnDataList.get(i));
                                continue;
                            }
                            if (!StringUtils.isNotBlank((String)((String)columnDataList.get(i)))) continue;
                            headerColumn.set(i, columnDataList.get(i));
                        }
                    }
                    if (isInitColumnList) continue;
                    isInitColumnList = true;
                    continue;
                }
                allDataList.add(columnDataList);
            }
            if (!headerColumn.isEmpty()) {
                for (int i = 0; i < headerColumn.size(); ++i) {
                    createTableSql = i == headerColumn.size() - 1 ? createTableSql + " `" + (String)headerColumn.get(i) + "` VARCHAR(255) DEFAULT NULL COMMENT '" + (String)headerColumn.get(i) + "' , PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='" + chatExcelEntity.getExcelName() + "' " : createTableSql + " `" + (String)headerColumn.get(i) + "` VARCHAR(255) DEFAULT NULL COMMENT '" + (String)headerColumn.get(i) + "', ";
                }
            }
            this.chatExcelMapper.executeSql(createTableSql);
            if (!allDataList.isEmpty()) {
                int batchSize = 100;
                for (int i = 0; i < allDataList.size(); i += batchSize) {
                    List subList = allDataList.subList(i, Math.min(i + batchSize, allDataList.size()));
                    String insertSql = "INSERT INTO `" + dataTableName + "` VALUES ";
                    for (int j = 0; j < subList.size(); ++j) {
                        if (((List)subList.get(j)).size() < rowCellCount) continue;
                        insertSql = insertSql + "(" + IdWorker.getId() + ",'" + StringUtils.join((Collection)((Collection)subList.get(j)), (String)"','") + "'),";
                    }
                    insertSql = insertSql.substring(0, insertSql.lastIndexOf(","));
                    this.chatExcelMapper.executeSql(insertSql);
                }
            }
            JSONObject jsonObject = new JSONObject(resultMap);
            JSONObject styles = jsonObject.getJSONObject("styles");
            ArrayList<String> sortedKeys = new ArrayList<String>(styles.keySet());
            sortedKeys.sort(Comparator.comparingInt(Integer::parseInt));
            JSONArray jsonArray = new JSONArray();
            JSONObject firstObj = new JSONObject();
            jsonArray.add((Object)firstObj);
            for (String key : sortedKeys) {
                jsonArray.add((Object)styles.getJSONObject(key));
            }
            jsonObject.put("styles", (Object)jsonArray);
            String contentJson = jsonObject.toString();
            chatExcelEntity.setContentJson(contentJson);
            chatExcelEntity.setCreateTableSql(createTableSql);
            chatExcelEntity.setTableHeaderRowCount(tableHeaderRowCount);
            this.chatExcelMapper.updateById((Object)chatExcelEntity);
            return resultMap;
        }
        catch (Exception e) {
            this.logger.error("excel\u5bfc\u5165\u5931\u8d25\uff01Msg:" + e.getMessage());
            return null;
        }
    }

    @Override
    public void dropChatExcelTable(String dataTableName) {
        this.chatExcelMapper.dropChatExcelTable(dataTableName);
    }

    @Override
    public void executeSql(String executeSql) {
        this.chatExcelMapper.executeSql(executeSql);
    }

    @Override
    public List<String> getColumnList(String dataTableName) {
        List<String> columnList = this.chatExcelMapper.getColumnList(dataTableName);
        return columnList;
    }

    private MergedResult toMergedResult(Sheet sheet, int rowNum, int columnIndex) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int firstColumn = cellRangeAddress.getFirstColumn();
            int lastColumn = cellRangeAddress.getLastColumn();
            int firstRow = cellRangeAddress.getFirstRow();
            int lastRow = cellRangeAddress.getLastRow();
            if (rowNum < firstRow || rowNum > lastRow || columnIndex < firstColumn || columnIndex > lastColumn) continue;
            return new MergedResult(true, firstRow, lastRow, firstColumn, lastColumn);
        }
        return new MergedResult(false, 0, 0, 0, 0);
    }

    private Map<String, Object> parseCell(Cell cell, boolean isMerged) {
        XSSFColor xssfColor;
        byte[] rgbs;
        XSSFFont xssfFont;
        CellStyle cellStyle = cell.getCellStyle();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String[]> borderMap = new HashMap<String, String[]>();
        HashMap<String, Comparable<Boolean>> fontMap = new HashMap<String, Comparable<Boolean>>();
        if (((XSSFCell)cell).getCellStyle().getFont().getBold()) {
            fontMap.put("bold", Boolean.valueOf(true));
        }
        fontMap.put("size", Short.valueOf(((XSSFCell)cell).getCellStyle().getFont().getFontHeightInPoints()));
        String[] thins = new String[]{"thin", "#000"};
        if (cellStyle.getBorderBottomEnum() == BorderStyle.THIN) {
            borderMap.put("bottom", thins);
        }
        if (cellStyle.getBorderLeftEnum() == BorderStyle.THIN) {
            borderMap.put("left", thins);
        }
        if (cellStyle.getBorderRightEnum() == BorderStyle.THIN) {
            borderMap.put("right", thins);
        }
        if (cellStyle.getBorderTopEnum() == BorderStyle.THIN) {
            borderMap.put("top", thins);
        }
        if (cellStyle.getAlignmentEnum() == HorizontalAlignment.CENTER) {
            resultMap.put("align", "center");
        }
        if (cellStyle.getBorderBottomEnum() == BorderStyle.THIN && cellStyle.getBorderLeftEnum() == BorderStyle.THIN && cellStyle.getBorderTopEnum() == BorderStyle.THIN && isMerged) {
            borderMap.put("right", thins);
        }
        if (cellStyle.getBorderRightEnum() != BorderStyle.NONE || cellStyle.getBorderBottomEnum() != BorderStyle.NONE || cellStyle.getBorderLeftEnum() != BorderStyle.NONE || cellStyle.getBorderTopEnum() != BorderStyle.NONE) {
            resultMap.put("border", borderMap);
        }
        if ((xssfFont = ((XSSFCell)cell).getCellStyle().getFont()).getXSSFColor() != null && (rgbs = (xssfColor = xssfFont.getXSSFColor()).getRGB()).length > 3) {
            String arg11 = String.format("#%02X%02X%02X", rgbs[0], rgbs[1], rgbs[2]);
            resultMap.put("color", arg11);
        }
        if (((XSSFCell)cell).getCellStyle().getFillPatternEnum() == FillPatternType.SOLID_FOREGROUND) {
            byte[] arg12 = ((XSSFCell)cell).getCellStyle().getFillForegroundColorColor().getRGB();
            String arg13 = String.format("#%02X%02X%02X", arg12[0], arg12[1], arg12[2]);
            resultMap.put("bgcolor", arg13);
        }
        resultMap.put("font", fontMap);
        return resultMap;
    }
}

