/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.ExtDictRelationMapper;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="extDictRelationService")
public class ExtDictRelationServiceImpl
extends BaseServiceImpl<ExtDictRelationMapper, ExtDictRelationEntity>
implements IExtDictRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeEmbeddingPointsService pointsService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public List<ExtDictRelationVO> queryListByEmbeddingIds(List<Long> embeddingIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"embedding_id", embeddingIds);
        List list = this.list((Wrapper)wrapper);
        ArrayList<ExtDictRelationVO> result = new ArrayList<ExtDictRelationVO>();
        if (list != null && list.size() > 0) {
            for (ExtDictRelationEntity entity : list) {
                ExtDictRelationVO vo = (ExtDictRelationVO)((Object)BeanMapper.map((Object)((Object)entity), ExtDictRelationVO.class));
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public void saveList(List<ExtDictRelationVO> list) {
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(list.get(0).getEmbeddingId());
        String indexName = knowledgeBase.getCode();
        KnowledgeEmbeddingPointsEntity initPointData = this.pointsService.getFirstInitData(list.get(0).getEmbeddingId());
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        for (ExtDictRelationVO extDictRelationVO : list) {
            KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
            Long id = IdWorker.getId();
            extDictRelationVO.setId(id);
            point.setId(id);
            point.setType(4);
            point.setEmbeddingId(extDictRelationVO.getEmbeddingId());
            String content = extDictRelationVO.getField();
            point.setContent(content);
            point.setInitContent(content);
            String redisId = "tag-" + initPointData.getId() + "-" + id;
            JSONObject json = this.documentSplitUtil.documentStoreSingleSourceId(redisId, content, embeddingModel, embeddingStore);
            Embedding embedding = (Embedding)json.get((Object)"embedding");
            String redisIdr = (String)json.get((Object)"redisId");
            point.setUuid(indexName + ":" + redisIdr);
            point.setVector(Arrays.toString(embedding.vector()));
            this.pointsService.saveOrUpdate((Object)point, false);
        }
        List entitys = BeanMapper.mapList(list, ExtDictRelationEntity.class);
        this.saveOrUpdateBatch(entitys, entitys.size(), false);
    }

    @Override
    public void delete(List<Long> ids) {
        this.removeByIds(ids);
        QueryWrapper wrapperEmbeddingPoints = new QueryWrapper();
        ExtDictRelationEntity entity = (ExtDictRelationEntity)((Object)this.selectById(ids.get(0)));
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(entity.getEmbeddingId());
        String indexName = knowledgeBase.getCode();
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        ArrayList<String> rids = new ArrayList<String>();
        for (Long id : ids) {
            rids.add(indexName + ":" + "tag-" + id);
        }
        wrapperEmbeddingPoints.in((Object)"uuid", rids);
        this.pointsService.remove((Wrapper)wrapperEmbeddingPoints);
        embeddingStore.removeAll(rids);
    }
}

