/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingPointsMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingPointsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeEmbeddingPointsService")
public class KnowledgeEmbeddingPointsServiceImpl
extends BaseServiceImpl<KnowledgeEmbeddingPointsMapper, KnowledgeEmbeddingPointsEntity>
implements IKnowledgeEmbeddingPointsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private KnowledgeEmbeddingPointsMapper knowledgeEmbeddingPointsMapper;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public KnowledgeEmbeddingPointsVO saveData(KnowledgeEmbeddingPointsVO saveOrUpdateVO) {
        KnowledgeEmbeddingPointsEntity entity = (KnowledgeEmbeddingPointsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeEmbeddingPointsEntity.class));
        KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(saveOrUpdateVO.getEmbeddingId()));
        if (embeddingEntity.getSliceState() == 0) {
            throw new BusinessException("\u5207\u7247\u5df2\u505c\u7528\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u77e5\u8bc6\u70b9\u4fe1\u606f\uff0c\u8bf7\u5148\u542f\u7528\u5207\u7247");
        }
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByItemId(embeddingEntity.getItemId());
        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setType(2);
            entity.setInitContent(saveOrUpdateVO.getContent());
            Integer maxSequence = this.knowledgeEmbeddingPointsMapper.selectMaxSequence(saveOrUpdateVO.getEmbeddingId());
            entity.setSequence(maxSequence + 1);
        } else {
            embeddingStore.remove(saveOrUpdateVO.getUuid());
            if (entity.getType() == 1) {
                entity.setType(3);
            }
        }
        JSONObject json = this.documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), embeddingModel, embeddingStore);
        Embedding embedding = (Embedding)json.get((Object)"embedding");
        String redisId = (String)json.get((Object)"redisId");
        entity.setUuid(indexName + ":" + redisId);
        entity.setContent(saveOrUpdateVO.getContent());
        entity.setVector(Arrays.toString(embedding.vector()));
        this.saveOrUpdate((Object)entity, false);
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(embeddingEntity.getItemId()));
        Integer embeddingCount = this.countEmbeddingByItemId(embeddingEntity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeEmbeddingPointsVO vo = (KnowledgeEmbeddingPointsVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingPointsVO.class));
        return vo;
    }

    @Override
    public void delData(KnowledgeEmbeddingPointsVO vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getUuid())) {
            KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(vo.getEmbeddingId());
            String indexName = knowledgeBase.getCode();
            EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
            embeddingStore.remove(vo.getUuid());
        }
        this.removeById(vo.getId());
        KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(vo.getEmbeddingId()));
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(embeddingEntity.getItemId()));
        Integer embeddingCount = this.countEmbeddingByItemId(embeddingEntity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
    }

    @Override
    public Integer countEmbeddingByItemId(Long itemId) {
        return this.knowledgeEmbeddingPointsMapper.countEmbeddingByItemId(itemId);
    }

    @Override
    public KnowledgeEmbeddingPointsVO restoreData(KnowledgeEmbeddingPointsVO data) {
        KnowledgeEmbeddingPointsEntity entity = (KnowledgeEmbeddingPointsEntity)((Object)this.selectById(data.getId()));
        entity.setContent(entity.getInitContent());
        entity.setType(1);
        KnowledgeBaseEntity knowledgeBase = this.knowledgeBaseService.queryBaseDataByEmbeddingId(data.getEmbeddingId());
        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = this.ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = this.ejcAiEmbeding.getEmbeddingStore(indexName);
        embeddingStore.remove(entity.getUuid());
        JSONObject json = this.documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
        Embedding embedding = (Embedding)json.get((Object)"embedding");
        String redisId = (String)json.get((Object)"redisId");
        entity.setUuid(indexName + ":" + redisId);
        entity.setVector(Arrays.toString(embedding.vector()));
        this.saveOrUpdate((Object)entity, false);
        KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(entity.getEmbeddingId()));
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(embeddingEntity.getItemId()));
        Integer embeddingCount = this.countEmbeddingByItemId(embeddingEntity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        this.knowledgeItemService.saveOrUpdate((Object)itemEntity, false);
        KnowledgeEmbeddingPointsVO vo = (KnowledgeEmbeddingPointsVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingPointsVO.class));
        return vo;
    }

    @Override
    public KnowledgeEmbeddingPointsEntity getFirstInitData(Long embeddingId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)embeddingId);
        wrapper.ne((Object)"sequence", null);
        ArrayList<Integer> type = new ArrayList<Integer>();
        type.add(1);
        type.add(3);
        wrapper.in((Object)"type", type);
        wrapper.orderByAsc((Object)"create_time");
        wrapper.orderByAsc((Object)"sequence");
        List list = this.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            this.logger.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}\u3002------\u5185\u5bb9:{}", (Object)((KnowledgeEmbeddingPointsEntity)((Object)list.get(0))).getId(), (Object)((KnowledgeEmbeddingPointsEntity)((Object)list.get(0))).getContent());
            return (KnowledgeEmbeddingPointsEntity)((Object)list.get(0));
        }
        this.logger.info("\u672a\u83b7\u53d6\u5230\u7684\u6570\u636eembeddingId\uff1a{}", (Object)embeddingId);
        return null;
    }
}

