/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.ai.bean.AgentEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.bean.KnowledgeMessageEntity;
import com.ejianc.foundation.ai.bean.KnowledgeMessageHistoryEntity;
import com.ejianc.foundation.ai.bean.ModelEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.AgentMapper;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.service.IKnowledgeMessageHistoryService;
import com.ejianc.foundation.ai.service.IKnowledgeMessageService;
import com.ejianc.foundation.ai.service.IModelService;
import com.ejianc.foundation.ai.sse.helper.SSEEmitterHelper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.vdurmont.emoji.EmojiParser;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.qianfan.QianfanChatModel;
import dev.langchain4j.model.qianfan.QianfanStreamingChatModel;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service(value="agentService")
public class AgentServiceImpl
extends BaseServiceImpl<AgentMapper, AgentEntity>
implements IAgentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IModelService modelService;
    @Autowired
    private IKnowledgeMessageHistoryService KnowledgeMessageHistoryService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private SSEEmitterHelper sseEmitterHelper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;

    private void saveKnowledgeMessage(Long pkId, Long knowledgeId, Long dialogId, Long userId, Long tenantId, String resStr) {
        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(pkId);
        answerMessageEntity.setParentId(knowledgeId);
        answerMessageEntity.setContent(resStr);
        answerMessageEntity.setUserId(userId);
        answerMessageEntity.setMessageHistoryId(dialogId);
        answerMessageEntity.setTenantId(tenantId);
        this.knowledgeMessageService.saveOrUpdate((Object)answerMessageEntity, false);
    }

    @Override
    public CommonResponse<JSONObject> chatWithAgentByApi(ChatParam chatParam) {
        PromptTemplate promptTemplate;
        if (chatParam.getAgentId() == null) {
            return CommonResponse.error((String)"\u667a\u80fd\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgentEntity agentEntity = (AgentEntity)((Object)this.selectById(chatParam.getAgentId()));
        if (agentEntity == null) {
            return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u667a\u80fd\u4f53\uff01");
        }
        if (agentEntity.getAgentState() == 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u667a\u80fd\u4f53\u5df2\u88ab\u505c\u7528\uff01");
        }
        if (StringUtils.isBlank((String)chatParam.getReqText())) {
            return CommonResponse.error((String)"\u8bf7\u6c42\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ModelEntity model = (ModelEntity)((Object)this.modelService.selectById(agentEntity.getModelId()));
        if (model == null) {
            return CommonResponse.error((String)"\u5f53\u524d\u667a\u80fd\u4f53\u6ca1\u6709\u8bbe\u7f6e\u5927\u6a21\u578b\uff0c\u65e0\u6cd5\u56de\u7b54\u95ee\u9898\uff01");
        }
        if (model.getModelState() != 1) {
            return CommonResponse.error((String)"\u5f53\u524d\u667a\u80fd\u4f53\u5f15\u7528\u7684\u5927\u6a21\u578b\u5df2\u7ecf\u88ab\u505c\u7528\u4e86\uff01");
        }
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long dialogId = IdWorker.getId();
        KnowledgeMessageHistoryEntity historyEntity = new KnowledgeMessageHistoryEntity();
        historyEntity.setId(dialogId);
        historyEntity.setAgentId(agentEntity.getId());
        historyEntity.setUserId(userId);
        historyEntity.setTopFlag(0);
        historyEntity.setTitle(chatParam.getReqText());
        this.KnowledgeMessageHistoryService.saveOrUpdate((Object)historyEntity, false);
        Long knowledgeMessageId = IdWorker.getId();
        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(knowledgeMessageId);
        answerMessageEntity.setContent(chatParam.getReqText());
        answerMessageEntity.setUserId(userId);
        answerMessageEntity.setMessageHistoryId(dialogId);
        answerMessageEntity.setCreateTime(new Date());
        this.knowledgeMessageService.saveOrUpdate((Object)answerMessageEntity, false);
        StringBuilder contextSbf = new StringBuilder();
        Map<String, String> matchMap = null;
        ArrayList<String> embeddingIds = new ArrayList<String>();
        if (1 == agentEntity.getKnowledgeGyyFlag()) {
            String indexName = InvocationInfoProxy.getTenantid() + "";
            matchMap = this.ejcAiEmbeding.getMatchList(indexName, chatParam.getReqText(), agentEntity.getMatchScore().doubleValue(), agentEntity.getCallBackNum());
            for (Map.Entry<String, String> entry : matchMap.entrySet()) {
                embeddingIds.add(entry.getKey());
                contextSbf.append(entry.getValue()).append(";");
            }
        } else {
            String knowledgeIds = agentEntity.getKnowledgeIds();
            if (StringUtils.isNotBlank((String)knowledgeIds)) {
                String[] knowledgeIdArr;
                for (String knowledgeId : knowledgeIdArr = knowledgeIds.split(",")) {
                    KnowledgeBaseEntity knowledgeBaseEntity = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById((Serializable)((Object)knowledgeId)));
                    matchMap = this.ejcAiEmbeding.getMatchList(knowledgeBaseEntity.getCode(), chatParam.getReqText(), agentEntity.getMatchScore().doubleValue(), agentEntity.getCallBackNum());
                    for (Map.Entry<String, String> entry : matchMap.entrySet()) {
                        embeddingIds.add(entry.getKey());
                        contextSbf.append(entry.getValue()).append(";");
                    }
                }
            }
        }
        Prompt prompt = null;
        if (1 != agentEntity.getKnowledgeGyyFlag() && StringUtils.isBlank((String)agentEntity.getKnowledgeIds())) {
            promptTemplate = PromptTemplate.from((String)"{{question}}");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("question", chatParam.getReqText());
            prompt = promptTemplate.apply(hashMap);
        } else {
            if (1 == agentEntity.getStrictFlag() && StringUtils.isBlank((String)(contextSbf + ""))) {
                return CommonResponse.error((String)"\u5f53\u524d\u77e5\u8bc6\u5e93\u6ca1\u6709\u60a8\u63d0\u95ee\u7684\u77e5\u8bc6\uff01");
            }
            promptTemplate = PromptTemplate.from((String)"{{template}}\n, \u57fa\u4e8e\u5982\u4e0b\u4fe1\u606f\u8fdb\u884c\u56de\u7b54:\n{{context}}\n\u63d0\u95ee:\n{{question}}");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("template", agentEntity.getRoleInstruction());
            hashMap.put("context", contextSbf + "");
            hashMap.put("question", chatParam.getReqText());
            prompt = promptTemplate.apply(hashMap);
        }
        UserMessage userMessage = prompt.toUserMessage();
        if (1 == model.getPlatform()) {
            OllamaChatModel ollamaChatModel = OllamaChatModel.builder().baseUrl(model.getBaseUrl()).modelName(model.getModelName()).numPredict(Integer.valueOf(-1)).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).build();
            Response messageResponse = ollamaChatModel.generate(new ChatMessage[]{userMessage});
            String resStr = ((AiMessage)messageResponse.content()).text();
            if (StringUtils.isNotBlank((String)resStr) && resStr.contains("</think>")) {
                String[] respStrArr = resStr.split("</think>");
                resStr = respStrArr[1];
            }
            resStr = EmojiParser.removeAllEmojis((String)resStr);
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            return CommonResponse.success((String)resStr);
        }
        if (2 == model.getPlatform()) {
            String string = model.getAppConfig();
            try {
                JSONObject appConfigJson = JSONObject.parseObject((String)string);
                String apiKey = appConfigJson.getString("apiKey");
                String secretKey = appConfigJson.getString("secretKey");
                QianfanChatModel qianfanChatModel = QianfanChatModel.builder().modelName(model.getModelName()).apiKey(apiKey).secretKey(secretKey).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).build();
                Response messageResponse = qianfanChatModel.generate(new ChatMessage[]{userMessage});
                String resStr = ((AiMessage)messageResponse.content()).text();
                if (StringUtils.isNotBlank((String)resStr) && resStr.contains("</think>")) {
                    String[] respStrArr = resStr.split("</think>");
                    resStr = respStrArr[1];
                }
                resStr = EmojiParser.removeAllEmojis((String)resStr);
                Long pkId = IdWorker.getId();
                this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
                return CommonResponse.success((String)resStr);
            }
            catch (Exception e) {
                return CommonResponse.error((String)"\u5343\u5e06\u5927\u6a21\u578b\u914d\u7f6e\u4fe1\u606f\u6709\u8bef\uff0c\u4f8b\u5b50: {\"appId\":\"\",\"appSecret\":\"\"}\uff01");
            }
        }
        if (3 == model.getPlatform()) {
            String string = model.getAppConfig();
            try {
                JSONObject appConfigJson = JSONObject.parseObject((String)string);
                String apiKey = appConfigJson.getString("apiKey");
                OpenAiChatModel openAiChatModel = OpenAiChatModel.builder().modelName(model.getModelName()).apiKey(apiKey).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).build();
                Response messageResponse = openAiChatModel.generate(new ChatMessage[]{userMessage});
                String resStr = ((AiMessage)messageResponse.content()).text();
                if (StringUtils.isNotBlank((String)resStr) && resStr.contains("</think>")) {
                    String[] respStrArr = resStr.split("</think>");
                    resStr = respStrArr[1];
                }
                resStr = EmojiParser.removeAllEmojis((String)resStr);
                Long pkId = IdWorker.getId();
                this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
                return CommonResponse.success((String)resStr);
            }
            catch (Exception e) {
                return CommonResponse.error((String)"\u963f\u91cc\u5927\u6a21\u578b\u914d\u7f6e\u4fe1\u606f\u6709\u8bef\uff0c\u4f8b\u5b50: {\"appId\":\"\",\"appSecret\":\"\"}\uff01");
            }
        }
        return CommonResponse.error((String)"\u8be5\u667a\u80fd\u4f53\u8bbe\u7f6e\u7684\u5927\u6a21\u578b\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\uff01");
    }

    @Override
    public SseEmitter chatWithAgent(String text, Long agentId, Long dialogId, Long knowledgeSessionId, Boolean makeBill, String billResponse) {
        String apiKey;
        JSONObject appConfigJson;
        String appConfig;
        final SseEmitter sseEmitter = new SseEmitter(Long.valueOf(6000000L));
        AgentEntity agentEntity = (AgentEntity)((Object)this.selectById(agentId));
        JSONObject res = new JSONObject();
        boolean sequence = false;
        final Long userId = InvocationInfoProxy.getUserid();
        final Long tenantId = InvocationInfoProxy.getTenantid();
        if (dialogId == null) {
            dialogId = IdWorker.getId();
            KnowledgeMessageHistoryEntity historyEntity = new KnowledgeMessageHistoryEntity();
            historyEntity.setId(dialogId);
            historyEntity.setAgentId(agentId);
            historyEntity.setUserId(userId);
            historyEntity.setTopFlag(0);
            historyEntity.setTitle(text);
            this.KnowledgeMessageHistoryService.saveOrUpdate((Object)historyEntity, false);
        }
        KnowledgeMessageEntity answerMessageEntity = null;
        Long knowledgeMessageId = null;
        if (knowledgeSessionId == null) {
            knowledgeMessageId = IdWorker.getId();
            answerMessageEntity = new KnowledgeMessageEntity();
            answerMessageEntity.setId(knowledgeMessageId);
            answerMessageEntity.setContent(text);
            answerMessageEntity.setUserId(InvocationInfoProxy.getUserid());
            answerMessageEntity.setMessageHistoryId(dialogId);
            answerMessageEntity.setCreateTime(new Date());
            this.knowledgeMessageService.saveOrUpdate((Object)answerMessageEntity, false);
        } else {
            answerMessageEntity = (KnowledgeMessageEntity)((Object)this.knowledgeMessageService.selectById(knowledgeSessionId));
            knowledgeMessageId = answerMessageEntity.getId();
        }
        String resStr = "";
        if (agentEntity == null) {
            resStr = "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u667a\u80fd\u4f53";
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        if (agentEntity.getAgentState() == 0) {
            resStr = "\u5f53\u524d\u8bbf\u95ee\u7684\u667a\u80fd\u4f53\u5df2\u88ab\u505c\u7528\u4e86\uff01";
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        ModelEntity model = (ModelEntity)((Object)this.modelService.selectById(agentEntity.getModelId()));
        if (model == null) {
            resStr = "\u5f53\u524d\u667a\u80fd\u4f53\u6ca1\u6709\u8bbe\u7f6e\u5927\u6a21\u578b\uff0c\u65e0\u6cd5\u56de\u7b54\u95ee\u9898\uff01";
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        if (model.getModelState() != 1) {
            resStr = "\u5f53\u524d\u667a\u80fd\u4f53\u5f15\u7528\u7684\u5927\u6a21\u578b\u5df2\u7ecf\u88ab\u505c\u7528\u4e86\uff01";
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        if (makeBill != null && makeBill.booleanValue()) {
            resStr = billResponse;
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        StringBuilder contextSbf = new StringBuilder();
        Map<String, String> matchMap = null;
        final ArrayList<String> embeddingIds = new ArrayList<String>();
        if (1 == agentEntity.getKnowledgeGyyFlag()) {
            String indexName = InvocationInfoProxy.getTenantid() + "";
            matchMap = this.ejcAiEmbeding.getMatchList(indexName, text, agentEntity.getMatchScore().doubleValue(), agentEntity.getCallBackNum());
            for (Map.Entry<String, String> entry : matchMap.entrySet()) {
                embeddingIds.add(entry.getKey());
                contextSbf.append(entry.getValue()).append(";");
            }
        } else {
            String knowledgeIds = agentEntity.getKnowledgeIds();
            if (StringUtils.isNotBlank((String)knowledgeIds)) {
                String[] knowledgeIdArr;
                for (String knowledgeId : knowledgeIdArr = knowledgeIds.split(",")) {
                    KnowledgeBaseEntity knowledgeBaseEntity = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById((Serializable)((Object)knowledgeId)));
                    matchMap = this.ejcAiEmbeding.getMatchList(knowledgeBaseEntity.getCode(), text, agentEntity.getMatchScore().doubleValue(), agentEntity.getCallBackNum());
                    for (Map.Entry<String, String> entry : matchMap.entrySet()) {
                        embeddingIds.add(entry.getKey());
                        contextSbf.append(entry.getValue()).append(";");
                    }
                }
            }
        }
        if (1 == agentEntity.getStrictFlag() && StringUtils.isBlank((String)(contextSbf + ""))) {
            resStr = "\u5f53\u524d\u77e5\u8bc6\u5e93\u6ca1\u6709\u60a8\u63d0\u95ee\u7684\u77e5\u8bc6\uff01";
            Long pkId = IdWorker.getId();
            this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            res.put("knowledgeMessageId", (Object)knowledgeMessageId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        PromptTemplate promptTemplate = PromptTemplate.from((String)"{{template}}\n, \u57fa\u4e8e\u5982\u4e0b\u4fe1\u606f\u8fdb\u884c\u56de\u7b54:\n{{context}}\n\u63d0\u95ee:\n{{question}}");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("template", agentEntity.getRoleInstruction());
        variables.put("context", contextSbf + "");
        variables.put("question", text);
        Prompt prompt = promptTemplate.apply(variables);
        UserMessage userMessage = prompt.toUserMessage();
        MessageWindowChatMemory chatMemory = MessageWindowChatMemory.withMaxMessages((int)5);
        KnowledgeMessageEntity latestHistoryMessage = this.knowledgeMessageService.queryParentHistoryList(dialogId, userId, knowledgeMessageId);
        if (latestHistoryMessage != null) {
            chatMemory.add((ChatMessage)UserMessage.from((String)latestHistoryMessage.getContent()));
            QueryWrapper queryWrapperAnswer = new QueryWrapper();
            queryWrapperAnswer.eq((Object)"message_history_id", (Object)dialogId);
            queryWrapperAnswer.eq((Object)"user_id", (Object)userId);
            queryWrapperAnswer.eq((Object)"parent_id", (Object)latestHistoryMessage.getId());
            queryWrapperAnswer.orderByDesc((Object)"create_time");
            queryWrapperAnswer.last("limit 1");
            KnowledgeMessageEntity historyAnswer = (KnowledgeMessageEntity)((Object)this.knowledgeMessageService.getOne((Wrapper)queryWrapperAnswer));
            if (historyAnswer != null) {
                chatMemory.add((ChatMessage)AiMessage.from((String)historyAnswer.getContent()));
            }
        }
        chatMemory.add((ChatMessage)userMessage);
        if (1 == model.getPlatform()) {
            OllamaStreamingChatModel ollamaStreamingChatModel = OllamaStreamingChatModel.builder().baseUrl(model.getBaseUrl()).modelName(model.getModelName()).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).numPredict(Integer.valueOf(-1)).timeout(Duration.ofMinutes(50L)).build();
            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = new Boolean[]{false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            ollamaStreamingChatModel.generate(chatMemory.messages(), (StreamingResponseHandler)new StreamingResponseHandler<AiMessage>(){

                public void onNext(String text) {
                    JSONObject resNext;
                    String respKey = "RESP_ANSWER:" + fPkId;
                    String isResponsing = String.valueOf(AgentServiceImpl.this.redisTemplate.opsForValue().get(respKey));
                    if (!"false".equals(isResponsing)) {
                        resNext = new JSONObject();
                        resNext.put("dialogId", (Object)fdialogId);
                        resNext.put("botMsg", (Object)text);
                        resNext.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                        resNext.put("currentAnswerId", (Object)fPkId);
                        if (!fIsSetValue[0].booleanValue()) {
                            fIsSetValue[0] = true;
                            AgentServiceImpl.this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
                        }
                    } else {
                        sseEmitter.complete();
                        AgentServiceImpl.this.redisTemplate.delete(respKey);
                        throw new RuntimeException("\u7528\u6237\u53d6\u6d88\u4e86\u672c\u6b21\u5bf9\u8bdd");
                    }
                    AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resNext);
                }

                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if (embeddingIds.size() > 0) {
                        List<KnowledgeItemEntity> knowledgeItemList;
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for (String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if (StringUtils.isNotBlank((String)(embeddingIdsSbf + "")) && (knowledgeItemList = AgentServiceImpl.this.knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1))) != null && knowledgeItemList.size() > 0) {
                            referenceHtml = referenceHtml + "<br/><br/> ****\u5f15\u7528\u6587\u6863\uff1a**** \n\n";
                            for (int i = 0; i < knowledgeItemList.size(); ++i) {
                                KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                referenceHtml = referenceHtml + "&nbsp;&nbsp;&nbsp;&nbsp;" + (i + 1) + ".&nbsp;[" + knowledgeItemEntity.getFileName() + "](" + knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                AgentServiceImpl.this.knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                            }
                            JSONObject resComplete = new JSONObject();
                            resComplete.put("dialogId", (Object)fdialogId);
                            resComplete.put("botMsg", (Object)referenceHtml);
                            resComplete.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                            resComplete.put("currentAnswerId", (Object)fPkId);
                            AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                        }
                    }
                    String respText = ((AiMessage)response.content()).text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if (StringUtils.isNotBlank((String)respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('" + pkId + "');\">\u601d\u8003\u8fc7\u7a0b <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\"" + pkId + "\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis((String)respText);
                    AgentServiceImpl.this.saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    super.onComplete(response);
                }

                public void onError(Throwable throwable) {
                    AgentServiceImpl.this.logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }
        if (2 == model.getPlatform()) {
            appConfig = model.getAppConfig();
            appConfigJson = JSONObject.parseObject((String)appConfig);
            apiKey = appConfigJson.getString("apiKey");
            String secretKey = appConfigJson.getString("secretKey");
            QianfanStreamingChatModel qianfanStreamingChatModel = QianfanStreamingChatModel.builder().modelName(model.getModelName()).apiKey(apiKey).secretKey(secretKey).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).build();
            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = new Boolean[]{false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            qianfanStreamingChatModel.generate(chatMemory.messages(), (StreamingResponseHandler)new StreamingResponseHandler<AiMessage>(){

                public void onNext(String text) {
                    JSONObject resNext;
                    String respKey = "RESP_ANSWER:" + fPkId;
                    String isResponsing = String.valueOf(AgentServiceImpl.this.redisTemplate.opsForValue().get(respKey));
                    if (!"false".equals(isResponsing)) {
                        resNext = new JSONObject();
                        resNext.put("dialogId", (Object)fdialogId);
                        resNext.put("botMsg", (Object)text);
                        resNext.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                        resNext.put("currentAnswerId", (Object)fPkId);
                        if (!fIsSetValue[0].booleanValue()) {
                            fIsSetValue[0] = true;
                            AgentServiceImpl.this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
                        }
                    } else {
                        sseEmitter.complete();
                        AgentServiceImpl.this.redisTemplate.delete(respKey);
                        throw new RuntimeException("\u7528\u6237\u53d6\u6d88\u4e86\u672c\u6b21\u5bf9\u8bdd");
                    }
                    AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resNext);
                }

                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if (embeddingIds.size() > 0) {
                        List<KnowledgeItemEntity> knowledgeItemList;
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for (String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if (StringUtils.isNotBlank((String)(embeddingIdsSbf + "")) && (knowledgeItemList = AgentServiceImpl.this.knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1))) != null && knowledgeItemList.size() > 0) {
                            referenceHtml = referenceHtml + "<br/><br/> ****\u5f15\u7528\u6587\u6863\uff1a**** \n\n";
                            for (int i = 0; i < knowledgeItemList.size(); ++i) {
                                KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                referenceHtml = referenceHtml + "&nbsp;&nbsp;&nbsp;&nbsp;" + (i + 1) + ".&nbsp;[" + knowledgeItemEntity.getFileName() + "](" + knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                AgentServiceImpl.this.knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                            }
                            JSONObject resComplete = new JSONObject();
                            resComplete.put("dialogId", (Object)fdialogId);
                            resComplete.put("botMsg", (Object)referenceHtml);
                            resComplete.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                            resComplete.put("currentAnswerId", (Object)fPkId);
                            AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                        }
                    }
                    String respText = ((AiMessage)response.content()).text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if (StringUtils.isNotBlank((String)respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('" + pkId + "');\">\u601d\u8003\u8fc7\u7a0b <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\"" + pkId + "\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis((String)respText);
                    AgentServiceImpl.this.saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    super.onComplete(response);
                }

                public void onError(Throwable throwable) {
                    AgentServiceImpl.this.logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }
        if (3 == model.getPlatform()) {
            appConfig = model.getAppConfig();
            appConfigJson = JSONObject.parseObject((String)appConfig);
            apiKey = appConfigJson.getString("apiKey");
            OpenAiStreamingChatModel openAiStreamingChatModel = OpenAiStreamingChatModel.builder().modelName(model.getModelName()).apiKey(apiKey).temperature(Double.valueOf(agentEntity.getTemperature().doubleValue())).build();
            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = new Boolean[]{false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            openAiStreamingChatModel.generate(chatMemory.messages(), (StreamingResponseHandler)new StreamingResponseHandler<AiMessage>(){

                public void onNext(String text) {
                    JSONObject resNext;
                    String respKey = "RESP_ANSWER:" + fPkId;
                    String isResponsing = String.valueOf(AgentServiceImpl.this.redisTemplate.opsForValue().get(respKey));
                    if (!"false".equals(isResponsing)) {
                        resNext = new JSONObject();
                        resNext.put("dialogId", (Object)fdialogId);
                        resNext.put("botMsg", (Object)text);
                        resNext.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                        resNext.put("currentAnswerId", (Object)fPkId);
                        if (!fIsSetValue[0].booleanValue()) {
                            fIsSetValue[0] = true;
                            AgentServiceImpl.this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
                        }
                    } else {
                        sseEmitter.complete();
                        AgentServiceImpl.this.redisTemplate.delete(respKey);
                        throw new RuntimeException("\u7528\u6237\u53d6\u6d88\u4e86\u672c\u6b21\u5bf9\u8bdd");
                    }
                    AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resNext);
                }

                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if (embeddingIds.size() > 0) {
                        List<KnowledgeItemEntity> knowledgeItemList;
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for (String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if (StringUtils.isNotBlank((String)(embeddingIdsSbf + "")) && (knowledgeItemList = AgentServiceImpl.this.knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1))) != null && knowledgeItemList.size() > 0) {
                            referenceHtml = referenceHtml + "<br/><br/> ****\u5f15\u7528\u6587\u6863\uff1a**** \n\n";
                            for (int i = 0; i < knowledgeItemList.size(); ++i) {
                                KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                referenceHtml = referenceHtml + "&nbsp;&nbsp;&nbsp;&nbsp;" + (i + 1) + ".&nbsp;[" + knowledgeItemEntity.getFileName() + "](" + knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                AgentServiceImpl.this.knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                            }
                            JSONObject resComplete = new JSONObject();
                            resComplete.put("dialogId", (Object)fdialogId);
                            resComplete.put("botMsg", (Object)referenceHtml);
                            resComplete.put("knowledgeMessageId", (Object)fknowledgeMessageId);
                            resComplete.put("currentAnswerId", (Object)fPkId);
                            AgentServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                        }
                    }
                    String respText = ((AiMessage)response.content()).text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if (StringUtils.isNotBlank((String)respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('" + pkId + "');\">\u601d\u8003\u8fc7\u7a0b <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\"" + pkId + "\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis((String)respText);
                    AgentServiceImpl.this.saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    super.onComplete(response);
                }

                public void onError(Throwable throwable) {
                    AgentServiceImpl.this.logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }
        resStr = "\u8be5\u667a\u80fd\u4f53\u8bbe\u7f6e\u7684\u5927\u6a21\u578b\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\uff01";
        Long pkId = IdWorker.getId();
        this.saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
        res.put("botMsg", (Object)resStr);
        res.put("dialogId", (Object)dialogId);
        res.put("knowledgeMessageId", (Object)knowledgeMessageId);
        res.put("currentAnswerId", (Object)pkId);
        String respKey = "RESP_ANSWER:" + pkId;
        this.redisTemplate.opsForValue().set(respKey, "true", 30L, TimeUnit.MINUTES);
        this.sseEmitterHelper.sendComplete(sseEmitter, res);
        sseEmitter.complete();
        return sseEmitter;
    }
}

