/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.config;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.ModelEntity;
import com.ejianc.foundation.ai.config.AuthHeaderUtils;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IModelService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.qianfan.QianfanEmbeddingModel;
import dev.langchain4j.model.qianfan.QianfanEmbeddingModelNameEnum;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.redis.RedisEmbeddingStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class EjcAiEmbeding {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String redisHost;
    private Integer redisPort;
    private String redisPassword;
    private IModelService modelService;
    private final Map<String, EmbeddingStore<TextSegment>> embeddingStoreMap = new HashMap<String, EmbeddingStore<TextSegment>>();
    private final Map<String, EmbeddingModel> embeddingModelMap = new HashMap<String, EmbeddingModel>();
    private final Map<String, Integer> dimensionMap = new HashMap<String, Integer>();
    private EmbeddingModel embeddingModel = null;

    public EjcAiEmbeding() {
    }

    public EjcAiEmbeding(String redisHost, Integer redisPort, String redisPassword, IModelService modelService) {
        this.redisHost = redisHost;
        this.redisPort = redisPort;
        this.redisPassword = redisPassword;
        this.modelService = modelService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddingModel getEmbeddingModel(String indexName) {
        String string = indexName;
        synchronized (string) {
            EmbeddingModel embeddingModel = this.embeddingModelMap.get(indexName);
            if (embeddingModel != null) {
                return embeddingModel;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"model_state", (Object)1);
            queryWrapper.eq((Object)"embedding_model_flag", (Object)1);
            List embeddingModelList = this.modelService.list((Wrapper)queryWrapper);
            if (embeddingModelList != null && embeddingModelList.size() > 0) {
                ModelEntity modelEntity = (ModelEntity)((Object)embeddingModelList.get(0));
                if (1 == modelEntity.getPlatform()) {
                    System.out.println(modelEntity.getBaseUrl());
                    System.out.println(modelEntity.getModelName());
                    embeddingModel = OllamaEmbeddingModel.builder().baseUrl(modelEntity.getBaseUrl()).modelName(modelEntity.getModelName()).timeout(Duration.ofMinutes(5L)).build();
                    this.embeddingModelMap.put(indexName, embeddingModel);
                    Response embedding = embeddingModel.embed("test");
                    this.dimensionMap.put(indexName, ((Embedding)embedding.content()).dimension());
                } else if (2 == modelEntity.getPlatform()) {
                    if (StringUtils.isNotBlank((String)modelEntity.getAppConfig())) {
                        try {
                            JSONObject appConfigJson = JSONObject.parseObject((String)modelEntity.getAppConfig());
                            String apiKey = appConfigJson.getString("apiKey");
                            String secretKey = appConfigJson.getString("secretKey");
                            embeddingModel = QianfanEmbeddingModel.builder().modelName(QianfanEmbeddingModelNameEnum.EMBEDDING_V1.getModelName()).apiKey(apiKey).secretKey(secretKey).build();
                            this.embeddingModelMap.put(indexName, embeddingModel);
                            Response embedding = embeddingModel.embed("test");
                            this.dimensionMap.put(indexName, ((Embedding)embedding.content()).dimension());
                        }
                        catch (Exception appConfigJson) {}
                    }
                } else if (3 == modelEntity.getPlatform() && StringUtils.isNotBlank((String)modelEntity.getAppConfig())) {
                    try {
                        JSONObject appConfigJson = JSONObject.parseObject((String)modelEntity.getAppConfig());
                        String apiKey = appConfigJson.getString("apiKey");
                        embeddingModel = OpenAiEmbeddingModel.builder().baseUrl("https://dashscope.aliyuncs.com/compatible-mode/v1").modelName("text-embedding-v3").apiKey(apiKey).build();
                        this.embeddingModelMap.put(indexName, embeddingModel);
                        Response embedding = embeddingModel.embed("test");
                        this.dimensionMap.put(indexName, ((Embedding)embedding.content()).dimension());
                    }
                    catch (Exception exception) {}
                }
            } else {
                embeddingModel = new AllMiniLmL6V2EmbeddingModel();
                this.embeddingModelMap.put(indexName, embeddingModel);
                this.dimensionMap.put(indexName, 384);
            }
            return embeddingModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddingStore<TextSegment> getEmbeddingStore(String indexName) {
        String string = indexName;
        synchronized (string) {
            RedisEmbeddingStore embeddingStore = this.embeddingStoreMap.get(indexName);
            if (embeddingStore != null) {
                return embeddingStore;
            }
            int dimension = this.dimensionMap.get(indexName);
            embeddingStore = RedisEmbeddingStore.builder().host(this.redisHost).port(this.redisPort).user("default").password(this.redisPassword).dimension(dimension).indexName(indexName).build();
            this.embeddingStoreMap.put(indexName, embeddingStore);
            return embeddingStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMatchList(String indexName, String searchText, Double matchScore, Integer maxResults) {
        HashMap<String, String> matchMap = new HashMap<String, String>();
        Embedding queryEmbedding = (Embedding)this.getEmbeddingModel(indexName).embed(searchText).content();
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(matchScore).maxResults(maxResults).build();
        EmbeddingSearchResult<TextSegment> embeddedEmbeddingSearchResult = this.getEmbeddingStore(indexName).search(embeddingSearchRequest);
        List embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
        if (embeddingMatcheList.size() > 0) {
            ArrayList<String> words = new ArrayList<String>();
            TokenStream tokenStream = null;
            try {
                HashMap<String, String> authHeader = new HashMap<String, String>();
                authHeader.put("KNOWLEDGEBASECODE", indexName);
                AuthHeaderUtils.setAuthHeader(authHeader);
                IKAnalyzer analyzer = new IKAnalyzer(true);
                tokenStream = analyzer.tokenStream("content", (Reader)new StringReader(searchText));
                tokenStream.reset();
                CharTermAttribute termAttr = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                while (tokenStream.incrementToken()) {
                    words.add(termAttr.toString());
                }
            }
            catch (IOException authHeader) {
            }
            finally {
                if (tokenStream != null) {
                    try {
                        tokenStream.close();
                    }
                    catch (Exception authHeader) {}
                }
            }
            HashMap<Long, Long> pointsMap = new HashMap<Long, Long>();
            block12: for (EmbeddingMatch embeddingMatch : embeddingMatcheList) {
                TextSegment textSegment = (TextSegment)embeddingMatch.embedded();
                if (!StringUtils.isNotBlank((String)textSegment.text())) continue;
                for (String word : words) {
                    KnowledgeEmbeddingPointsEntity pointEntity;
                    IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
                    List pointsList;
                    if (!textSegment.text().contains(word)) continue;
                    QueryWrapper pointsWrapper = new QueryWrapper();
                    if (embeddingMatch.embeddingId() != null && embeddingMatch.embeddingId().contains("tag")) {
                        String pointId = embeddingMatch.embeddingId().split("-")[1];
                        pointsWrapper.like((Object)"id", (Object)pointId);
                    } else {
                        pointsWrapper.like((Object)"uuid", (Object)embeddingMatch.embeddingId());
                    }
                    if ((pointsList = (knowledgeEmbeddingPointsService = (IKnowledgeEmbeddingPointsService)ContextUtil.getBean((String)"knowledgeEmbeddingPointsService", IKnowledgeEmbeddingPointsService.class)).list((Wrapper)pointsWrapper)) == null || pointsList.size() <= 0 || pointsMap.containsKey((pointEntity = (KnowledgeEmbeddingPointsEntity)((Object)pointsList.get(0))).getId())) continue;
                    matchMap.put(indexName + ":" + embeddingMatch.embeddingId(), pointEntity.getContent());
                    pointsMap.put(pointEntity.getId(), pointEntity.getId());
                    continue block12;
                }
            }
        }
        return matchMap;
    }
}

