/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.BillInfoEntity;
import com.ejianc.foundation.ai.service.IBillInfoService;
import com.ejianc.foundation.ai.vo.BillInfoVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billInfo"})
public class BillInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillInfoService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillInfoVO> saveOrUpdate(@RequestBody BillInfoVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", Parameter.getEqInstance((Object)saveOrUpdateVO.getCode()));
        param.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        List list = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u5355\u636e\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        BillInfoEntity entity = (BillInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BillInfoEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        BillInfoVO vo = (BillInfoVO)((Object)BeanMapper.map((Object)((Object)entity), BillInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillInfoVO> queryDetail(Long id) {
        BillInfoEntity entity = (BillInfoEntity)((Object)this.service.selectById(id));
        BillInfoVO vo = (BillInfoVO)((Object)BeanMapper.map((Object)((Object)entity), BillInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> search(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)searchText) && !Objects.equals(searchText, "#")) {
            searchText = searchText.replace("#", "");
            param.getParams().put("billName", new Parameter("like_left", (Object)searchText));
        }
        param.setLimit(Integer.valueOf(20));
        List list = this.service.queryList(param, false);
        ArrayList res = ListUtil.isNotEmpty((List)list) ? list.stream().map(BillInfoEntity::getBillName).map(str -> "#" + str + "#").collect(Collectors.toList()) : Lists.newArrayList();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillInfoVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

