/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.ai.bean.ChatExcelEntity;
import com.ejianc.foundation.ai.service.IChatExcelService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/chatExcel"})
public class ChatExcelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IChatExcelService chatExcelService;

    @PostMapping(value={"/import"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> importExcel(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        String chatExcelId = request.getParameter("chatExcelId");
        Map<String, Object> resultMap = this.chatExcelService.importExcel(chatExcelId, file);
        return CommonResponse.success(resultMap);
    }

    public String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode() {
        String code = "";
        try {
            String str;
            code = str = this.generateRandomString(10);
            boolean flag = true;
            while (flag) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"excel_code", (Object)code);
                List list = this.chatExcelService.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    code = str + this.generateRandomString(4);
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u7f16\u7801\u5931\u8d25");
        }
        return code;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ChatExcelEntity saveData) {
        if (saveData.getId() == null || saveData.getId() == 0L) {
            String code = this.generateCode();
            saveData.setExcelCode(code);
            saveData.setUserId(InvocationInfoProxy.getUserid());
            this.chatExcelService.saveOrUpdate((Object)saveData, false);
            return CommonResponse.success((String)"\u65b0\u589e\u6210\u529f");
        }
        ChatExcelEntity uniqueBean = (ChatExcelEntity)((Object)this.chatExcelService.getById(saveData.getId()));
        uniqueBean.setExcelName(saveData.getExcelName());
        uniqueBean.setRemark(saveData.getRemark());
        uniqueBean.setSequence(saveData.getSequence());
        this.chatExcelService.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/saveData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody JSONObject jsonObject) {
        String chatExcelId = jsonObject.getString("chatExcelId");
        JSONObject contentJson = new JSONObject();
        JSONObject rows = jsonObject.getJSONObject("rows");
        contentJson.put("rows", (Object)rows);
        contentJson.put("styles", (Object)jsonObject.getJSONArray("styles"));
        ChatExcelEntity uniqueBean = (ChatExcelEntity)((Object)this.chatExcelService.getById((Serializable)((Object)chatExcelId)));
        String dataTableName = "chatexcel_data_" + uniqueBean.getExcelCode();
        String deleteAllDataSql = "DELETE FROM " + dataTableName;
        this.chatExcelService.executeSql(deleteAllDataSql);
        List<String> columnList = this.chatExcelService.getColumnList(dataTableName);
        ArrayList dataList = new ArrayList();
        int rowIndex = 0;
        for (String rowKey : rows.keySet()) {
            if ("len".equals(rowKey)) continue;
            if (rowIndex < uniqueBean.getTableHeaderRowCount()) {
                ++rowIndex;
                continue;
            }
            ArrayList<String> datas = new ArrayList<String>();
            try {
                JSONObject row = rows.getJSONObject(rowKey);
                JSONObject cells = row.getJSONObject("cells");
                int columnCount = columnList.size();
                int columnIndex = 0;
                boolean isAddDatas = false;
                for (int i = 0; i < columnCount; ++i) {
                    datas.add("");
                }
                for (String cellKey : cells.keySet()) {
                    if (columnIndex == columnCount) {
                        columnIndex = 0;
                        break;
                    }
                    JSONObject cell = cells.getJSONObject(cellKey);
                    String text = cell.getString("text");
                    if (StringUtils.isNotBlank((String)text)) {
                        text = text.replace("(", "\uff08");
                        text = text.replace(")", "\uff09");
                        text = text.replace("'", "");
                        text = text.replace("\"", "");
                        text = text.replace(",", "\uff0c");
                        text = text.replace(";", "\uff1b");
                        if ((text = text.replace("\\", "")).length() > 250) {
                            datas.set(Integer.parseInt(cellKey), text.substring(0, 250));
                        } else {
                            datas.set(Integer.parseInt(cellKey), text);
                        }
                        isAddDatas = true;
                    } else {
                        datas.set(Integer.parseInt(cellKey), "");
                    }
                    ++columnIndex;
                }
                if (!isAddDatas) continue;
                isAddDatas = false;
                dataList.add(datas);
            }
            catch (Exception row) {}
        }
        String contentJsonStr = contentJson.toString();
        uniqueBean.setContentJson(contentJsonStr);
        this.chatExcelService.updateById((Object)uniqueBean);
        int batchSize = 100;
        for (int i = 0; i < dataList.size(); i += batchSize) {
            List subList = dataList.subList(i, Math.min(i + batchSize, dataList.size()));
            String insertSql = "INSERT INTO `" + dataTableName + "` VALUES ";
            for (int j = 0; j < subList.size(); ++j) {
                insertSql = j == subList.size() - 1 ? insertSql + "(" + IdWorker.getId() + ",'" + StringUtils.join((Collection)((Collection)subList.get(j)), (String)"','") + "')" : insertSql + "(" + IdWorker.getId() + ",'" + StringUtils.join((Collection)((Collection)subList.get(j)), (String)"','") + "'),";
            }
            this.chatExcelService.executeSql(insertSql);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChatExcelEntity> queryDetail(@RequestParam String chatExcelId) {
        ChatExcelEntity bean = (ChatExcelEntity)((Object)this.chatExcelService.getById((Serializable)((Object)chatExcelId)));
        return CommonResponse.success((Object)((Object)bean));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        for (Long id : ids) {
            ChatExcelEntity uniqueBean = (ChatExcelEntity)((Object)this.chatExcelService.getById(id));
            String dataTableName = "chatexcel_data_" + uniqueBean.getExcelCode();
            this.chatExcelService.dropChatExcelTable(dataTableName);
        }
        this.chatExcelService.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChatExcelEntity>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.getOrderMap().put("create_time", "desc");
        queryParam.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        IPage pageData = this.chatExcelService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

