/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.foundation.ai.utils.ThreadPoolUtils;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptResultVO;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receiptAiService")
public class ReceiptAiService {
    private static final Logger logger = LoggerFactory.getLogger(QianfanAppBuilderUtil.class);
    @Autowired
    private IMaterialApi materialApi;
    private final String CACHE_PREFIX = "receiptAiFileId:";
    @Autowired
    private CacheManager cacheManager;

    public AiReceiptResultVO getResultFromCache(String fileId) {
        String cacheKey = this.getCacheKey(fileId);
        return (AiReceiptResultVO)this.cacheManager.get(cacheKey);
    }

    public void saveResultToCache(AiReceiptResultVO receiptResultVO) {
        this.cacheManager.set(this.getCacheKey(receiptResultVO.getFileId()), receiptResultVO);
    }

    private String getCacheKey(String tenantId) {
        return "receiptAiFileId:" + tenantId;
    }

    public void identifyMaterial(AiReceiptResultVO resultVO, String appId, String secretKey) {
        logger.info(JSONObject.toJSONString((Object)resultVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        try {
            CommonResponse materialByIds;
            List receiptVOS = resultVO.getReceiptVOS();
            ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
            HashMap<String, Object> futureMap = new HashMap<String, Object>();
            String tenantid = InvocationInfoProxy.getTenantid().toString();
            for (AiReceiptVO aiReceiptVO : receiptVOS) {
                if (futureMap.containsKey(aiReceiptVO.getKey())) continue;
                Future future = threadPoolUtils.runTask(() -> {
                    StringBuilder content = new StringBuilder();
                    content.append("\u5728\u77e5\u8bc6\u5e93\u67e5\u627e\u79df\u6237ID\uff1a").append(tenantid).append(" \u7269\u6599\u540d\u79f0\uff1a").append(aiReceiptVO.getName().trim());
                    if (StringUtils.isNotBlank((String)aiReceiptVO.getSpec())) {
                        content.append(" \u89c4\u683c\u578b\u53f7\uff1a").append(aiReceiptVO.getSpec().trim());
                    }
                    if (StringUtils.isNotBlank((String)aiReceiptVO.getUnitName())) {
                        content.append(" \u8ba1\u91cf\u5355\u4f4d\uff1a").append(aiReceiptVO.getUnitName().trim());
                    }
                    content.append("\uff0c\u67e5\u8be2\u7ed3\u679c\u5305\u62ec\u79df\u6237ID\u3001\u7269\u6599\u5206\u7c7bID\u3001\u7269\u6599\u5206\u7c7b\u3001\u7269\u6599ID\u3001\u7269\u6599\u540d\u79f0\u3001\u89c4\u683c\u578b\u53f7\u3001\u8ba1\u91cf\u5355\u4f4d\uff0c\u7ed3\u679c\u4ee5JSONArray\u6570\u7ec4\u683c\u5f0f\u7ed9\u51fa\uff0c\u67e5\u8be2\u4e0d\u5230\u8fd4\u56de\u7a7a\u6570\u636e\uff0c\u4ee5\u4fbf\u53ef\u4ee5\u76f4\u63a5\u4f7f\u7528JSONArray.parseArray()\u65b9\u6cd5\u89e3\u6790\u7ed3\u679c\uff0c\u4e0d\u8981\u9644\u52a0\u5176\u4ed6\u5206\u6790\u6027\u8bed\u53e5\u3002");
                    logger.info(content.toString());
                    return QianfanUtils.postChatMsg(content.toString(), appId, secretKey);
                });
                futureMap.put(aiReceiptVO.getKey(), future);
            }
            HashMap<String, AiReceiptVO> aiMaterialMap = new HashMap<String, AiReceiptVO>();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            for (String key : futureMap.keySet()) {
                Future future = (Future)futureMap.get(key);
                try {
                    String result = (String)future.get();
                    JSONObject qFanContent = JSON.parseObject((String)result);
                    String answer = qFanContent.getString("answer");
                    logger.info("\u8bf7\u6c42 id={},\u8fd4\u56deanswer={}", (Object)key, (Object)answer);
                    if (!StringUtils.isNotBlank((String)answer) || !answer.contains("```json") || answer.contains("[]") || answer.contains("{}")) continue;
                    answer = answer.split("```json")[1];
                    answer = answer.split("```")[0];
                    JSONObject jsonObject = null;
                    if (answer.contains("[")) {
                        List jsonObjects = JSONArray.parseArray((String)answer, JSONObject.class);
                        if (CollectionUtils.isEmpty((Collection)jsonObjects)) continue;
                        jsonObject = (JSONObject)jsonObjects.get(0);
                    } else {
                        jsonObject = JSON.parseObject((String)answer);
                    }
                    if (jsonObject == null || !jsonObject.containsKey((Object)"\u7269\u6599ID") || StringUtils.isBlank((String)jsonObject.getString("\u7269\u6599ID")) || jsonObject.getString("\u7269\u6599ID").contains("\u672a\u77e5")) continue;
                    Long materialId = null;
                    try {
                        materialId = Long.valueOf(jsonObject.getString("\u7269\u6599ID"));
                        if (materialId == null) continue;
                        materialIds.add(materialId);
                        AiReceiptVO aiMaterialVO = new AiReceiptVO();
                        aiMaterialVO.setId(materialId);
                        aiMaterialVO.setName(jsonObject.getString("\u7269\u6599\u540d\u79f0"));
                        aiMaterialVO.setSpec(jsonObject.getString("\u89c4\u683c\u578b\u53f7"));
                        aiMaterialVO.setUnitName(jsonObject.getString("\u8ba1\u91cf\u5355\u4f4d"));
                        aiMaterialMap.put(key, aiMaterialVO);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            HashMap<Long, MaterialVO> materialVOMap = new HashMap<Long, MaterialVO>();
            if (CollectionUtils.isNotEmpty(materialIds) && (materialByIds = this.materialApi.queryMaterialByIds(materialIds)).isSuccess() && materialByIds.getData() != null) {
                for (MaterialVO datum : (List)materialByIds.getData()) {
                    materialVOMap.put(datum.getId(), datum);
                }
            }
            if (!materialVOMap.isEmpty()) {
                for (AiReceiptVO aiReceiptVO : receiptVOS) {
                    AiReceiptVO materialVO = (AiReceiptVO)aiMaterialMap.get(aiReceiptVO.getKey());
                    if (materialVO != null && materialVO.getId() != null && materialVOMap.get(materialVO.getId()) != null) {
                        MaterialVO resVO = (MaterialVO)materialVOMap.get(materialVO.getId());
                        aiReceiptVO.setCategoryId(resVO.getCategoryId());
                        aiReceiptVO.setCategoryName(resVO.getCategoryName());
                        aiReceiptVO.setId(resVO.getId());
                        aiReceiptVO.setCode(resVO.getCode());
                        aiReceiptVO.setName(resVO.getName());
                        aiReceiptVO.setSpec(resVO.getSpec());
                        aiReceiptVO.setUnitName(resVO.getUnitName());
                        aiReceiptVO.setTenantId(resVO.getTenantId());
                        continue;
                    }
                    aiReceiptVO.setId(null);
                }
            }
            resultVO.setCode(Integer.valueOf(2));
            resultVO.setMsg("");
            resultVO.setReceiptVOS(receiptVOS);
            this.saveResultToCache(resultVO);
            logger.info("=================\u5339\u914d\u7269\u8d44\u5e93\u7ed3\u679c===========================");
            logger.info(JSONObject.toJSONString((Object)resultVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            logger.info("==============================================");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

