/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.locale;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:i18n/messages*.properties"})
public class LocaleResources {
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap<String, ResourceBundle>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String key, Object ... params) {
        String localeStr = InvocationInfoProxy.getLocale();
        Locale locale = "en".equals(localeStr) ? Locale.ENGLISH : Locale.CHINA;
        ResourceBundle message = MESSAGES.get(locale.getLanguage());
        if (message == null) {
            Map<String, ResourceBundle> map = MESSAGES;
            synchronized (map) {
                message = MESSAGES.get(locale.getLanguage());
                if (message == null) {
                    message = ResourceBundle.getBundle("i18n/messages", locale);
                    MESSAGES.put(locale.getLanguage(), message);
                }
            }
        }
        if (params != null) {
            return String.format(message.getString(key), params);
        }
        return message.getString(key);
    }

    public static void flushMessage() {
        MESSAGES.clear();
    }
}

