/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.splitter;

import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.HierarchicalDocumentSplitter;
import dev.langchain4j.model.Tokenizer;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class DocumentByCharacterSplitter
extends HierarchicalDocumentSplitter {
    public DocumentByCharacterSplitter(int maxSegmentSizeInChars, int maxOverlapSizeInChars) {
        super(maxSegmentSizeInChars, maxOverlapSizeInChars, null, null);
    }

    public DocumentByCharacterSplitter(int maxSegmentSizeInChars, int maxOverlapSizeInChars, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInChars, maxOverlapSizeInChars, null, subSplitter);
    }

    public DocumentByCharacterSplitter(int maxSegmentSizeInTokens, int maxOverlapSizeInTokens, Tokenizer tokenizer) {
        super(maxSegmentSizeInTokens, maxOverlapSizeInTokens, tokenizer, null);
    }

    public DocumentByCharacterSplitter(int maxSegmentSizeInTokens, int maxOverlapSizeInTokens, Tokenizer tokenizer, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInTokens, maxOverlapSizeInTokens, tokenizer, subSplitter);
    }

    @Override
    public String[] split(String text) {
        ArrayList<String> segmentList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)text)) {
            String[] charArr = text.split("");
            StringBuilder segment = new StringBuilder("");
            int step = 1;
            for (int i = 0; i < charArr.length; ++i) {
                if (step <= this.maxSegmentSize) {
                    ++step;
                    segment.append(charArr[i]);
                    continue;
                }
                step = 1;
                segmentList.add(segment.toString());
                segment = new StringBuilder("");
            }
            if (StringUtils.isNotBlank((String)(segment + ""))) {
                segmentList.add(segment.toString());
            }
        }
        return segmentList.toArray(new String[0]);
    }

    @Override
    public String joinDelimiter() {
        return "";
    }

    @Override
    protected DocumentSplitter defaultSubSplitter() {
        return null;
    }
}

