/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisTemplate<K, V> {
    private static Logger logger = LoggerFactory.getLogger(RedisTemplate.class);
    private JedisPool jedisPool;

    public RedisTemplate() {
    }

    public RedisTemplate(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(K key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.del(key.toString()) > 0L;
            return bl;
        }
        catch (Exception e) {
            logger.error("Jedis exception happen.", (Object)e.getMessage());
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long delete(Collection<K> keys) {
        Long l;
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            Long count = 0L;
            jedis = this.jedisPool.getResource();
            for (K key : keys) {
                jedis.del(key.toString());
                count = count + 1L;
            }
            l = count;
        }
        catch (Exception e) {
            try {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                this.jedisPool.returnResource(jedis);
                throw throwable;
            }
            this.jedisPool.returnResource(jedis);
            return 0L;
        }
        this.jedisPool.returnResource(jedis);
        return l;
    }

    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return new DefaultHashOperations();
    }

    public ValueOperations<K, V> opsForValue() {
        return new DefaultValueOperations();
    }

    public class DefaultValueOperations<K, V>
    implements ValueOperations<K, V> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                String string = jedis.get(key.toString());
                return (V)string;
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(K key, V value) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                jedis.set(key.toString(), value.toString());
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(K key, V value, long timeout, TimeUnit unit) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                jedis.setex(key.toString(), (long)((int)unit.toSeconds(timeout)), value.toString());
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
        }
    }

    public class DefaultHashOperations<H, HK, HV>
    implements HashOperations<H, HK, HV> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(H key, HK hashKey, HV value) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                jedis.hset(key.toString(), hashKey.toString(), value.toString());
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HV get(H key, Object hashKey) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                String string = jedis.hget(key.toString(), hashKey.toString());
                return (HV)string;
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean hasKey(H key, Object hashKey) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                Boolean bl = jedis.hexists(key.toString(), hashKey.toString());
                return bl;
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hdel(H key, Object hashKey) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                jedis.hdel(key.toString(), new String[]{hashKey.toString()});
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hdel(H key, Collection<Object> hashKey) {
            Jedis jedis = null;
            try {
                jedis = RedisTemplate.this.jedisPool.getResource();
                for (Object o : hashKey) {
                    jedis.hdel(key.toString(), new String[]{o.toString()});
                }
            }
            catch (Exception e) {
                logger.error("Jedis exception happen.", (Object)e.getMessage());
            }
            finally {
                RedisTemplate.this.jedisPool.returnResource(jedis);
            }
        }
    }
}

