package com.ejianc.foundation.ai.bean;

import java.math.*;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * AI智能体表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ai_agent")
public class AgentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 智能体编码
    @TableField(value="name")
    private String name; // 智能体名称
    @TableField(value="agent_state")
    private Integer agentState; // 启停用状态（1：启用， 0：停用）
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="role_instruction")
    private String roleInstruction; // 角色指令
    @TableField(value="model_id")
    private Long modelId; // 大模型id
    @TableField(value="model_name")
    private String modelName; // 大模型名称
    @TableField(value="knowledge_ids")
    private String knowledgeIds; // 知识库ids
    @TableField(value="knowledge_names")
    private String knowledgeNames; // 知识库名称
    @TableField(value="call_back_num")
    private Integer callBackNum; // 召回数量
    @TableField(value="match_score")
    private BigDecimal matchScore; // 匹配分
    @TableField(value="temperature")
    private BigDecimal temperature; //温度
    @TableField(value="icon")
    private String icon; // 智能体图标连接地址
    @TableField(value="strict_flag")
    private Integer strictFlag;//是否严格模式,严格模式：严格匹配知识库，知识库中如无搜索结果，直接返回无答案;非严格模式：非严格匹配知识库，知识库中如无搜索结果，将用户提问传给LLM继续请求答案
    @TableField(value="knowledge_gyyflag")
    private Integer knowledgeGyyFlag; //是否公有云知识库

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getAgentState() {
        return agentState;
    }

    public void setAgentState(Integer agentState) {
        this.agentState = agentState;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRoleInstruction() {
        return roleInstruction;
    }

    public void setRoleInstruction(String roleInstruction) {
        this.roleInstruction = roleInstruction;
    }
    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }
    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
    public String getKnowledgeIds() {
        return knowledgeIds;
    }

    public void setKnowledgeIds(String knowledgeIds) {
        this.knowledgeIds = knowledgeIds;
    }
    public String getKnowledgeNames() {
        return knowledgeNames;
    }

    public void setKnowledgeNames(String knowledgeNames) {
        this.knowledgeNames = knowledgeNames;
    }
    public Integer getCallBackNum() {
        return callBackNum;
    }

    public void setCallBackNum(Integer callBackNum) {
        this.callBackNum = callBackNum;
    }
    public BigDecimal getMatchScore() {
        return matchScore;
    }

    public void setMatchScore(BigDecimal matchScore) {
        this.matchScore = matchScore;
    }
    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Integer getStrictFlag() {
        return strictFlag;
    }

    public void setStrictFlag(Integer strictFlag) {
        this.strictFlag = strictFlag;
    }

    public BigDecimal getTemperature() {
        return temperature;
    }

    public void setTemperature(BigDecimal temperature) {
        this.temperature = temperature;
    }

    public Integer getKnowledgeGyyFlag() {
        return knowledgeGyyFlag;
    }

    public void setKnowledgeGyyFlag(Integer knowledgeGyyFlag) {
        this.knowledgeGyyFlag = knowledgeGyyFlag;
    }
}
