package com.ejianc.foundation.ai.config;

import java.util.Map;

public class AuthHeaderUtils {

	public static final ThreadLocal<Map<String, String>> loginInfo = new ThreadLocal<Map<String, String>>();

	public static  final String KNOWLEDGEBASECODE="KNOWLEDGEBASECODE";

	//私有空方法，防止实例化
	private AuthHeaderUtils() {}
	
	public static String getKnowledgeBaseCode() {
		String knowledgeBaseId=null;
		Map<String, String> s = (Map<String, String>) loginInfo.get();
		if (s!=null) {
			knowledgeBaseId=s.get(KNOWLEDGEBASECODE);
		}
        return knowledgeBaseId;
	}

	public static void setAuthHeader(Map<String, String> authHeader) {
		AuthHeaderUtils.loginInfo.set(authHeader);
	}

	public static String getType() {
		String type="";
		Map<String, String> s = (Map<String, String>) loginInfo.get();
		if (s!=null) {
			type=s.get(type);
		}
		return type;
	}
}
