package com.ejianc.foundation.ai.config;

import com.ejianc.foundation.ai.service.IModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConfigurationProperties(prefix = "ejc.embedding.store")
public class EjcAiBeanConfig {
    private String redisHost;

    private Integer redisPort;

    private String redisPassword;

    @Autowired
    private IModelService modelService;

    @Bean
    @Primary
    public EjcAiEmbeding initKbEmbeddingStore() {
        return new EjcAiEmbeding(redisHost, redisPort, redisPassword, modelService);
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public void setRedisPort(Integer redisPort) {
        this.redisPort = redisPort;
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }
}
