package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.vo.AgentDialogContentVO;
import com.ejianc.foundation.ai.vo.AgentDialogVO;
import com.ejianc.foundation.ai.vo.AgentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * AI智能体表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("agent")
public class AgentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAgentService service;
    @Autowired
    private IKnowledgeMessageHistoryService KnowledgeMessageHistoryService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;

    public  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }

        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            // 输出设置，大小写，音标方式
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<AgentEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("code", code);
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

                List<AgentEntity> list = service.list(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            logger.info("生成编码失败:{}",e);
            throw new BusinessException("生成编码失败");
        }
        return code;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AgentVO> saveOrUpdate(@RequestBody AgentVO saveOrUpdateVO) {
    	AgentEntity entity = BeanMapper.map(saveOrUpdateVO, AgentEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //新增
            String code = generateCode();
            entity.setCode(code);
            service.saveOrUpdate(entity, false);

            return CommonResponse.success("保存成功");
        }else{
            AgentEntity uniqueBean = service.selectById(entity.getId());
            uniqueBean.setName(entity.getName());
            uniqueBean.setAgentState(entity.getAgentState());
            uniqueBean.setDescription(entity.getDescription());
            uniqueBean.setRoleInstruction(entity.getRoleInstruction());
            uniqueBean.setModelId(entity.getModelId());
            if(1 == entity.getKnowledgeGyyFlag()) {
                uniqueBean.setKnowledgeIds("");
                uniqueBean.setKnowledgeNames("");
            }else{
                uniqueBean.setKnowledgeIds(entity.getKnowledgeIds());
                uniqueBean.setKnowledgeNames(entity.getKnowledgeNames());
            }
            uniqueBean.setMatchScore(entity.getMatchScore());
            uniqueBean.setCallBackNum(entity.getCallBackNum());
            uniqueBean.setIcon(entity.getIcon());
            uniqueBean.setStrictFlag(entity.getStrictFlag());
            uniqueBean.setTemperature(entity.getTemperature());
            uniqueBean.setKnowledgeGyyFlag(entity.getKnowledgeGyyFlag());

            service.saveOrUpdate(uniqueBean, false);
            return CommonResponse.success("修改成功");
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AgentVO> queryDetail(Long id) {
    	AgentEntity entity = service.selectById(id);
    	AgentVO vo = BeanMapper.map(entity, AgentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AgentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AgentEntity> page = service.queryPage(param,false);
        IPage<AgentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AgentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refAgentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AgentVO>> refAgentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AgentEntity> page = service.queryPage(param,false);
        IPage<AgentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AgentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     /**
     * 根据智能体获取智能对话记录
     *
     * @param agentId 智能体的ID
     * @return 包含智能对话记录的响应
     */
    @RequestMapping(value = "/getDialogRecordsByAgent", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> getDialogRecordsByAgent(@RequestParam Long agentId, @RequestParam String searchValue, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        Long userId = InvocationInfoProxy.getUserid();
        // 查询条件
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("agentId", new Parameter(QueryParam.EQ, agentId));
        queryParam.getParams().put("userId", new Parameter(QueryParam.EQ, userId));
        queryParam.getOrderMap().put("topFlag", QueryParam.DESC);
        queryParam.getOrderMap().put("topOptDate", QueryParam.ASC);
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        if(StringUtils.isNotBlank(searchValue)) {
            queryParam.getParams().put("title", new Parameter(QueryParam.LIKE, searchValue));
        }
        if("true".equals(reloadFlag)) {
            queryParam.setPageIndex(pageIndex);
            queryParam.setPageSize(20);
        }else{
            queryParam.setPageIndex(1);
            queryParam.setPageSize(pageIndex*20);
        }
        // 查询对话记录
        IPage<KnowledgeMessageHistoryEntity> pageData = KnowledgeMessageHistoryService.queryPage(queryParam , false);
        List<KnowledgeMessageHistoryEntity> dialogRecords = pageData.getRecords();
        // 返回查询结果
        return CommonResponse.success("查询智能对话记录成功！", dialogRecords);
    }

   /**
     * 根据对话id,查询此次对话的智能对话记录
     *
     * @param dialogId 对话ID
     * @return 此次对话的智能对话记录的响应
     */
    @RequestMapping(value = "/getDialogRecordsByDialogId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageEntity>> getDialogRecordsByDialogId(@RequestParam Long dialogId) {
        Long userId = InvocationInfoProxy.getUserid();
        // 查询条件
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("message_history_id", new Parameter(QueryParam.EQ, dialogId));
        queryParam.getParams().put("userId", new Parameter(QueryParam.EQ, userId));
        queryParam.getParams().put("parentId", new Parameter(QueryParam.EQ, null));
        queryParam.getOrderMap().put("createTime", QueryParam.ASC); // 按顺序排列对话记录
        // 查询对话内容记录
        List<KnowledgeMessageEntity> knowledgeMessageRecords = knowledgeMessageService.queryList(queryParam, false);
        if(knowledgeMessageRecords != null && knowledgeMessageRecords.size() > 0) {
            for (KnowledgeMessageEntity contentRecord : knowledgeMessageRecords) {
                queryParam.getParams().put("parentId", new Parameter(QueryParam.EQ, contentRecord.getId()));
                List<KnowledgeMessageEntity> childContentRecords = knowledgeMessageService.queryList(queryParam, false);
                contentRecord.setChildren(childContentRecords);
            }
        }
        // 返回查询结果
        return CommonResponse.success("查询对话记录成功！", knowledgeMessageRecords);
    }


    /**
    * 置顶/取消置顶 对话记录
    * */
    @RequestMapping(value = "/dialogTopUp", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> dialogTopUp(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam Integer topFlag, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = KnowledgeMessageHistoryService.getById(dialogId);
        dialogEntity.setTopFlag(topFlag);
        if(1 == topFlag) {
            dialogEntity.setTopOptDate(new Date());
        }else{
            dialogEntity.setTopOptDate(null);
        }
        KnowledgeMessageHistoryService.saveOrUpdate(dialogEntity,false);
        // 返回查询结果
        return getDialogRecordsByAgent(dialogEntity.getAgentId(), searchValue, pageIndex, reloadFlag);
    }

    /**
    * 修改 对话  名称
    * */
    @RequestMapping(value = "/updateDialogName", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> updateDialogName(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam String title, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = KnowledgeMessageHistoryService.getById(dialogId);
        dialogEntity.setTitle(title);
        KnowledgeMessageHistoryService.saveOrUpdate(dialogEntity,false);
        // 返回查询结果
        return getDialogRecordsByAgent(dialogEntity.getAgentId(),searchValue,pageIndex,reloadFlag);
    }

    /**
    * 删除对话
    * */
    @RequestMapping(value = "/deleteDialog", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeMessageHistoryEntity>> deleteDialog(@RequestParam Long dialogId, @RequestParam String searchValue, @RequestParam Integer pageIndex, @RequestParam String reloadFlag) {
        KnowledgeMessageHistoryEntity dialogEntity = KnowledgeMessageHistoryService.getById(dialogId);

        UpdateWrapper<KnowledgeMessageEntity> wrapper = new UpdateWrapper<>();
        wrapper.eq("message_history_id",dialogId);
        knowledgeMessageService.remove(wrapper);

        KnowledgeMessageHistoryService.removeById(dialogId);
        // 返回查询结果
        return getDialogRecordsByAgent(dialogEntity.getAgentId(),searchValue,pageIndex,reloadFlag);
    }
}
