package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.ai.bean.KnowledgeMessageEntity;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.foundation.ai.service.IKnowledgeMessageService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.vdurmont.emoji.EmojiParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * AI模型表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("chat")
public class ChatController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAgentService agentService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping(value = "/chatWithAgent", produces = MediaType.TEXT_EVENT_STREAM_VALUE)
    @ResponseBody
    public SseEmitter chatWithAgent(@RequestBody JSONObject param) {
        String text = param.getString("text");
        Long agentId = param.getLong("agentId");
        Long dialogId = param.getLong("dialogId");
        Long knowledgeMessageId = param.getLong("knowledgeMessageId");
        Boolean makeBill = param.getBoolean("makeBill");
        String billResponse = param.getString("billResponse");
        return agentService.chatWithAgent(text,agentId,dialogId,knowledgeMessageId,makeBill,billResponse);
    }

    @RequestMapping(value = "/chatWithAgentByApi", method = RequestMethod.POST)
    public CommonResponse<JSONObject> chatWithAgentByApi(@RequestBody ChatParam chatParam) {
        return agentService.chatWithAgentByApi(chatParam);
    }

    @PostMapping(value = "/stopChat")
    @ResponseBody
    public CommonResponse<String> stopChat(@RequestBody JSONObject param) {
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        String currentAnswerId = param.getString("currentAnswerId");
        String knowledgeMessageId = param.getString("knowledgeMessageId");
        KnowledgeMessageEntity knowledgeMessageEntity = knowledgeMessageService.getById(knowledgeMessageId);
        String currentChatContent = param.getString("currentChatContent");
        String respKey = "RESP_ANSWER:"+currentAnswerId;
        redisTemplate.opsForValue().set(respKey, "false", 30, TimeUnit.MINUTES);

        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(Long.parseLong(currentAnswerId));
        answerMessageEntity.setParentId(knowledgeMessageEntity.getId());

        currentChatContent = EmojiParser.removeAllEmojis(currentChatContent);
        answerMessageEntity.setContent(currentChatContent);
        answerMessageEntity.setUserId(userId);
        answerMessageEntity.setMessageHistoryId(knowledgeMessageEntity.getMessageHistoryId());
        answerMessageEntity.setTenantId(tenantId);
        knowledgeMessageService.saveOrUpdate(answerMessageEntity,false);

        return CommonResponse.success();
    }

}
