package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.ai.bean.ChatExcelEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IChatExcelService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;

@Controller
@RequestMapping("/chatExcel")
public class ChatExcelController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IChatExcelService chatExcelService;

    @PostMapping({"/import"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> importExcel(HttpServletRequest request, @RequestParam("file") MultipartFile file) {
        String chatExcelId = request.getParameter("chatExcelId");
        Map<String, Object> resultMap = chatExcelService.importExcel(chatExcelId, file);
        return CommonResponse.success(resultMap);
    }

    public  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }

        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<ChatExcelEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("excel_code", code);

                List<ChatExcelEntity> list = chatExcelService.list(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            throw new BusinessException("生成编码失败");
        }
        return code;
    }

    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ChatExcelEntity saveData) {
        if(saveData.getId() == null || saveData.getId() == 0) {
            String code = generateCode();

            saveData.setExcelCode(code);
            saveData.setUserId(InvocationInfoProxy.getUserid());
            chatExcelService.saveOrUpdate(saveData, false);

            return CommonResponse.success("新增成功");
        }else{
            ChatExcelEntity uniqueBean = chatExcelService.getById(saveData.getId());
            uniqueBean.setExcelName(saveData.getExcelName());
            uniqueBean.setRemark(saveData.getRemark());
            uniqueBean.setSequence(saveData.getSequence());
            chatExcelService.saveOrUpdate(uniqueBean, false);

            return CommonResponse.success("修改成功");
        }
    }

    @RequestMapping(value = "/saveData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody JSONObject jsonObject) {
        String chatExcelId = jsonObject.getString("chatExcelId");

        JSONObject contentJson = new JSONObject();
        JSONObject rows = jsonObject.getJSONObject("rows");

        contentJson.put("rows", rows);
        contentJson.put("styles", jsonObject.getJSONArray("styles"));

        ChatExcelEntity uniqueBean = chatExcelService.getById(chatExcelId);

        String dataTableName = "chatexcel_data_"+uniqueBean.getExcelCode();
        //先清理数据
        String deleteAllDataSql = "DELETE FROM "+dataTableName;
        chatExcelService.executeSql(deleteAllDataSql);

        //查询所有列名
        List<String> columnList = chatExcelService.getColumnList(dataTableName);
        //循环插入数据
        List<List<String>> dataList = new ArrayList<>();
        int rowIndex = 0;
        for(String rowKey:rows.keySet()) {
            if("len".equals(rowKey)) {
                continue;
            }
            if(rowIndex < uniqueBean.getTableHeaderRowCount()) {
                rowIndex = rowIndex + 1;
                continue;
            }


            List<String> datas = new ArrayList<>();
            try{
                JSONObject row = rows.getJSONObject(rowKey);
                JSONObject cells = row.getJSONObject("cells");

                int columnCount = columnList.size();
                int columnIndex = 0;

                boolean isAddDatas = false;
                for(int i=0;i<columnCount;i++) {
                    datas.add("");
                }
                for(String cellKey : cells.keySet()) {
                    if (columnIndex == columnCount) {
                        columnIndex = 0;
                        break;
                    }
                    JSONObject cell = cells.getJSONObject(cellKey);
                    String text = cell.getString("text");

                    if(StringUtils.isNotBlank(text)) {
                        text = text.replace("(", "（");
                        text = text.replace(")", "）");
                        text = text.replace("'", "");
                        text = text.replace("\"", "");
                        text = text.replace(",", "，");
                        text = text.replace(";", "；");
                        text = text.replace("\\", "");

                        if(text.length() > 250) {
                            datas.set(Integer.parseInt(cellKey),text.substring(0,250));
                        }else{
                            datas.set(Integer.parseInt(cellKey),text);
                        }
                        isAddDatas = true;
                    }else{
                        datas.set(Integer.parseInt(cellKey),"");
                    }
                    columnIndex = columnIndex + 1;
                }
                if(isAddDatas) {
                    isAddDatas = false;
                    dataList.add(datas);
                }
            }catch (Exception e) {}
        }

        String contentJsonStr = contentJson.toString();
        uniqueBean.setContentJson(contentJsonStr);
        chatExcelService.updateById(uniqueBean);

        int batchSize = 100;
        for(int i=0; i < dataList.size(); i+=batchSize) {
            List<List<String>> subList = dataList.subList(i, Math.min(i + batchSize, dataList.size()));
            String insertSql = "INSERT INTO `"+dataTableName+"` VALUES ";
            for(int j=0;j<subList.size();j++) {
                if(j == (subList.size() -1)) {
                    insertSql += "("+ IdWorker.getId()+",'"+ StringUtils.join(subList.get(j),"','")+"')";
                }else{
                    insertSql += "("+IdWorker.getId()+",'"+StringUtils.join(subList.get(j),"','")+"'),";
                }
            }
            chatExcelService.executeSql(insertSql);
        }
        return CommonResponse.success("保存成功");
    }

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChatExcelEntity> queryDetail(@RequestParam String chatExcelId) {
        ChatExcelEntity bean = chatExcelService.getById(chatExcelId);
        return CommonResponse.success(bean);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        for(Long id:ids) {
            ChatExcelEntity uniqueBean = chatExcelService.getById(id);
            String dataTableName = "chatexcel_data_"+uniqueBean.getExcelCode();
            chatExcelService.dropChatExcelTable(dataTableName);
        }
        chatExcelService.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChatExcelEntity>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);

        queryParam.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<ChatExcelEntity> pageData = chatExcelService.queryPage(queryParam);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
