package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.ExtDictEntity;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IExtDictService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.vo.ExtDictVO;
import com.ejianc.foundation.ai.vo.KnowledgeBaseVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * AI扩展字段
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("extDict")
public class ExtDictController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExtDictService service;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IExtDictRelationService extDictRelationService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExtDictVO> saveOrUpdate(@RequestBody ExtDictVO saveOrUpdateVO) {
        ExtDictEntity entity = BeanMapper.map(saveOrUpdateVO, ExtDictEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //新增
            entity.setField(saveOrUpdateVO.getField());
            entity.setKnowledgeBaseId(saveOrUpdateVO.getKnowledgeBaseId());
            entity.setKnowledgeBaseCode(saveOrUpdateVO.getKnowledgeBaseCode());
            service.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功");
        }else{
            ExtDictEntity uniqueBean = service.selectById(entity.getId());
            uniqueBean.setField(saveOrUpdateVO.getField());
            uniqueBean.setKnowledgeBaseId(saveOrUpdateVO.getKnowledgeBaseId());
            uniqueBean.setKnowledgeBaseCode(saveOrUpdateVO.getKnowledgeBaseCode());
            service.saveOrUpdate(uniqueBean, false);
            return CommonResponse.success("修改成功");
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExtDictVO> queryDetail(Long id) {
        ExtDictEntity entity = service.selectById(id);
        ExtDictVO vo = BeanMapper.map(entity, ExtDictVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExtDictVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("field");
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ExtDictEntity> page = service.queryPage(param,false);
        IPage<ExtDictVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExtDictVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryExtDictRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExtDictVO>> queryKnowledgeBaseRefList(@RequestParam(required = false) String condition,
                                                                            @RequestParam(required = false) String searchText,
                                                                            @RequestParam int pageSize,
                                                                            @RequestParam int pageNumber,
                                                                            @RequestParam(required=false) String relyCondition,
                                                                            @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("field");
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("embeddingId")!=null){
                Long embeddingId = _con.getLong("embeddingId");
                KnowledgeBaseEntity en = knowledgeBaseService.queryBaseDataByEmbeddingId(embeddingId);
                queryParam.getParams().put("knowledgeBaseId", new Parameter(QueryParam.EQ, en.getId()));
                //获取该切片目前关联的数据
                QueryWrapper<ExtDictRelationEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("embedding_id", embeddingId);
                List<ExtDictRelationEntity> list = extDictRelationService.list(wrapper);
                List<Long> ids = new ArrayList<>();
                if(list!=null && list.size()>0){
                    list.forEach(item -> {
                        ids.add(item.getExtDictId());
                    });
                    queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
                }
            }
        }

        IPage<ExtDictEntity> pageData = service.queryPage(queryParam);
        IPage<ExtDictVO> pageResult = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if(pageData != null && pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            List<ExtDictVO> knowledgeVos = BeanMapper.mapList(pageData.getRecords(), ExtDictVO.class);
            pageResult.setRecords(knowledgeVos);
        }
        return CommonResponse.success("查询成功!", pageResult);
    }

}
