package com.ejianc.foundation.ai.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * AI扩展字段关联关系表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("extDictRelation")
public class ExtDictRelationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExtDictRelationService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExtDictRelationVO> saveOrUpdate(@RequestBody ExtDictRelationVO saveOrUpdateVO) {
        ExtDictRelationEntity entity = BeanMapper.map(saveOrUpdateVO, ExtDictRelationEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //新增
            entity.setEmbeddingId(saveOrUpdateVO.getEmbeddingId());
            entity.setExtDictId(saveOrUpdateVO.getExtDictId());
            entity.setType(saveOrUpdateVO.getType());
            service.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功");
        }else{
            ExtDictRelationEntity uniqueBean = service.selectById(entity.getId());
            entity.setEmbeddingId(saveOrUpdateVO.getEmbeddingId());
            entity.setExtDictId(saveOrUpdateVO.getExtDictId());
            entity.setType(saveOrUpdateVO.getType());
            service.saveOrUpdate(uniqueBean, false);
            return CommonResponse.success("修改成功");
        }
    }

    @RequestMapping(value = "/saveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveList(@RequestBody List<ExtDictRelationVO> list) {
        service.saveList(list);
        return CommonResponse.success("修改成功");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExtDictRelationVO> queryDetail(Long id) {
        ExtDictRelationEntity entity = service.selectById(id);
        ExtDictRelationVO vo = BeanMapper.map(entity, ExtDictRelationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.delete(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExtDictRelationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ExtDictRelationEntity> page = service.queryPage(param,false);
        IPage<ExtDictRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExtDictRelationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
