package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 知识切片表（向量）
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeEmbedding")
public class KnowledgeEmbeddingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeEmbeddingService service;

    @Autowired
    private IExtDictRelationService extDictRelationService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> saveOrUpdate(@RequestBody KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingVO vo = service.saveData(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 修改
     */
    @RequestMapping(value = "/saveSimple", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> saveSimple(@RequestBody KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingEntity.class);
        service.saveOrUpdate(entity, false);
        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 保存表格数据
     */
    @RequestMapping(value = "/saveTableData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> saveTableData(@RequestBody KnowledgeEmbeddingVO saveOrUpdateVO) {
        if(saveOrUpdateVO.getType()!=null && (saveOrUpdateVO.getType()==1 || saveOrUpdateVO.getType()==3)){
            //自动生成修改后状态修改未
            saveOrUpdateVO.setType(3);
        }else{
            saveOrUpdateVO.setType(2);
        }
        KnowledgeEmbeddingVO vo = service.saveTableData(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description restoreData 还原
     */
    @RequestMapping(value = "/restoreData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> restoreData(@RequestBody KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingVO vo = service.restoreData(data);
    	return CommonResponse.success("还原数据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 启用
     */
    @RequestMapping(value = "/enableData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> enableData(@RequestBody KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingVO vo = service.enableData(data);
    	return CommonResponse.success("启用成功！",vo);
    }
    /**
     * @Description saveOrUpdate 停用
     */
    @RequestMapping(value = "/disableData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> disableData(@RequestBody KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingVO vo = service.disableData(data);
    	return CommonResponse.success("停用成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingVO> queryDetail(Long id) {
    	KnowledgeEmbeddingEntity entity = service.selectById(id);
    	KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(Long id) {
        service.delData(id);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeEmbeddingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("content");
        param.getOrderMap().put("sequence", QueryParam.DESC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<KnowledgeEmbeddingEntity> page = service.queryPage(param,false);
        IPage<KnowledgeEmbeddingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<KnowledgeEmbeddingVO> vos = new ArrayList<>();
        if(page.getRecords()!=null && page.getRecords().size()>0){
            List<Long> embeddingIds = new ArrayList<>();
            page.getRecords().forEach(item -> {
                KnowledgeEmbeddingVO vo = BeanMapper.map(item, KnowledgeEmbeddingVO.class);
                embeddingIds.add(vo.getId());
                vos.add(vo);
            });
            List<ExtDictRelationVO> list = extDictRelationService.queryListByEmbeddingIds(embeddingIds);
            Map<Long, List<ExtDictRelationVO>> map = new HashMap<>();
            for (ExtDictRelationVO extDictRelationVO : list) {
                if(map.get(extDictRelationVO.getEmbeddingId())!=null){
                    List<ExtDictRelationVO> li = map.get(extDictRelationVO.getEmbeddingId());
                    li.add(extDictRelationVO);
                    map.put(extDictRelationVO.getEmbeddingId(), li);
                }else{
                    List<ExtDictRelationVO> li = new ArrayList<>();
                    li.add(extDictRelationVO);
                    map.put(extDictRelationVO.getEmbeddingId(), li);
                }
            }
            vos.forEach(item -> {
                item.setTagList(map.get(item.getId()));
            });
        }

  		pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<KnowledgeEmbeddingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("KnowledgeEmbedding-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKnowledgeEmbeddingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeEmbeddingVO>> refKnowledgeEmbeddingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KnowledgeEmbeddingEntity> page = service.queryPage(param,false);
        IPage<KnowledgeEmbeddingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeEmbeddingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
