package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.ai.bean.ModelEntity;
import com.ejianc.foundation.ai.service.IModelService;
import com.ejianc.foundation.ai.vo.ModelVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * AI模型表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("model")
public class ModelController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IModelService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ModelVO> saveOrUpdate(@RequestBody ModelVO saveOrUpdateVO) {
    	ModelEntity entity = BeanMapper.map(saveOrUpdateVO, ModelEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            service.saveOrUpdate(entity, false);

            return CommonResponse.success("保存成功");
        }else{
            if(1 == entity.getEmbeddingModelFlag()) {
                UpdateWrapper<ModelEntity> updateWrapper = new UpdateWrapper<>();
                updateWrapper.set("embedding_model_flag", 0);
                service.update(updateWrapper);
            }

            ModelEntity uniqueBean = service.selectById(entity.getId());
            uniqueBean.setTitle(entity.getTitle());
            uniqueBean.setModelName(entity.getModelName());
            uniqueBean.setPlatform(entity.getPlatform());
            uniqueBean.setAppConfig(entity.getAppConfig());
            uniqueBean.setBaseUrl(entity.getBaseUrl());
            uniqueBean.setContextWindow(entity.getContextWindow());
            uniqueBean.setMaxInputTokens(entity.getMaxInputTokens());
            uniqueBean.setMaxOutputTokens(entity.getMaxOutputTokens());
            uniqueBean.setModelState(entity.getModelState());
            uniqueBean.setEmbeddingModelFlag(entity.getEmbeddingModelFlag());
            service.saveOrUpdate(uniqueBean, false);

            return CommonResponse.success("修改成功");
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ModelVO> queryDetail(Long id) {
    	ModelEntity entity = service.selectById(id);
    	ModelVO vo = BeanMapper.map(entity, ModelVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param queryParam
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ModelEntity>> queryList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getOrderMap().put("createTime", QueryParam.ASC);

        IPage<ModelEntity> page = service.queryPage(queryParam,false);

        return CommonResponse.success("查询列表数据成功！",page);
    }


    /**
     * @Description queryList 查询所有列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAllList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ModelEntity>> queryAllList() {
        QueryParam queryParam = QueryParam.getInstance();
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("modelState",new Parameter(QueryParam.EQ, 1));
        queryParam.getOrderMap().put("createTime", QueryParam.ASC);
        List<ModelEntity> page = service.queryList(queryParam,false);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refModelData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ModelEntity>> refModelData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("modelState",new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ModelEntity> page = service.queryPage(param,false);

        return CommonResponse.success("查询参照数据成功！",page);
     }
}
