package com.ejianc.foundation.ai.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.foundation.ai.utils.ThreadPoolUtils;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptResultVO;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@Service("receiptAiService")
public class ReceiptAiService {

    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(QianfanAppBuilderUtil.class);

    @Autowired
    private IMaterialApi materialApi;

    private final String CACHE_PREFIX = "receiptAiFileId:";

    @Autowired
    private CacheManager cacheManager;

    public AiReceiptResultVO getResultFromCache(String fileId) {
        String cacheKey = getCacheKey(fileId);
        return cacheManager.get(cacheKey);
    }

    public void saveResultToCache(AiReceiptResultVO receiptResultVO) {
        cacheManager.set(getCacheKey(receiptResultVO.getFileId()), receiptResultVO);
    }

    private String getCacheKey(String tenantId) {
        return CACHE_PREFIX + tenantId;
    }


    public void identifyMaterial(AiReceiptResultVO resultVO, String appId, String secretKey) {
        logger.info(JSONObject.toJSONString(resultVO, SerializerFeature.PrettyFormat));
        try {
            List<AiReceiptVO> receiptVOS = resultVO.getReceiptVOS();
            ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
            Map<String, Future<String>> futureMap = new HashMap<>();
            String tenantid = InvocationInfoProxy.getTenantid().toString();
            for (AiReceiptVO aiReceiptVO : receiptVOS) {
                if (!futureMap.containsKey(aiReceiptVO.getKey())) {
                    Future<String> future = threadPoolUtils.runTask(() -> {
                        StringBuilder content = new StringBuilder();
                        // 查找知识库中租户ID：999999 物料名称：卡板加气砖 规格型号：19600*200*190 计量单位：块，结果以JSONArray数组格式给出，查询不到返回空数据，以便可以直接使用JSONArray.parseArray()方法解析结果，不要附加其他分析性语句。
                        content.append("在知识库查找租户ID：").append(tenantid).append(" 物料名称：").append(aiReceiptVO.getName().trim());
                        if (StringUtils.isNotBlank(aiReceiptVO.getSpec())) {
                            content.append(" 规格型号：").append(aiReceiptVO.getSpec().trim());
                        }
                        if (StringUtils.isNotBlank(aiReceiptVO.getUnitName())) {
                            content.append(" 计量单位：").append(aiReceiptVO.getUnitName().trim());
                        }
                        content.append("，查询结果包括租户ID、物料分类ID、物料分类、物料ID、物料名称、规格型号、计量单位，结果以JSONArray数组格式给出，查询不到返回空数据，以便可以直接使用JSONArray.parseArray()方法解析结果，不要附加其他分析性语句。");
                        logger.info(content.toString());
                        return QianfanUtils.postChatMsg(content.toString(), appId, secretKey);
                    });
                    futureMap.put(aiReceiptVO.getKey(), future);
                }
            }
            Map<String, AiReceiptVO> aiMaterialMap = new HashMap<>();
            List<Long> materialIds = new ArrayList<>();
            for (String key : futureMap.keySet()) {
                Future<String> future = futureMap.get(key);
                try {
                    String result = future.get();
                    JSONObject qFanContent = JSON.parseObject(result);
                    String answer = qFanContent.getString("answer");
                    logger.info("请求 id={},返回answer={}", key, answer);
                    if (StringUtils.isNotBlank(answer)) {
                        if (answer.contains("```json") && !answer.contains("[]") && !answer.contains("{}")) {
                            answer = answer.split("```json")[1];
                            answer = answer.split("```")[0];
                            JSONObject jsonObject = null;
                            if (answer.contains("[")) {
                                List<JSONObject> jsonObjects = JSONArray.parseArray(answer, JSONObject.class);
                                if (CollectionUtils.isEmpty(jsonObjects)) {
                                    continue;
                                }
                                jsonObject = jsonObjects.get(0);
                            } else {
                                jsonObject = JSON.parseObject(answer);
                            }
                            if (jsonObject == null || !jsonObject.containsKey("物料ID") || StringUtils.isBlank(jsonObject.getString("物料ID")) || jsonObject.getString("物料ID").contains("未知")) {
                                continue;
                            }
                            Long materialId = null;
                            try {
                                materialId = Long.valueOf(jsonObject.getString("物料ID"));
                                if (materialId != null) {
                                    materialIds.add(materialId);
                                    AiReceiptVO aiMaterialVO = new AiReceiptVO();
                                 /*   aiMaterialVO.setCategoryId(jsonObject.getLong("物料分类ID"));
                                    aiMaterialVO.setCategoryName(jsonObject.getString("物料分类"));*/
                                    aiMaterialVO.setId(materialId);
                                    //aiMaterialVO.setCode(jsonObject.getString("物料编码"));
                                    aiMaterialVO.setName(jsonObject.getString("物料名称"));
                                    aiMaterialVO.setSpec(jsonObject.getString("规格型号"));
                                    aiMaterialVO.setUnitName(jsonObject.getString("计量单位"));
                                    //aiMaterialVO.setTenantId(jsonObject.containsKey("租户ID") ? jsonObject.getLong("租户ID") : null);
                                    aiMaterialMap.put(key, aiMaterialVO);
                                }
                            } catch (NumberFormatException e) {

                            }

                        }
                    }

                } catch (InterruptedException e) {
                    e.printStackTrace();
                } catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            Map<Long, MaterialVO> materialVOMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(materialIds)) {
                CommonResponse<List<MaterialVO>> materialByIds = materialApi.queryMaterialByIds(materialIds);
                if (materialByIds.isSuccess() && materialByIds.getData() != null) {
                    for (MaterialVO datum : materialByIds.getData()) {
                        materialVOMap.put(datum.getId(), datum);
                    }
                }
            }

            if (!materialVOMap.isEmpty()) {
                for (AiReceiptVO aiReceiptVO : receiptVOS) {
                    AiReceiptVO materialVO = aiMaterialMap.get(aiReceiptVO.getKey());
                    if (materialVO != null && materialVO.getId() != null && materialVOMap.get(materialVO.getId()) != null) {
                        MaterialVO resVO = materialVOMap.get(materialVO.getId());
                        aiReceiptVO.setCategoryId(resVO.getCategoryId());
                        aiReceiptVO.setCategoryName(resVO.getCategoryName());
                        aiReceiptVO.setId(resVO.getId());
                        aiReceiptVO.setCode(resVO.getCode());
                        aiReceiptVO.setName(resVO.getName());
                        aiReceiptVO.setSpec(resVO.getSpec());
                        aiReceiptVO.setUnitName(resVO.getUnitName());
                        aiReceiptVO.setTenantId(resVO.getTenantId());
                    } else {
                        aiReceiptVO.setId(null);
                    }
                }
            }
            resultVO.setCode(2);
            resultVO.setMsg("");
            resultVO.setReceiptVOS(receiptVOS);
            this.saveResultToCache(resultVO);
            logger.info("=================匹配物资库结果===========================");
            logger.info(JSONObject.toJSONString(resultVO, SerializerFeature.PrettyFormat));
            logger.info("==============================================");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
