package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.ChatExcelEntity;
import com.ejianc.foundation.ai.bean.MergedResult;
import com.ejianc.foundation.ai.mapper.ChatExcelMapper;
import com.ejianc.foundation.ai.service.IChatExcelService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("chatExcelService")
public class ChatExcelServiceImpl extends BaseServiceImpl<ChatExcelMapper, ChatExcelEntity> implements IChatExcelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ChatExcelMapper chatExcelMapper;

    @Override
    public Map<String, Object> importExcel(String chatExcelId, MultipartFile file) {
        try {
            ChatExcelEntity chatExcelEntity = chatExcelMapper.selectById(chatExcelId);
            if(chatExcelEntity == null) {
                throw new BusinessException("ChatExcelId在数据库不存在!");
            }
            String dataTableName = "chatexcel_data_"+chatExcelEntity.getExcelCode();
            dropChatExcelTable(dataTableName);

            String createTableSql = "CREATE TABLE `"+dataTableName+"` ( `id` bigint(20) NOT NULL COMMENT '主键ID', ";
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            Sheet sheetAt = xssfWorkbook.getSheetAt(0);
            Map<String, Object> resultMap = new IdentityHashMap<String, Object>();
            Map<String, Object> styleMap = new IdentityHashMap<String, Object>();
            Map<String, Object> rowMap = new IdentityHashMap<String, Object>();
            int index = 0;
            Iterator<Row> rows = sheetAt.iterator();
            boolean isTableHeader = true;
            boolean isInitColumnList = false;
            List<String> headerColumn = new ArrayList<>();
            List<List<String>> allDataList = new ArrayList<>();
            int rowCellCount = 0;
            int tableHeaderRowCount = 0;
            while (rows.hasNext()) {
                Row row = rows.next();
                int rowNumber = row.getRowNum();
                if(rowNumber > 0) {
                    isTableHeader = false;
                }
                List<String> columnDataList = new ArrayList<>();
                Map<String, Object> cellsMap = new IdentityHashMap<>();
                Map<String, Object> columnMap = new IdentityHashMap<>();

                int cellIndex = 0;
                for(Iterator<Cell> cellIterator = row.iterator(); cellIterator.hasNext(); resultMap.put("styles", styleMap)) {
                    Cell cell = cellIterator.next();
                    Map<String, Object> cellMap = new IdentityHashMap<>();
                    int columnIndex;
                    MergedResult mergedResult = null;
                    int[] merges;
                    Map<String, Object> mergeCell;
                    if(cell.getCellType() != CellType.BLANK) {
                        switch (cell.getCellType()) {
                            case STRING:
                                String cellValue = cell.getRichStringCellValue().toString();
                                cellMap.put("text", cellValue);
                                if(StringUtils.isNotBlank(cellValue)) {
                                    cellValue = cellValue.replace("(", "（");
                                    cellValue = cellValue.replace(")", "）");
                                    cellValue = cellValue.replace("'", "");
                                    cellValue = cellValue.replace("\"", "");
                                    cellValue = cellValue.replace(",", "，");
                                    cellValue = cellValue.replace(";", "；");
                                    cellValue = cellValue.replace("\\", "");
                                    if(cellValue.length() > 250) {
                                        columnDataList.add(cellValue.substring(0,250));
                                    }else{
                                        columnDataList.add(cellValue);
                                    }
                                }else{
                                    columnDataList.add("");
                                }

                                break;
                            case NUMERIC:
                                if (DateUtil.isCellDateFormatted(cell)) {
                                    DataFormatter formatter = new DataFormatter();
                                    String formattedDate = formatter.formatCellValue(cell);
                                    if(formattedDate.contains(":")) {
                                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        String numCellValue = simpleDateFormat.format(DateUtil.getJavaDate(cell.getNumericCellValue()));
                                        cellMap.put("text",numCellValue);
                                        columnDataList.add(numCellValue);
                                    }else{
                                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                        String numCellValue = simpleDateFormat.format(DateUtil.getJavaDate(cell.getNumericCellValue()));
                                        cellMap.put("text",numCellValue);
                                        columnDataList.add(numCellValue);
                                    }
                                } else {
                                    BigDecimal bigDecimal = BigDecimal.valueOf(cell.getNumericCellValue());
                                    cellMap.put("text", bigDecimal.toString());
                                    columnDataList.add(bigDecimal.toString());
                                }
                                break;
                            case BOOLEAN:
                                cellMap.put("text", cell.getBooleanCellValue());
                                columnDataList.add(cell.getBooleanCellValue()+"");
                                break;
                            default:
                                columnDataList.add("");
                                break;
                        }
                        columnIndex = cell.getColumnIndex();
                        mergedResult = toMergedResult(sheetAt, rowNumber, columnIndex);
                        if(mergedResult.isMerged()) {
                            merges = new int[] { mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol() };
                            cellMap.put("merge", merges);
                        }

                        mergeCell = parseCell(cell, mergedResult.isMerged());
                        ++index;
                        styleMap.put(Integer.valueOf(index).toString(), mergeCell);
                        cellMap.put("style", Integer.valueOf(index));
                        columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                    }else{
                        columnDataList.add("");
                        columnIndex = cell.getColumnIndex();
                        mergedResult = toMergedResult(sheetAt, rowNumber, columnIndex);
                        if (mergedResult.isMerged()) {
                            isTableHeader = true;
                            merges = new int[] { mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol() };
                            cellMap.put("merge", merges);
                        }

                        if (!mergedResult.isMerged()) {
                            mergeCell = parseCell(cell, mergedResult.isMerged());
                            ++index;
                            styleMap.put(Integer.valueOf(index).toString(), mergeCell);
                            cellMap.put("style", Integer.valueOf(index));
                            columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                        }
                    }

                    if(!isTableHeader) {
                        cellIndex = cellIndex + 1;
                    }
                    if(!isTableHeader && cellIndex >= rowCellCount) {
                        cellIndex = 0;
                        break;
                    }

                }

                cellsMap.put("cells", columnMap);
                cellsMap.put("height", Float.valueOf(row.getHeightInPoints())>30?Float.valueOf(row.getHeightInPoints()):30);
                rowMap.put(Integer.valueOf(rowNumber).toString(), cellsMap);
                resultMap.put("rows", rowMap);

                if(isTableHeader) {
                    tableHeaderRowCount = tableHeaderRowCount + 1;
                    if(!columnDataList.isEmpty()) {
                        rowCellCount = columnDataList.size();
                        for(int i=0;i<columnDataList.size();i++) {
                            if(!isInitColumnList) {
                                headerColumn.add(columnDataList.get(i));
                            }else{
                                if(StringUtils.isNotBlank(columnDataList.get(i))) {
                                    headerColumn.set(i, columnDataList.get(i));
                                }
                            }
                        }
                    }
                    if(!isInitColumnList) {
                        isInitColumnList = true;
                    }
                }else{
                    allDataList.add(columnDataList);
                }
            }

            if(!headerColumn.isEmpty()) {
                for(int i=0;i<headerColumn.size();i++) {
                    if(i ==(headerColumn.size() -1)) {
                        createTableSql += " `"+headerColumn.get(i)+"` VARCHAR(255) DEFAULT NULL COMMENT '"+headerColumn.get(i)+"' , PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='"+chatExcelEntity.getExcelName()+"' ";
                    }else{
                        createTableSql += " `"+headerColumn.get(i)+"` VARCHAR(255) DEFAULT NULL COMMENT '"+headerColumn.get(i)+"', ";
                    }
                }
            }
            chatExcelMapper.executeSql(createTableSql);

            if(!allDataList.isEmpty()) {
                int batchSize = 100;
                for(int i=0; i < allDataList.size(); i+=batchSize) {
                    List<List<String>> subList = allDataList.subList(i, Math.min(i + batchSize, allDataList.size()));
                    String insertSql = "INSERT INTO `"+dataTableName+"` VALUES ";
                    for(int j=0;j<subList.size();j++) {
                        if(subList.get(j).size() < rowCellCount) {
                            continue;
                        }
                        insertSql += "("+IdWorker.getId()+",'"+StringUtils.join(subList.get(j),"','")+"'),";
                    }
                    insertSql = insertSql.substring(0,insertSql.lastIndexOf(","));
                    chatExcelMapper.executeSql(insertSql);
                }
            }

            JSONObject jsonObject = new JSONObject(resultMap);

            JSONObject styles = jsonObject.getJSONObject("styles");
            List<String> sortedKeys = new ArrayList<>(styles.keySet());
            sortedKeys.sort(Comparator.comparingInt(Integer::parseInt));
            JSONArray jsonArray = new JSONArray();

            JSONObject firstObj = new JSONObject();
            jsonArray.add(firstObj);
            for (String key : sortedKeys) {
                jsonArray.add(styles.getJSONObject(key));
            }
            jsonObject.put("styles", jsonArray);

            String contentJson = jsonObject.toString();
            chatExcelEntity.setContentJson(contentJson);
            chatExcelEntity.setCreateTableSql(createTableSql);
            chatExcelEntity.setTableHeaderRowCount(tableHeaderRowCount);
            chatExcelMapper.updateById(chatExcelEntity);

            return resultMap;
        }catch (Exception e) {
            logger.error("excel导入失败！Msg:"+e.getMessage());
        }
        return null;
    }

    @Override
    public void dropChatExcelTable(String dataTableName) {
        chatExcelMapper.dropChatExcelTable(dataTableName);
    }

    @Override
    public void executeSql(String executeSql) {
        chatExcelMapper.executeSql(executeSql);
    }

    @Override
    public List<String> getColumnList(String dataTableName) {
        List<String> columnList = chatExcelMapper.getColumnList(dataTableName);
        return columnList;
    }

    private MergedResult toMergedResult(Sheet sheet, int rowNum, int columnIndex) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int firstColumn = cellRangeAddress.getFirstColumn();
            int lastColumn = cellRangeAddress.getLastColumn();
            int firstRow = cellRangeAddress.getFirstRow();
            int lastRow = cellRangeAddress.getLastRow();
            if (rowNum >= firstRow && rowNum <= lastRow && columnIndex >= firstColumn && columnIndex <= lastColumn) {
                return new MergedResult(true, firstRow, lastRow, firstColumn, lastColumn);
            }
        }
        return new MergedResult(false, 0, 0, 0, 0);
    }

    private Map<String, Object> parseCell(Cell cell, boolean isMerged) {
        CellStyle cellStyle = cell.getCellStyle();
        Map<String, Object> resultMap = new HashMap<>();
        Map<String, Object> borderMap = new HashMap<>();
        Map<String, Object> fontMap = new HashMap<>();
        if (((XSSFCell) cell).getCellStyle().getFont().getBold()) {
            fontMap.put("bold", Boolean.valueOf(true));
        }

        fontMap.put("size", Short.valueOf(((XSSFCell) cell).getCellStyle().getFont().getFontHeightInPoints()));
        String[] thins = new String[] { "thin", "#000" };
        if (cellStyle.getBorderBottom() == BorderStyle.THIN) {
            borderMap.put("bottom", thins);
        }

        if (cellStyle.getBorderBottom() == BorderStyle.THIN) {
            borderMap.put("left", thins);
        }

        if (cellStyle.getBorderBottom() == BorderStyle.THIN) {
            borderMap.put("right", thins);
        }

        if (cellStyle.getBorderBottom() == BorderStyle.THIN) {
            borderMap.put("top", thins);
        }

        if (cellStyle.getAlignment() == HorizontalAlignment.CENTER) {
            resultMap.put("align", "center");
        }

        if (cellStyle.getBorderBottom() == BorderStyle.THIN && cellStyle.getBorderLeft() == BorderStyle.THIN && cellStyle.getBorderTop() == BorderStyle.THIN && isMerged) {
            borderMap.put("right", thins);
        }

        if (cellStyle.getBorderRight() != BorderStyle.NONE || cellStyle.getBorderBottom() != BorderStyle.NONE
                || cellStyle.getBorderLeft() != BorderStyle.NONE
                || cellStyle.getBorderTop() != BorderStyle.NONE) {
            resultMap.put("border", borderMap);
        }

        XSSFFont xssfFont = ((XSSFCell) cell).getCellStyle().getFont();
        if (xssfFont.getXSSFColor() != null) {
            XSSFColor xssfColor = xssfFont.getXSSFColor();
            byte[] rgbs = xssfColor.getRGB();
            if (rgbs.length > 3) {
                String arg11 = String.format("#%02X%02X%02X", new Object[] { Byte.valueOf(rgbs[0]), Byte.valueOf(rgbs[1]), Byte.valueOf(rgbs[2]) });
                resultMap.put("color", arg11);
            }
        }

        if (((XSSFCell) cell).getCellStyle().getFillPattern() == FillPatternType.SOLID_FOREGROUND) {
            byte[] arg12 = ((XSSFCell) cell).getCellStyle().getFillForegroundColorColor().getRGB();
            String arg13 = String.format("#%02X%02X%02X", new Object[] { Byte.valueOf(arg12[0]), Byte.valueOf(arg12[1]), Byte.valueOf(arg12[2]) });
            resultMap.put("bgcolor", arg13);
        }

        resultMap.put("font", fontMap);
        return resultMap;
    }
}
