package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.ExtDictRelationEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.ExtDictRelationMapper;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * AI扩展字段关联关系表
 *
 * @author generator
 *
 */
@Service("extDictRelationService")
public class ExtDictRelationServiceImpl extends BaseServiceImpl<ExtDictRelationMapper, ExtDictRelationEntity> implements IExtDictRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeEmbeddingPointsService pointsService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public List<ExtDictRelationVO> queryListByEmbeddingIds(List<Long> embeddingIds){
        QueryWrapper<ExtDictRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.in("embedding_id", embeddingIds);
        List<ExtDictRelationEntity> list = this.list(wrapper);
        List<ExtDictRelationVO> result = new ArrayList<>();
        if(list!=null && list.size()>0){
            for(ExtDictRelationEntity entity : list){
                ExtDictRelationVO vo = BeanMapper.map(entity, ExtDictRelationVO.class);
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public void saveList(List<ExtDictRelationVO> list) {

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByEmbeddingId(list.get(0).getEmbeddingId());
        String indexName = knowledgeBase.getCode();

        KnowledgeEmbeddingPointsEntity initPointData = pointsService.getFirstInitData(list.get(0).getEmbeddingId());

        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

        for (ExtDictRelationVO extDictRelationVO : list) {
            KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
            //直接生成对应带有标签的切片信息
            Long id = IdWorker.getId();
            extDictRelationVO.setId(id);
            point.setId(id);
            point.setType(4);
            point.setEmbeddingId(extDictRelationVO.getEmbeddingId());
            //获取数据
            String content = extDictRelationVO.getField();
            point.setContent(content);
            point.setInitContent(content);
            String redisId = ("tag-"+initPointData.getId()+"-"+id);
            //执行文件切分
            JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, content, embeddingModel, embeddingStore);

            Embedding embedding = (Embedding) json.get("embedding");
            String redisIdr = (String) json.get("redisId");
            point.setUuid(indexName+":"+redisIdr);
            point.setVector(Arrays.toString(embedding.vector()));
            pointsService.saveOrUpdate(point, false);
        }

        //2、
        List<ExtDictRelationEntity> entitys = BeanMapper.mapList(list, ExtDictRelationEntity.class);
        this.saveOrUpdateBatch(entitys, entitys.size(), false);

    }

    @Override
    public void delete(List<Long> ids) {
        ExtDictRelationEntity entity = this.selectById(ids.get(0));
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByEmbeddingId(entity.getEmbeddingId());

        this.removeByIds(ids);
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapperEmbeddingPoints = new QueryWrapper<>();
        String indexName = knowledgeBase.getCode();
        //// 删除向量数据库中的信息
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        List<String> rids = new ArrayList<>();
        for (Long id : ids){
            rids.add(indexName+":"+("tag-"+id));
        }
        wrapperEmbeddingPoints.in("uuid", rids);
        pointsService.remove(wrapperEmbeddingPoints);//删除数据库中的向量信息

        embeddingStore.removeAll(rids);//删除redis中的向量信息
    }
}
