package com.ejianc.foundation.ai.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.ExtDictEntity;
import com.ejianc.foundation.ai.mapper.ExtDictMapper;
import com.ejianc.foundation.ai.service.IExtDictService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * AI扩展字段
 *
 * @author generator
 *
 */
@Service("extDictService")
public class ExtDictServiceImpl extends BaseServiceImpl<ExtDictMapper, ExtDictEntity> implements IExtDictService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<String> getFields(String knowledgeBaseCode){
        List<String> list = new ArrayList<>();
        QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
        if(knowledgeBaseCode!=null){
            wrapper.eq("knowledge_base_code", knowledgeBaseCode);
        }
        List<ExtDictEntity> result = this.list(wrapper);
        if(result!=null && result.size()>0){
            result.forEach(item -> {
                list.add(item.getField());
            });
        }
        return list;
    }
}
