package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeBaseMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.wltea.analyzer.lucene.IKAnalyzer;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * AI知识库
 * 
 * @author generator
 * 
 */
@Service("knowledgeBaseService")
public class KnowledgeBaseServiceImpl extends BaseServiceImpl<KnowledgeBaseMapper, KnowledgeBaseEntity> implements IKnowledgeBaseService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;

    @Override
    public KnowledgeBaseEntity queryBaseDataByItemId(Long embeddingId){
        return knowledgeBaseMapper.queryBaseDataByItemId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByEmbeddingId(Long embeddingId){
        return knowledgeBaseMapper.queryBaseDataByEmbeddingId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByPointsId(Long embeddingId) {
        return knowledgeBaseMapper.queryBaseDataByPointsId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByTableIndexId(Long embeddingId) {
        return knowledgeBaseMapper.queryBaseDataByTableIndexId(embeddingId);
    }

    @Override
    public CommonResponse<JSONArray> hitTest(Long baseId, String text) {
        if(StringUtils.isBlank(text)){
            throw new BusinessException("缺少命中测试数据");
        }
        KnowledgeBaseEntity entity = this.selectById(baseId);
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(entity.getCode());
        Embedding queryEmbedding = embeddingModel.embed(text).content();
        //// 创建一个内存中的嵌入存储
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(entity.getCode());
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(entity.getRetrieveMinScore().doubleValue()).maxResults(entity.getRetrieveMaxResults()).build();
        EmbeddingSearchResult<TextSegment> embeddedEmbeddingSearchResult = embeddingStore.search(embeddingSearchRequest);
        List<EmbeddingMatch<TextSegment>> embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
        JSONArray result = new JSONArray();
        if(embeddingMatcheList.size() > 0) {
            Map<Long, KnowledgeEmbeddingEntity> embeddingMap = new HashMap<>();
            Map<Long, KnowledgeItemEntity> itemMap = new HashMap<>();

            List<String> words = new ArrayList<>();
            TokenStream tokenStream = null;
            try {
                Analyzer analyzer = new IKAnalyzer(true);
                tokenStream = analyzer.tokenStream("content", new StringReader(text));
                tokenStream.reset();
                CharTermAttribute termAttr = tokenStream.getAttribute(CharTermAttribute.class);
                logger.info("分词内容：{}",text);
                logger.info("分词结果：");
                while (tokenStream.incrementToken()) {
                    logger.info(termAttr.toString());
                    words.add(termAttr.toString());
                }
            } catch (IOException e) {} finally {
                if(tokenStream != null) {
                    try {
                        tokenStream.close();
                    }catch(Exception e) {}
                }
            }

            Map<Long, Long> pointsMap = new HashMap<>();
            for(EmbeddingMatch<TextSegment> embeddingMatch : embeddingMatcheList) {
                TextSegment textSegment = embeddingMatch.embedded();
                logger.info("words:{}------------textSegment:{}",words,textSegment);
                for(String word : words) {
                    if(textSegment.text().contains(word)) {
                        JSONObject json = new JSONObject();
                        BigDecimal matchScore = new BigDecimal(embeddingMatch.score());
                        matchScore = matchScore.setScale(3, RoundingMode.HALF_UP);
                        json.put("matchScore", matchScore);
                        QueryWrapper<KnowledgeEmbeddingPointsEntity> pointsWrapper = new QueryWrapper<>();
                        if(embeddingMatch.embeddingId()!=null && embeddingMatch.embeddingId().contains("tag")){
                            String pointId = embeddingMatch.embeddingId().split("-")[1];
                            pointsWrapper.like("id", pointId);
                        }else{
                            pointsWrapper.like("uuid", embeddingMatch.embeddingId());
                        }
                        List<KnowledgeEmbeddingPointsEntity> pointsList = knowledgeEmbeddingPointsService.list(pointsWrapper);
                        if(pointsList!=null && pointsList.size()>0){
                            KnowledgeEmbeddingPointsEntity pointEntity = pointsList.get(0);
                            if(pointsMap.containsKey(pointEntity.getId())) {
                                continue;
                            }
                            json.put("embeddingId", pointEntity.getEmbeddingId());
                            json.put("embeddingPointsContent", pointEntity.getContent());
                            KnowledgeEmbeddingEntity embedding = null;
                            if(embeddingMap.get(pointEntity.getEmbeddingId())!=null){
                                embedding = embeddingMap.get(pointEntity);
                            }else{
                                embedding = knowledgeEmbeddingService.selectById(pointEntity.getEmbeddingId());
                                embeddingMap.put(pointEntity.getEmbeddingId(), embedding);
                            }
                            json.put("type", embedding.getType());
                            json.put("sequence", embedding.getSequence());

                            KnowledgeItemEntity item = null;
                            if(itemMap.get(embedding.getItemId())!=null){
                                item = itemMap.get(embedding.getItemId());
                            }else{
                                item = knowledgeItemService.selectById(embedding.getItemId());
                            }
                            json.put("fileName", item.getFileName());
                            pointsMap.put(pointEntity.getId(), pointEntity.getId());
                        }
                        result.add(json);
                        break;
                    }
                }
            }
        }
        return CommonResponse.success(result);
    }

}
