package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.ExtDictRelationVO;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * 知识切片表（向量）
 * 
 * @author generator
 * 
 */
@Service("knowledgeEmbeddingService")
public class KnowledgeEmbeddingServiceImpl extends BaseServiceImpl<KnowledgeEmbeddingMapper, KnowledgeEmbeddingEntity> implements IKnowledgeEmbeddingService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private KnowledgeEmbeddingMapper embeddingMapper;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private IExtDictService extDictService;
    @Autowired
    private IExtDictRelationService extDictRelationService;

    @Override
    public KnowledgeEmbeddingVO saveData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingEntity.class);

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();

        Long pointId = null;
        if(entity.getId() == null || entity.getId() == 0){
            //新增，新增向量+切片
            entity.setType(2);
            entity.setSliceState(1);
            entity.setInitContent(entity.getContent());
            Integer maxSequence = embeddingMapper.selectMaxSequence(saveOrUpdateVO.getItemId());
            entity.setSequence(maxSequence+1);
            pointId = this.generateStore(indexName, entity);
        }else{
            if(entity.getType()==1){
                entity.setType(3);
            }
            entity.setContent(saveOrUpdateVO.getContent());
            //获取自动切片的知识点，并且修改一下向量数据信息
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", saveOrUpdateVO.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                KnowledgeEmbeddingPointsEntity en = list.get(0);
                pointId = en.getId();
                EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                //// 删除向量数据库中的信息
                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.remove(en.getUuid());

                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), embeddingModel, embeddingStore);

                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");

                entity.setUuid(indexName+":"+redisId);
                entity.setInitContent(saveOrUpdateVO.getContent());

                en.setUuid(indexName+":"+redisId);
                en.setContent(saveOrUpdateVO.getContent());
                en.setVector(Arrays.toString(embedding.vector()));

                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else{
                this.generateStore(indexName, entity);
            }
        }
        this.saveOrUpdate(entity, false);

        //自动标注标签
        this.checkTextTag(entity, pointId);

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }

    private Long generateStore(String indexName, KnowledgeEmbeddingEntity entity){
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

        //执行文件切分
        JSONObject json = documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);

        Embedding embedding = (Embedding) json.get("embedding");
        String redisId = (String) json.get("redisId");

        entity.setId(IdWorker.getId());
        entity.setUuid(indexName+":"+redisId);
        if(entity.getType()==null){
            entity.setType(2);
        }

        KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
        en.setEmbeddingId(entity.getId());
        en.setUuid(indexName+":"+redisId);
        en.setContent(entity.getContent());
        en.setInitContent(entity.getContent());
        en.setVector(Arrays.toString(embedding.vector()));
        en.setSequence(1);
        en.setType(1);
        knowledgeEmbeddingPointsService.saveOrUpdate(en, false);

        return en.getId();
    }

    @Override
    public void delData(Long id) {
        KnowledgeEmbeddingEntity entity = this.selectById(id);
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByEmbeddingId(id);
        String indexName = knowledgeBase.getCode();
        //查询知识点并删除redis中的信息
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", id);
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            List<String> rids = new ArrayList<>();
            list.forEach(item -> {
                rids.add(item.getUuid());
            });
            //// 删除向量数据库中的信息
            EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
            EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
            embeddingStore.removeAll(rids);
            knowledgeEmbeddingPointsService.remove(wrapper);
        }
        this.removeById(id);

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        //删除标签信息
        QueryWrapper<ExtDictRelationEntity> reWrapper = new QueryWrapper<>();
        reWrapper.eq("embedding_id", id);
        extDictRelationService.remove(reWrapper);
    }

    @Override
    public KnowledgeEmbeddingVO saveTableData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        String tableContent = saveOrUpdateVO.getTableContent();

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();

        QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
        tableWrapper.eq("item_id", saveOrUpdateVO.getItemId());
        List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
        String indexs = null;
        String titles = null;
        if(indexList!=null && indexList.size()>0){
            indexs = indexList.get(0).getIndexs();
            titles = indexList.get(0).getTitles();
        }else{
            throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
        }
        if(StringUtils.isBlank(indexs)){
            throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
        }
        if(StringUtils.isBlank(titles)){
            throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
        }
        //表格型知识库
        String[] titlesArray = titles.split(",");
        String[] indexsArray = indexs.split(",");
        JSONObject ob = JSONObject.parseObject(tableContent);
        String o = "";
        for(int j=0; j<titlesArray.length; j++){
            o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
        }
        if(saveOrUpdateVO.getId()==null){
            saveOrUpdateVO.setSliceState(1);
            saveOrUpdateVO.setContent(o);
            saveOrUpdateVO.setInitContent(tableContent);

            Integer maxSequence = embeddingMapper.selectMaxSequence(saveOrUpdateVO.getItemId());
            saveOrUpdateVO.setSequence(maxSequence+1);
        }

        KnowledgeEmbeddingEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingEntity.class);
        this.saveOrUpdate(entity, false);
        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", saveOrUpdateVO.getId());
        wrapper.in("type", 1,3,4);//清除自动配置的，内置标签（标签的redis需要和主表信息的id进行绑定，故需要重新生成）的向量数据
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        if(list!=null && list.size()>0){
            List<String> delredisIds = new ArrayList<>();
            list.forEach(e -> {
                delredisIds.add(e.getUuid());
            });
            embeddingStore.removeAll(delredisIds);
            knowledgeEmbeddingPointsService.remove(wrapper);
        }
        Long pointId = null;
        List allRedisIds = new ArrayList();
        try {
            List<TextSegment> documents = new ArrayList<>();
            List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();


            TextSegment s = TextSegment.from(o);
            documents.add(s);//全部表格内容信息

            for(int j=0; j<indexsArray.length; j++){
                String index = indexsArray[j];
                documents.add(TextSegment.from(index+": "+ob.getString(index)));
            }

            //执行文件切分
            JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);

            List embeddings = (List) json.get("embeddings");
            allRedisIds = (List) json.get("redisIds");
            for(int j=0; j<documents.size(); j++){
                TextSegment segment = documents.get(j);
                Embedding embedding = (Embedding) embeddings.get(j);
                String id = (String) allRedisIds.get(j);

                KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                if(s.equals(segment)){
                    Long idd = IdWorker.getId();
                    pointId = idd;
                    p.setId(pointId);
                }
                p.setEmbeddingId(entity.getId());
                p.setUuid(indexName+":"+id);
                p.setContent(segment.text());
                p.setInitContent(segment.text());
                p.setVector(Arrays.toString(embedding.vector()));
                p.setType(1);
                p.setSequence(documents.size()-j);
                listPoints.add(p);
            }

            if(listPoints!=null && listPoints.size()>0){
                knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
            }
        }catch (Exception e){
            //删除生成的向量数据库信息
            embeddingStore.removeAll(allRedisIds);
            throw new BusinessException("生成向量数据库信息失败");
        }

        //自动匹配标签信息并存储
        this.checkTableTag(entity,pointId);

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO enableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = this.selectById(data.getId());
        entity.setSliceState(1);
        this.saveOrUpdate(entity, false);
        //保存向量信息
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", data.getId());
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
            EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
            for(KnowledgeEmbeddingPointsEntity pEntity : list){
                if(pEntity.getType() == 4){
                    String redisId = pEntity.getUuid().split(":")[1];
                    //标签向量，id自动生成
                    JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, pEntity.getContent(), embeddingModel, embeddingStore);
                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisIdd = (String) json.get("redisId");
                    pEntity.setUuid(indexName+":"+redisIdd);
                    pEntity.setVector(Arrays.toString(embedding.vector()));
                }else{
                    JSONObject json = documentSplitUtil.documentStoreSingle(pEntity.getContent(), embeddingModel, embeddingStore);
                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisId = (String) json.get("redisId");
                    pEntity.setUuid(indexName+":"+redisId);
                    pEntity.setVector(Arrays.toString(embedding.vector()));
                }
            }
            if(list!=null && list.size()>0){
                knowledgeEmbeddingPointsService.saveOrUpdateBatch(list, list.size(), false);
            }
        }

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO disableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = this.selectById(data);
        entity.setSliceState(0);
        this.saveOrUpdate(entity, false);
        //保存向量信息
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", data.getId());
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
            EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
            List<String> delredisIds = new ArrayList<>();
            list.forEach(e -> {
                delredisIds.add(e.getUuid());
            });
            embeddingStore.removeAll(delredisIds);
        }

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);
        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO restoreData(KnowledgeEmbeddingVO data) {
        data.setType(1);
        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(data.getItemId());
        if(itemEntity.getKnowledgeType()==1){
            KnowledgeEmbeddingEntity entity = this.selectById(data.getId());

            KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
            String indexName = knowledgeBase.getCode();
            //文本
            entity.setContent(entity.getInitContent());

            entity.setType(1);
            //获取自动切片的知识点，并且修改一下向量数据信息
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", entity.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            Long pointId = null;
            if(list!=null && list.size()>0){
                KnowledgeEmbeddingPointsEntity en = list.get(0);
                pointId = en.getId();
                EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                //// 删除向量数据库中的信息
                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.remove(en.getUuid());

                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);

                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");

                entity.setUuid(indexName+":"+redisId);

                en.setUuid(indexName+":"+redisId);
                en.setContent(entity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));

                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else{
                pointId = this.generateStore(indexName, entity);
            }
            QueryWrapper<KnowledgeEmbeddingPointsEntity> delwrapper = new QueryWrapper<>();
            delwrapper.eq("embedding_id", entity.getId());
            delwrapper.eq("type", 2);

            this.saveOrUpdate(entity, false);

            //清理所有标签，并自动生成匹配的标签数据
            this.checkRestoreTag(entity, pointId);

            Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
            itemEntity.setEmbeddingCount(embeddingCount);
            knowledgeItemService.saveOrUpdate(itemEntity, false);

            KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
            return vo;
        }else{
            //表格
            return this.saveTableData(data);
        }
    }

    //自动打标签--文本
    private void checkTextTag(KnowledgeEmbeddingEntity entity, Long pointId){
        //1、获取当前自动匹配的标签数据
        QueryWrapper<ExtDictRelationEntity> reWrapper = new QueryWrapper<>();
        reWrapper.eq("embedding_id", entity.getId());
        reWrapper.eq("type", 1);
        List<ExtDictRelationEntity> sysRelationList = extDictRelationService.list(reWrapper);
        logger.info("embedding_id:{},sysRelationList:{}", entity.getId(),sysRelationList.size());

        //2、遍历，判断该数据是否在新的内容里面，
        //2.1、存在，不动该标签
        //2.3、不存在，删除标签（获取对应的标签向量数据信息，删除）
        List<String> exitFieldList = new ArrayList<>();
        List<Long> delRelIds = new ArrayList<>();
        if(sysRelationList!=null && sysRelationList.size()>0){
            sysRelationList.forEach(item -> {
                logger.info("Content:{}", entity.getContent());
                logger.info("Field:{}", item.getField());
                if(!entity.getContent().contains(item.getField())){
                    delRelIds.add(item.getId());
                }else{
                    exitFieldList.add(item.getField());
                }
            });
        }

        //3、获取该知识库的标签信息

        //4、遍历标签信息，
        //4.1、根据内容判断标签是否存在，若标签已生成（存在），忽略--该标签在查询出来的关系中
        //4.2、标签未生成，自动生成

        //获取该知识库标签
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(entity.getItemId());
        QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("knowledge_base_id", knowledgeBase.getId());
        List<ExtDictEntity> result = extDictService.list(wrapper);

        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

        //2.3、删除不存在的关系数据及向量信息
        if(delRelIds!=null && delRelIds.size()>0){
            extDictRelationService.removeByIds(delRelIds);
            //获取要删除的向量信息，并删除redis信息
            Collection<KnowledgeEmbeddingPointsEntity> entitys = knowledgeEmbeddingPointsService.listByIds(delRelIds);
            //// 删除向量数据库中的信息
            List<String> rids = new ArrayList<>();
            for (KnowledgeEmbeddingPointsEntity en : entitys){
                rids.add(en.getUuid());
            }
            embeddingStore.removeAll(rids);//删除redis中的向量信息
        }
        if(result!=null && result.size()>0){
            List<ExtDictRelationEntity> relationList = new ArrayList<>();
            for (ExtDictEntity extDictEntity : result) {
                if(entity.getContent().contains(extDictEntity.getField()) && !(exitFieldList!=null && exitFieldList.contains(extDictEntity.getId()))){
                    Long id = IdWorker.getId();
                    ExtDictRelationEntity re = new ExtDictRelationEntity();
                    re.setId(id);
                    re.setType(1);
                    re.setExtDictId(extDictEntity.getId());
                    re.setEmbeddingId(entity.getId());
                    re.setField(extDictEntity.getField());

                    KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
                    //直接生成对应带有标签的切片信息
                    point.setId(id);
                    point.setType(4);
                    point.setEmbeddingId(entity.getId());
                    //获取数据
                    point.setContent(extDictEntity.getField());
                    point.setInitContent(extDictEntity.getField());
                    String redisId = ("tag-"+pointId+"-"+id);

                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, extDictEntity.getField(), embeddingModel, embeddingStore);

                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisIds = (String) json.get("redisId");
                    point.setUuid(indexName+":"+redisIds);
                    point.setVector(Arrays.toString(embedding.vector()));
                    knowledgeEmbeddingPointsService.saveOrUpdate(point, false);

                    relationList.add(re);
                }
            }
            if(relationList!=null && relationList.size()>0){
                extDictRelationService.saveOrUpdateBatch(relationList, relationList.size(), false);
            }
        }

    }

    //自动打标签--表格（表格的要重新生成数据）
    private void checkTableTag(KnowledgeEmbeddingEntity entity, Long pointId){
        //1、获取手动新增的标签关系数据--需要重新生成向量信息
        QueryWrapper<ExtDictRelationEntity> addReWrapper = new QueryWrapper<>();
        addReWrapper.eq("embedding_id", entity.getId());
        addReWrapper.eq("type", 2);
        List<ExtDictRelationEntity> addRelationList = extDictRelationService.list(addReWrapper);

        //2、清除当前标签数据-
        QueryWrapper<ExtDictRelationEntity> reWrapper = new QueryWrapper<>();
        reWrapper.eq("embedding_id", entity.getId());
        extDictRelationService.remove(reWrapper);


        //3、获取该知识库的标签信息

        //4、遍历标签信息，
        //4.2、未生成，自动生成标签

        //获取该知识库标签
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(entity.getItemId());
        QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("knowledge_base_id", knowledgeBase.getId());
        List<ExtDictEntity> result = extDictService.list(wrapper);

        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

        List<KnowledgeEmbeddingPointsEntity> points = new ArrayList<>();
        List<ExtDictRelationEntity> relationList = new ArrayList<>();
        if(result!=null && result.size()>0){
            for (ExtDictEntity extDictEntity : result) {
                if(entity.getContent().contains(extDictEntity.getField())){
                    Long id = IdWorker.getId();
                    ExtDictRelationEntity re = new ExtDictRelationEntity();
                    re.setId(id);
                    re.setType(1);
                    re.setExtDictId(extDictEntity.getId());
                    re.setEmbeddingId(entity.getId());
                    re.setField(extDictEntity.getField());

                    KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
                    //直接生成对应带有标签的切片信息
                    point.setId(id);
                    point.setType(4);
                    point.setEmbeddingId(entity.getId());
                    //获取数据
                    point.setContent(extDictEntity.getField());
                    point.setInitContent(extDictEntity.getField());
                    String redisId = ("tag-"+pointId+"-"+id);

                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, extDictEntity.getField(), embeddingModel, embeddingStore);

                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisIds = (String) json.get("redisId");
                    point.setUuid(indexName+":"+redisIds);
                    point.setVector(Arrays.toString(embedding.vector()));
                    points.add(point);

                    relationList.add(re);
                }
            }
        }
        if(addRelationList!=null && addRelationList.size()>0){
            for (ExtDictRelationEntity en : addRelationList) {
                ExtDictRelationEntity add = BeanMapper.map(en, ExtDictRelationEntity.class);
                Long id = IdWorker.getId();
                add.setId(id);
                add.setEmbeddingId(entity.getId());
                relationList.add(add);

                KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
                //直接生成对应带有标签的切片信息
                point.setId(id);
                point.setType(4);
                point.setEmbeddingId(entity.getId());
                //获取数据
                point.setContent(en.getField());
                point.setInitContent(en.getField());
                String redisId = ("tag-"+pointId+"-"+id);
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, en.getField(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisIds = (String) json.get("redisId");
                point.setUuid(indexName+":"+redisIds);
                point.setVector(Arrays.toString(embedding.vector()));
                points.add(point);

            }
        }
        if(points!=null && points.size()>0){
            knowledgeEmbeddingPointsService.saveOrUpdateBatch(points, points.size(), false);
        }
        if(relationList!=null && relationList.size()>0){
            extDictRelationService.saveOrUpdateBatch(relationList, relationList.size(), false);
        }
    }

    //还原数据标签处理
    private void checkRestoreTag(KnowledgeEmbeddingEntity entity, Long pointId){
        //1、删除所有的标签
        QueryWrapper<ExtDictRelationEntity> reWrapper = new QueryWrapper<>();
        reWrapper.eq("embedding_id", entity.getId());
        extDictRelationService.remove(reWrapper);

        //2、自动匹配新的标签
        //3、获取该知识库的标签信息
        //4、遍历标签信息，自动生成标签
        //获取该知识库标签
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(entity.getItemId());
        QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("knowledge_base_id", knowledgeBase.getId());
        List<ExtDictEntity> result = extDictService.list(wrapper);

        String indexName = knowledgeBase.getCode();
        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

        List<KnowledgeEmbeddingPointsEntity> points = new ArrayList<>();
        List<ExtDictRelationEntity> relationList = new ArrayList<>();
        if(result!=null && result.size()>0){
            for (ExtDictEntity extDictEntity : result) {
                if(entity.getContent().contains(extDictEntity.getField())){
                    Long id = IdWorker.getId();
                    ExtDictRelationEntity re = new ExtDictRelationEntity();
                    re.setId(id);
                    re.setType(1);
                    re.setExtDictId(extDictEntity.getId());
                    re.setEmbeddingId(entity.getId());
                    re.setField(extDictEntity.getField());

                    KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
                    //直接生成对应带有标签的切片信息
                    point.setId(id);
                    point.setType(4);
                    point.setEmbeddingId(entity.getId());
                    //获取数据
                    point.setContent(extDictEntity.getField());
                    point.setInitContent(extDictEntity.getField());
                    String redisId = ("tag-"+pointId+"-"+id);

                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, extDictEntity.getField(), embeddingModel, embeddingStore);

                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisIds = (String) json.get("redisId");
                    point.setUuid(indexName+":"+redisIds);
                    point.setVector(Arrays.toString(embedding.vector()));
                    points.add(point);

                    relationList.add(re);
                }
            }
        }
        if(points!=null && points.size()>0){
            knowledgeEmbeddingPointsService.saveOrUpdateBatch(points, points.size(), false);
        }
        if(relationList!=null && relationList.size()>0){
            extDictRelationService.saveOrUpdateBatch(relationList, relationList.size(), false);
        }
    }
}
