package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.api.IKbmApi;
import com.ejianc.business.doc.api.result.KbmResult;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeItemMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.utils.EjcThreadPoolUtils;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.auth.shiro.AuthConstants;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.CookieUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentByRegexSplitter;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;

/**
 * AI知识库文件
 *
 * @author generator
 *
 */
@Service("knowledgeItemService")
public class KnowledgeItemServiceImpl extends BaseServiceImpl<KnowledgeItemMapper, KnowledgeItemEntity> implements IKnowledgeItemService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeItemMapper knowledgeItemMapper;
    @Autowired
    private IKbmApi kbmApi;
    @Autowired
    private EjcThreadPoolUtils ejcThreadPoolUtils;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IKnowledgeCategoryService knowledgeCategoryService;
    @Autowired
    private IExtDictService extDictService;
    @Autowired
    private IExtDictRelationService extDictRelationService;

    @Value("${common.env.base-host:#{null}}")
    private String baseHost;

    public  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }

        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<KnowledgeItemEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("file_code", code);
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

                List<KnowledgeItemEntity> list = knowledgeItemMapper.selectList(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            logger.info("生成编码失败:{}",e);
            throw new BusinessException("生成编码失败");
        }
        return code;
    }

    @Override
    public KnowledgeItemVO insert(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.selectById(saveOrUpdateVO.getKnowledgeBaseId());
        String indexName = knowledgeBase.getCode();
        KnowledgeItemEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeItemEntity.class);
        if(saveOrUpdateVO.getId()==null){
            entity.setId(IdWorker.getId());
            entity.setFileCode(generateCode());
            entity.setUploadUserId(InvocationInfoProxy.getUserid());
        }
        //获取该知识库标签
        QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("knowledge_base_id", knowledgeBase.getId());
        List<ExtDictEntity> extDictList = extDictService.list(wrapper);

        //加载文件内容
        Document document = documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
        if(StringUtils.isBlank(entity.getBrief())) {
            if(StringUtils.isNotBlank(document.text())){
                if(document.text().length()>300){
                    entity.setBrief(document.text().substring(0, 300));
                }else{
                    entity.setBrief(document.text());
                }
            }
        }

        if(entity.getKnowledgeType() == 1){

            entity.setEmbeddingStatus(2);
            this.saveOrUpdate(entity, false);

            Map<String, Object> invocationInfo = new HashMap<>();
            invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute("authority"));
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());
            //文本型知识库
            Runnable task = () -> {
                InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
                InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
                InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
                InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
                InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
                InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
                InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
                InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
                InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
                InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
                InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
                InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

                InvocationInfoProxy.setExtendAttribute("authority", invocationInfo.get("authority")!=null?invocationInfo.get("authority").toString():null);

                List<String> allRedisIds = new ArrayList<>();
                try {
                    DocumentSplitter documentSplitter = null;
                    if (entity.getSliceStrategy() == 0) {
                        //默认切片
                        documentSplitter = DocumentSplitters.recursive(entity.getSliceMaxLength(), entity.getSliceOverlap());
                    } else {
                        if (StringUtils.isBlank(entity.getSliceIdentifier())) {
                            throw new BusinessException("标识符不能为空");
                        }
                        //自定义切片策咯
                        if ("char".equals(entity.getSliceIdentifier())) {
                            //按字符切分
                            documentSplitter = new DocumentByCharacterSplitter(entity.getSliceMaxLength(), entity.getSliceOverlap());
                        } else if ("paragraph".equals(entity.getSliceIdentifier())) {
                            //按段落切分
                            documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else if ("regex".equals(entity.getSliceIdentifier()) || "fixedChar".equals(entity.getSliceIdentifier())) {
                            //按正则表达式切分
                            documentSplitter = new DocumentByRegexSplitter(entity.getSliceExpression(), "", Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else {
                            throw new BusinessException("暂不支持该切片策咯");
                        }
                    }
                    EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                    //// 创建一个内存中的嵌入存储
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                    JSONObject json = documentSplitUtil.documentSplitStore(document, documentSplitter, embeddingModel, embeddingStore);

                    List segments = (List) json.get("segments");
                    List embeddings = (List) json.get("embeddings");
                    allRedisIds = (List) json.get("redisIds");

                    List<KnowledgeEmbeddingEntity> list = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    for (int i = 0; i < segments.size(); i++) {
                        TextSegment segment = (TextSegment) segments.get(i);
                        Embedding embedding = (Embedding) embeddings.get(i);
                        String id = (String) allRedisIds.get(i);

                        KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                        e.setId(IdWorker.getId());
                        e.setUuid(indexName + ":" + id);
                        e.setItemId(entity.getId());
                        e.setContent(segment.text());
                        e.setInitContent(segment.text());
                        e.setSliceState(1);
                        e.setType(1);
                        e.setSequence(segments.size()-i);
                        list.add(e);


                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setId(IdWorker.getId());
                        p.setEmbeddingId(e.getId());
                        p.setUuid(indexName + ":" + id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(1);
                        listPoints.add(p);
                        generateSysTag(e, p.getId(), indexName, extDictList, embeddingModel, embeddingStore);
                    }
                    if (list != null && list.size() > 0) {
                        knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    entity.setEmbeddingCount(segments.size());
                    entity.setEmbeddingStatus(3);
                    this.saveOrUpdate(entity, false);
                }catch (Exception e){
                    logger.error("生成向量数据库信息失败：{}",e);
                    entity.setEmbeddingStatus(4);
                    this.saveOrUpdate(entity, false);
                    //删除生成的向量数据库信息
                    EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            };
            new Thread(task).start();
        }else{
            entity.setEmbeddingStatus(1);
            this.saveOrUpdate(entity, false);
            //表格型知识库
            String[] allText = document.text().split("\n");
            //第0行是页签名称
            if(allText.length<2){
                throw new BusinessException("未获取到文件数据，请确认数据是否正确");
            }
            String[] titles = allText[1].split("\t");

            //保存索引信息
            KnowledgeItemTableIndexEntity indexEntity = new KnowledgeItemTableIndexEntity();
            indexEntity.setItemId(entity.getId());
            indexEntity.setTitles(String.join(",", titles));
            knowledgeItemTableIndexService.saveOrUpdate(indexEntity, false);
        }

        KnowledgeItemVO vo = BeanMapper.map(entity, KnowledgeItemVO.class);
        return vo;
    }

    @Override
    public KnowledgeItemVO saveData(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemEntity entity = knowledgeItemMapper.selectById(saveOrUpdateVO.getId());
        entity.setBrief(saveOrUpdateVO.getBrief());
        entity.setFileState(saveOrUpdateVO.getFileState());
        entity.setSequence(saveOrUpdateVO.getSequence());
        this.saveOrUpdate(entity, false);
        KnowledgeItemVO vo = BeanMapper.map(entity, KnowledgeItemVO.class);
        return vo;
    }

    @Override
    public void delData(List<Long> ids) {
        QueryWrapper<KnowledgeEmbeddingEntity> wrapperEmbedding = new QueryWrapper<>();
        wrapperEmbedding.in("item_id", ids);
        List<KnowledgeEmbeddingEntity> list = knowledgeEmbeddingService.list(wrapperEmbedding);
        if(list!=null && list.size()>0){
            List<Long> embeddingIds = new ArrayList<>();
            list.forEach(item -> {
                embeddingIds.add(item.getId());
            });
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapperEmbeddingPoints = new QueryWrapper<>();
            wrapperEmbeddingPoints.in("embedding_id", embeddingIds);
            List<KnowledgeEmbeddingPointsEntity> points = knowledgeEmbeddingPointsService.list(wrapperEmbeddingPoints);

            KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(ids.get(0));
            String indexName = knowledgeBase.getCode();

            if(points!=null && points.size()>0){
                List<String> rids = new ArrayList<>();
                points.forEach(item -> {
                    rids.add(item.getUuid());
                });
                EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.removeAll(rids);
            }
            knowledgeEmbeddingService.remove(wrapperEmbedding);
            knowledgeEmbeddingPointsService.remove(wrapperEmbeddingPoints);

            QueryWrapper<ExtDictRelationEntity> extDictRelationWrapper = new QueryWrapper<>();
            extDictRelationWrapper.in("embedding_id", embeddingIds);
            extDictRelationService.remove(extDictRelationWrapper);
        }
        this.removeByIds(ids,true);
    }

    public List<KnowledgeItemEntity> queryKnowlegeItemList(String embeddingIds) {
        List<KnowledgeItemEntity> itemList = knowledgeItemMapper.queryKnowlegeItemList(embeddingIds);
        return itemList;
    }

    @Override
    public void updateReferenceCount(Long id) {
        knowledgeItemMapper.updateReferenceCount(id);
    }

    private void setInvocation(String authority) {
        // 如果header中包含，则以header为主，否则，以cookie为主
        if (StringUtils.isNotBlank(authority)) {
            Set<Cookie> cookieSet = new HashSet<Cookie>();
            String[] ac = authority.split(";");
            for (String s : ac) {
                String[] cookieArr = s.split("=");
                String key = StringUtils.trim(cookieArr[0]);
                String value = StringUtils.trim(cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            Cookie[] cookies = cookieSet.toArray(new Cookie[] {});

            InvocationInfoProxy.setToken(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TOKEN));
            InvocationInfoProxy.setUserid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERID)));
            InvocationInfoProxy.setUsercode(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERCODE));
            InvocationInfoProxy.setTenantid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TENANTID)));
        }
    }

    @Override
    public void insertKnowledgeItemDispatch(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
        CommonResponse<List<KbmResult>> kbmResultResp = kbmApi.queryKbmFileList();
        if(kbmResultResp.isSuccess()) {
            List<KbmResult> kbmResultList = kbmResultResp.getData();
            if(kbmResultList != null && kbmResultList.size() > 0) {
                Long prevkbmId = null;//KbmResult kbmResult : kbmResultList
                for(int i=0;i<kbmResultList.size();i++) {
                    KbmResult kbmResult = kbmResultList.get(i);
                    if(prevkbmId != null && prevkbmId != kbmResult.getKbmId()) {
                        kbmApi.updateKbmEmbeddingState(prevkbmId);
                    }
                    prevkbmId = kbmResult.getKbmId();
                    if(i == kbmResultList.size()-1) {
                        kbmApi.updateKbmEmbeddingState(kbmResult.getKbmId());
                    }

                    ejcThreadPoolUtils.runTask(new Runnable() {
                        @Override
                        public void run() {
                            RequestContextHolder.setRequestAttributes(context);
                            setInvocation(authority);
                            KnowledgeBaseEntity knowledgeBase = null;
                            try {
                                knowledgeBase = knowledgeBaseService.selectById(kbmResult.getTenantId());
                                if(knowledgeBase == null) {
                                    knowledgeBase = new KnowledgeBaseEntity();
                                    knowledgeBase.setId(kbmResult.getTenantId());
                                    knowledgeBase.setCode(kbmResult.getTenantId()+"");
                                    CommonResponse<TenantVO> tenantResp = tenantApi.queryDetail(kbmResult.getTenantId());
                                    if(tenantResp.isSuccess()) {
                                        knowledgeBase.setName(tenantResp.getData().getName());
                                    }
                                    knowledgeBase.setKnowledgeType(1);
                                    knowledgeBase.setSequence(0);
                                    knowledgeBaseService.saveOrUpdate(knowledgeBase, false);
                                }
                            }catch(Exception e) {}


                            //获取该知识库标签
                            QueryWrapper<ExtDictEntity> wrapper = new QueryWrapper<>();
                            wrapper.eq("knowledge_base_id", knowledgeBase.getId());
                            List<ExtDictEntity> extDictList = extDictService.list(wrapper);

                            try {
                                KnowledgeCategoryEntity categoryEntity = new KnowledgeCategoryEntity();
                                categoryEntity.setId(kbmResult.getTenantId());
                                categoryEntity.setName("默认分类");
                                categoryEntity.setKnowledgeBaseId(kbmResult.getTenantId());
                                categoryEntity.setInnerCode(kbmResult.getTenantId()+"");
                                knowledgeCategoryService.save(categoryEntity);
                            }catch(Exception e) {}

                            String indexName = kbmResult.getTenantId() + "";
                            KnowledgeItemEntity entity = new KnowledgeItemEntity();
                            entity.setId(IdWorker.getId());
                            entity.setKnowledgeBaseId(kbmResult.getTenantId());
                            entity.setCategoryId(kbmResult.getTenantId());
                            entity.setFileCode(generateCode());
                            entity.setFileId(kbmResult.getFileId());
                            entity.setFileName(kbmResult.getFileName());
                            entity.setFilePath(kbmResult.getFilePath());
                            entity.setFileSize(kbmResult.getFileSize());
                            entity.setOnlinePath(baseHost+"ejc-file-web/onlinePreview?fileId="+kbmResult.getFileId());
                            entity.setFileSuffix(FilenameUtils.getExtension(kbmResult.getFilePath()));
                            entity.setFileState(1);
                            entity.setKnowledgeType(1);
                            entity.setSliceStrategy(1);
                            entity.setSliceIdentifier("paragraph");
                            entity.setSliceMaxLength(400);
                            entity.setSliceOverlap(10);
                            //加载文件内容
                            Document document = documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
                            if(StringUtils.isBlank(entity.getBrief())) {
                                if(StringUtils.isNotBlank(document.text())){
                                    if(document.text().length()>300){
                                        entity.setBrief(document.text().substring(0, 300));
                                    }else{
                                        entity.setBrief(document.text());
                                    }
                                }
                            }

                            List<String> allRedisIds = new ArrayList<>();
                            try {
                                //按段落切分
                                DocumentSplitter documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, 10);
                                EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                                //// 创建一个内存中的嵌入存储
                                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                                JSONObject json = documentSplitUtil.documentSplitStore(document, documentSplitter, embeddingModel, embeddingStore);

                                List segments = (List) json.get("segments");
                                List embeddings = (List) json.get("embeddings");
                                allRedisIds = (List) json.get("redisIds");

                                List<KnowledgeEmbeddingEntity> list = new ArrayList<>();
                                List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                                for (int i = 0; i < segments.size(); i++) {
                                    TextSegment segment = (TextSegment) segments.get(i);
                                    Embedding embedding = (Embedding) embeddings.get(i);
                                    String id = (String) allRedisIds.get(i);

                                    KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                                    e.setId(IdWorker.getId());
                                    e.setUuid(indexName + ":" + id);
                                    e.setItemId(entity.getId());
                                    e.setContent(segment.text());
                                    e.setInitContent(segment.text());
                                    e.setSliceState(1);
                                    e.setType(1);
                                    e.setSequence(segments.size() - i);
                                    list.add(e);

                                    KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                                    p.setId(IdWorker.getId());
                                    p.setEmbeddingId(e.getId());
                                    p.setUuid(indexName + ":" + id);
                                    p.setContent(segment.text());
                                    p.setInitContent(segment.text());
                                    p.setVector(Arrays.toString(embedding.vector()));
                                    p.setType(1);
                                    p.setSequence(1);
                                    listPoints.add(p);

                                    generateSysTag(e, p.getId(), indexName, extDictList, embeddingModel, embeddingStore);
                                }
                                if (list != null && list.size() > 0) {
                                    knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                                    knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                                }
                                entity.setEmbeddingCount(segments.size());
                                entity.setEmbeddingStatus(3);
                                knowledgeItemMapper.insert(entity);
                            }catch(Exception e) {}
                        }
                    });
                }
            }
        }
    }

    private void generateSysTag(KnowledgeEmbeddingEntity entity, Long pointId, String indexName, List<ExtDictEntity> result, EmbeddingModel embeddingModel, EmbeddingStore<TextSegment> embeddingStore){
        if(result!=null && result.size()>0){
            List<KnowledgeEmbeddingPointsEntity> points = new ArrayList<>();
            List<ExtDictRelationEntity> relationList = new ArrayList<>();
            for (ExtDictEntity extDictEntity : result) {
                if(entity.getContent().contains(extDictEntity.getField())){
                    Long id = IdWorker.getId();
                    ExtDictRelationEntity re = new ExtDictRelationEntity();
                    re.setId(id);
                    re.setType(1);
                    re.setExtDictId(extDictEntity.getId());
                    re.setEmbeddingId(entity.getId());
                    re.setField(extDictEntity.getField());
                    relationList.add(re);

                    KnowledgeEmbeddingPointsEntity point = new KnowledgeEmbeddingPointsEntity();
                    //直接生成对应带有标签的切片信息
                    point.setId(id);
                    point.setType(4);
                    point.setEmbeddingId(entity.getId());
                    //获取数据
                    point.setContent(extDictEntity.getField());
                    point.setInitContent(extDictEntity.getField());
                    String redisId = ("tag-"+pointId+"-"+id);

                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreSingleSourceId(redisId, extDictEntity.getField(), embeddingModel, embeddingStore);

                    Embedding embedding = (Embedding) json.get("embedding");
                    String redisIds = (String) json.get("redisId");
                    point.setUuid(indexName+":"+redisIds);
                    point.setVector(Arrays.toString(embedding.vector()));
                    points.add(point);

                }
            }
            if(points!=null && points.size()>0){
                knowledgeEmbeddingPointsService.saveOrUpdateBatch(points, points.size(), false);
            }
            if(relationList!=null && relationList.size()>0){
                extDictRelationService.saveOrUpdateBatch(relationList, relationList.size(), false);
            }
        }

    }
}
