package com.ejianc.foundation.ai.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.controller.api.material.Constant;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import okhttp3.*;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;


public class QianfanAppBuilderUtil {

    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(QianfanAppBuilderUtil.class);

    private static final MediaType mediaType = MediaType.parse("application/json");

    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder()
            .connectTimeout(10, TimeUnit.MINUTES)
            .readTimeout(10, TimeUnit.MINUTES)
            .writeTimeout(10, TimeUnit.MINUTES)
            .build();

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");


    /**
     * 调用千帆大模型appbuilder
     * */
    public static String postChatMsg(JSONObject msgBody,String AppBuilderAppID,String AppBuilderSecretKey) {
        try {
            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.ChatUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", Constant.ContentType)
                    .addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            return resBody;
        } catch (Exception e) {
            logger.error("百度大模型对话出错：{}", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 调用千帆大模型appbuilder，获取会话id
     * */
    public static String getNewConversationId(String appBuilderAppID, String appBuilderSecretKey) {
        try {
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", appBuilderAppID);
            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.CreateConversationUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json")
                    .addHeader("X-Appbuilder-Authorization", appBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("conversation_id");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String uploadLocalFile(String appId, String secretKey, String conversationId, String imageUrl, String imageName) {
        String formattedDate = sdf.format(new Date());
        String savePath = QianfanAppBuilderUtil.class.getClassLoader().getResource("").getPath() + "/receiptAiImage/"
                + formattedDate + "_" + imageName;
        try {
            URL url = new URL(imageUrl);
            BufferedImage image = ImageIO.read(url);
            File file = new File(savePath);
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                ImageIO.write(image, FilenameUtils.getExtension(imageName), file);
            }
            RequestBody body = new MultipartBody.Builder().setType(MultipartBody.FORM)
                    .addFormDataPart("app_id", appId)
                    .addFormDataPart("file", imageName,
                            RequestBody.create(MediaType.parse("application/octet-stream"),
                                    file))
                    .addFormDataPart("conversation_id", conversationId)
                    .build();
            Request request = new Request.Builder()
                    .url("https://qianfan.baidubce.com/v2/app/conversation/file/upload")
                    .method("POST", body)
                    .addHeader("Content-Type", "multipart/form-data")
                    .addHeader("X-Appbuilder-Authorization", secretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject(response.body().string());
            return qFanContent.getString("id");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }



}
