package com.ejianc.framework.cache.serializer.impl;

import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.utils.SerializUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


public class DefaultJDKSerializer implements Serializer {

    @Override
    public Serializable unMarshal(String data) {
        return (Serializable) SerializUtil.getObjectFromStr(data);
    }

    @Override
    public String marshalToString(Serializable data) {
        return SerializUtil.getStrFromObj(data);
    }

    @Override
    public Serializable unMarshal(byte[] data) {
        return (Serializable) SerializUtil.byteToObject(data);
    }

    @Override
    public byte[] marshalToByte(Serializable data) {
        return SerializUtil.objectToByte(data);
    }

    @Override
    public List<Serializable> unMarshal(List<byte[]> dataList) {
        List<Serializable> resultList = new ArrayList<Serializable>();
        if (dataList != null && !dataList.isEmpty()) {
            for (byte[] data : dataList) {
                if (data != null) {
                    resultList.add((Serializable) SerializUtil.byteToObject(data));
                }
            }
        }
        return resultList;
    }
}
