package com.ejianc.business.analysis.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工期延误项目成本风险化解情况
 *
 * @author generator
 *
 */
public class ProDurationDelayVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long projectStatus; // 项目状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDelayTime; // 工期延误-工期延误开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDelayTime; // 工期延误-工期延误结束时间
    private BigDecimal delayDaysTotal; // 工期延误-延误天数-延误天数合计
    private BigDecimal delayDaysCasej; // 工期延误-延误天数-甲方原因
    private BigDecimal delayDaysCasey; // 工期延误-延误天数-我方原因
    private BigDecimal delayCostTotal; // 工期延误-涉及增加的成本(万元)-增加成本合计
    private BigDecimal delayCostCasej; // 工期延误-涉及增加的成本(万元)-甲方原因
    private BigDecimal delayCostCasey; // 工期延误-涉及增加的成本(万元)-我方原因
    private BigDecimal delayClaimEstimate; // 工期延误-预计索赔-预计工期索赔
    private BigDecimal delayClaimBasis; // 工期延误-预计索赔-有依有据索赔
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date delayClaimTime; // 工期延误-预计索赔-预计报出时间
    private BigDecimal compensateDate; // 向甲方提出索赔-索赔工期(天)
    private BigDecimal compensateCost; // 向甲方提出索赔-索赔费用(万元)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date compensateSubmit; // 向甲方提出索赔-提交索赔时间
    private BigDecimal compensateConfirmDays; // 向甲方提出索赔-甲方确认-天数
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date compensateConfirmDate; // 向甲方提出索赔-甲方确认-日期
    private BigDecimal compensateConfirmCost; // 向甲方提出索赔-甲方确认-赔偿(索赔)金额(万元)
    private BigDecimal projectCompletionDays; // 项目完工-预计工期延误总天数
    private BigDecimal projectCompletionCost; // 项目完工-预计因工期延误发生的总成本
    private String personLiable; // 责任人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedCompletionTime; // 预计完成时间
    private String resolutionMeasures; // 化解措施
    private String remarks; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date month; // 月份
    private String reportingMonth; // 报表日期
    private Long twoOrgId; // 二级组织id
    private String twoOrgCode; // 二级组织编码
    private String twoOrgName; // 二级组织名称
    private Date projectCreateTime;// 项目创建日期

    private String number; //序号
    private String projectStatusName; //项目状态名称
    private String compensateConfirmName; // 向甲方提出索赔-是否确认 名称
    private Integer projectStatusOrder; // 项目状态排序
    private Integer orgStatusOrder; // 二级组织排序
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Long projectStatus) {
        this.projectStatus = projectStatus;
    }
    public Date getBeginDelayTime() {
        return beginDelayTime;
    }

    public void setBeginDelayTime(Date beginDelayTime) {
        this.beginDelayTime = beginDelayTime;
    }
    public Date getEndDelayTime() {
        return endDelayTime;
    }

    public void setEndDelayTime(Date endDelayTime) {
        this.endDelayTime = endDelayTime;
    }
    public BigDecimal getDelayDaysTotal() {
        return delayDaysTotal;
    }

    public void setDelayDaysTotal(BigDecimal delayDaysTotal) {
        this.delayDaysTotal = delayDaysTotal;
    }
    public BigDecimal getDelayDaysCasej() {
        return delayDaysCasej;
    }

    public void setDelayDaysCasej(BigDecimal delayDaysCasej) {
        this.delayDaysCasej = delayDaysCasej;
    }
    public BigDecimal getDelayDaysCasey() {
        return delayDaysCasey;
    }

    public void setDelayDaysCasey(BigDecimal delayDaysCasey) {
        this.delayDaysCasey = delayDaysCasey;
    }
    public BigDecimal getDelayCostTotal() {
        return delayCostTotal;
    }

    public void setDelayCostTotal(BigDecimal delayCostTotal) {
        this.delayCostTotal = delayCostTotal;
    }
    public BigDecimal getDelayCostCasej() {
        return delayCostCasej;
    }

    public void setDelayCostCasej(BigDecimal delayCostCasej) {
        this.delayCostCasej = delayCostCasej;
    }
    public BigDecimal getDelayCostCasey() {
        return delayCostCasey;
    }

    public void setDelayCostCasey(BigDecimal delayCostCasey) {
        this.delayCostCasey = delayCostCasey;
    }
    public BigDecimal getDelayClaimEstimate() {
        return delayClaimEstimate;
    }

    public void setDelayClaimEstimate(BigDecimal delayClaimEstimate) {
        this.delayClaimEstimate = delayClaimEstimate;
    }
    public BigDecimal getDelayClaimBasis() {
        return delayClaimBasis;
    }

    public void setDelayClaimBasis(BigDecimal delayClaimBasis) {
        this.delayClaimBasis = delayClaimBasis;
    }
    public Date getDelayClaimTime() {
        return delayClaimTime;
    }

    public void setDelayClaimTime(Date delayClaimTime) {
        this.delayClaimTime = delayClaimTime;
    }
    public BigDecimal getCompensateDate() {
        return compensateDate;
    }

    public void setCompensateDate(BigDecimal compensateDate) {
        this.compensateDate = compensateDate;
    }
    public BigDecimal getCompensateCost() {
        return compensateCost;
    }

    public void setCompensateCost(BigDecimal compensateCost) {
        this.compensateCost = compensateCost;
    }
    public Date getCompensateSubmit() {
        return compensateSubmit;
    }

    public void setCompensateSubmit(Date compensateSubmit) {
        this.compensateSubmit = compensateSubmit;
    }
    public BigDecimal getCompensateConfirmDays() {
        return compensateConfirmDays;
    }

    public void setCompensateConfirmDays(BigDecimal compensateConfirmDays) {
        this.compensateConfirmDays = compensateConfirmDays;
    }
    public Date getCompensateConfirmDate() {
        return compensateConfirmDate;
    }

    public void setCompensateConfirmDate(Date compensateConfirmDate) {
        this.compensateConfirmDate = compensateConfirmDate;
    }
    public BigDecimal getCompensateConfirmCost() {
        return compensateConfirmCost;
    }

    public void setCompensateConfirmCost(BigDecimal compensateConfirmCost) {
        this.compensateConfirmCost = compensateConfirmCost;
    }
    public BigDecimal getProjectCompletionDays() {
        return projectCompletionDays;
    }

    public void setProjectCompletionDays(BigDecimal projectCompletionDays) {
        this.projectCompletionDays = projectCompletionDays;
    }
    public BigDecimal getProjectCompletionCost() {
        return projectCompletionCost;
    }

    public void setProjectCompletionCost(BigDecimal projectCompletionCost) {
        this.projectCompletionCost = projectCompletionCost;
    }
    public String getPersonLiable() {
        return personLiable;
    }

    public void setPersonLiable(String personLiable) {
        this.personLiable = personLiable;
    }
    public Date getEstimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    public void setEstimatedCompletionTime(Date estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
    }
    public String getResolutionMeasures() {
        return resolutionMeasures;
    }

    public void setResolutionMeasures(String resolutionMeasures) {
        this.resolutionMeasures = resolutionMeasures;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getProjectStatusName() {
        return projectStatusName;
    }

    public void setProjectStatusName(String projectStatusName) {
        this.projectStatusName = projectStatusName;
    }

    public String getCompensateConfirmName() {
        return compensateConfirmName;
    }

    public void setCompensateConfirmName(String compensateConfirmName) {
        this.compensateConfirmName = compensateConfirmName;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public Integer getProjectStatusOrder() {
        return projectStatusOrder;
    }

    public void setProjectStatusOrder(Integer projectStatusOrder) {
        this.projectStatusOrder = projectStatusOrder;
    }

    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }

    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
}
