package com.ejianc.business.analysis.mapper;

import com.ejianc.business.analysis.vo.ProSignReserveVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目责任书签订及风险金预留情况
 *
 * @author generator
 *
 */
@Mapper
public interface ProSignReserveMapper extends BaseCrudMapper<ProSignReserveEntity> {

    // 根据结束日期生成单据
    void saveBatch(String endDate);

    //  查询项目ids
    List<ProSignReserveVO> queryProjectIds(@Param("endDate") String endDate);

    //  查询施工类合同
    List<ProSignReserveVO> queryIncontract(@Param("id") Long id,@Param("endDate") String endDate);

    //  查询项目目标管理责任书
    List<ProSignReserveVO> queryBook(@Param("id") Long id);

    // 查询项目部人员风险金预留分配表
    List<ProSignReserveVO> queryAllocate(@Param("id") Long id);

}
