package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProDurationDelayMapper;
import com.ejianc.business.analysis.bean.ProDurationDelayEntity;
import com.ejianc.business.analysis.service.IProDurationDelayService;
import org.w3c.dom.stylesheets.LinkStyle;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 工期延误项目成本风险化解情况
 *
 * @author generator
 *
 */
@Service("proDurationDelayService")
public class ProDurationDelayServiceImpl extends BaseServiceImpl<ProDurationDelayMapper, ProDurationDelayEntity> implements IProDurationDelayService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public void execute(String day, String date) {
        //结束日期:执行日期减一天
        String endDate = null;
        //如果配置了手动生成日期，则不执行用户设置日期
        if(StringUtils.isNotEmpty(date)){
            Date executeDate = null;
            try {
                //方便手动调用接口日期
                executeDate = DateUtils.parseDate(date,"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //结束日期:执行日期减一个月
            endDate = DateFormatUtils.format(DateUtils.addMonths(executeDate, -1), "yyyy-MM-dd");
        }else{
            //如果当前日期不等于设置天数，不执行
            if (!day.equals(DateFormatUtils.format(new Date(), "d"))) {
                throw new BusinessException("当前日期，不匹配设置日期");
            }else{
                //结束日期:执行日期减一个月之前得所有数据
                endDate = DateFormatUtils.format(DateUtils.addMonths(new Date(), -1), "yyyy-MM-dd");
            }
        }
        // 根据结束日期生成单据
        saveBatch(endDate);
        List<ProDurationDelayEntity>proDurationDelayEntities=super.list(new QueryWrapper<ProDurationDelayEntity>().isNull("two_org_id"));
        for (ProDurationDelayEntity entity : proDurationDelayEntities) {
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(entity.getProjectDepartmentId());//此处是项目部id
            if (orgVo.isSuccess() && null != orgVo.getData()){
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    entity.setTwoOrgId(orgVos.getData().getId());
                    entity.setTwoOrgName(orgVos.getData().getName());
                    entity.setTwoOrgCode(orgVos.getData().getCode());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proDurationDelayEntities)) {
            saveOrUpdateBatch(proDurationDelayEntities);
        }
    }

    @Override
    public void saveBatch(String endDate) {
        baseMapper.saveBatch(endDate);
    }

}
