package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 收入分析
 * 
 * @author generator
 * 
 */
@Service("profitIncomeService")
public class ProfitIncomeServiceImpl extends BaseServiceImpl<ProfitIncomeMapper, ProfitIncomeEntity> implements IProfitIncomeService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ProfitIncomeMapper mapper;

    @Override
    public void execute(Integer inAdvanceFlag,String day,String date,List<Long> projectIdList) {
        //结束日期:执行日期减一天
        String endDate = null;
        //如果配置了手动生成日期，则不执行用户设置日期
        if(StringUtils.isNotEmpty(date)){
            Date executeDate = null;
            try {
                //方便手动调用接口日期
                executeDate = DateUtils.parseDate(date,"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //结束日期:执行日期减一个月
            endDate = DateFormatUtils.format(DateUtils.addMonths(executeDate, -1), "yyyy-MM-dd");
        }else{
            //如果当前日期不等于设置天数，不执行
            if (!day.equals(DateFormatUtils.format(new Date(), "d"))) {
                throw new BusinessException("当前日期，不匹配设置日期");
            }else{
                //结束日期:执行日期减一个月之前得所有数据
                endDate = DateFormatUtils.format(DateUtils.addMonths(new Date(), -1), "yyyy-MM-dd");
            }
        }
        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            endDate =  date;
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = getProjectList(endDate,projectIdList);
        }else{
            //等于1代表预生成数据
            if(inAdvanceFlag == 1){
                endDate =  date;
                profitIncomeVOList = queryProjects(endDate);
            }else{
                profitIncomeVOList = queryProjects(endDate);
            }

        }

        //查询项目月度成本分析
        List<ProfitIncomeVO> costanalysisList = queryCostanalysis(endDate);
        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                Date createDate = null;
                try {
                    //方便手动调用接口日期
                    createDate = DateUtils.parseDate(endDate,"yyyy-MM-dd");
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                profitIncomeVO.setReportingMonth(createDate);//取当前生成月份日期
                for(ProfitIncomeVO profitIncomeVO1 : costanalysisList){
                    if(profitIncomeVO.getProjectId().equals(profitIncomeVO1.getProjectId())){
                        profitIncomeVO.setRealProduct(profitIncomeVO1.getCumulativeIncome() == null ? new BigDecimal("0") : profitIncomeVO1.getCumulativeIncome());
                        profitIncomeVO.setCostAnalysisCreateTime(profitIncomeVO1.getCostAnalysisCreateTime());
                        profitIncomeVO.setCreateTime(new Date());
                    }
                }
            }
            //补全二级组织信息
            for(ProfitIncomeVO profitIncomeVO : profitIncomeVOList){
                CommonResponse<OrgVO> orgVo = iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        profitIncomeVO.setTwoOrgId(orgVos.getData().getId());
                        profitIncomeVO.setTwoOrgName(orgVos.getData().getName());
                        profitIncomeVO.setTwoOrgCode(orgVos.getData().getCode());
                    }
                    /*CommonResponse<OrgVO> orgVO = iOrgApi.detailById(profitIncomeVO.getOrgId());
                    if (orgVO.isSuccess() && null != orgVO.getData()) {
                        profitIncomeVO.setOrgCode(orgVO.getData().getCode());
                    }*/
                }
            }
            //查询工程计量台账
            List<ProfitIncomeVO> engineermeasurementList = queryEngineermeasurement(endDate);
            if(CollectionUtils.isNotEmpty(engineermeasurementList)){
                //补全工程计量台账信息
                for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                    for(ProfitIncomeVO profitIncomeVO1 : engineermeasurementList){
                        if(profitIncomeVO.getProjectId().equals(profitIncomeVO1.getProjectId())){
                            profitIncomeVO.setNotarizeProduct(profitIncomeVO1.getCurrentBatch() == null ? new BigDecimal(0) : profitIncomeVO1.getCurrentBatch());
                        }
                    }
                }
            }else{
                //如果工程计量台账为空默认为0
                for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                    profitIncomeVO.setNotarizeProduct(new BigDecimal(0));
                }
            }
            for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                //如果项目状态=已竣已结算  业主确认产值=实际完成产值
                if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5){
                    profitIncomeVO.setNotarizeProduct(profitIncomeVO.getRealProduct());
                }
                //已完工未结算 = 实际完成产值-业主确认产值
                profitIncomeVO.setUnliquidated(ComputeUtil.safeSub(profitIncomeVO.getRealProduct(), profitIncomeVO.getNotarizeProduct()));
            }
            logger.info("-----------------------------------------收入分析生成数据,截止日期:"+endDate+" :"+ com.alibaba.fastjson.JSONObject.toJSONString(profitIncomeVOList));

            if(CollectionUtils.isNotEmpty(projectIdList)){
                //如果projectList不为空，证明是修改数据，而不是生成数据
                for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                    //修改
                    LambdaUpdateWrapper<ProfitIncomeEntity> updateWrapper=new LambdaUpdateWrapper<>();
                    updateWrapper.set(ProfitIncomeEntity::getOrgId,profitIncomeVO.getOrgId());
                    updateWrapper.set(ProfitIncomeEntity::getOrgCode,profitIncomeVO.getOrgCode());
                    updateWrapper.set(ProfitIncomeEntity::getOrgName,profitIncomeVO.getOrgName());
                    updateWrapper.set(ProfitIncomeEntity::getProjectDepartmentId,profitIncomeVO.getProjectDepartmentId());
                    updateWrapper.set(ProfitIncomeEntity::getProjectName,profitIncomeVO.getProjectName());
                    updateWrapper.set(ProfitIncomeEntity::getProjectCode,profitIncomeVO.getProjectCode());
                    updateWrapper.set(ProfitIncomeEntity::getProjectStatus,profitIncomeVO.getProjectStatus());
                    updateWrapper.set(ProfitIncomeEntity::getRealProduct,profitIncomeVO.getRealProduct());
                    updateWrapper.set(ProfitIncomeEntity::getNotarizeProduct,profitIncomeVO.getNotarizeProduct());
                    updateWrapper.set(ProfitIncomeEntity::getUnliquidated,profitIncomeVO.getUnliquidated());
                    updateWrapper.set(ProfitIncomeEntity::getProjectCreateTime,profitIncomeVO.getProjectCreateTime());
                    updateWrapper.set(ProfitIncomeEntity::getCostAnalysisCreateTime,profitIncomeVO.getCostAnalysisCreateTime());
                    updateWrapper.eq(ProfitIncomeEntity::getProjectId,profitIncomeVO.getProjectId());
                    updateWrapper.eq(ProfitIncomeEntity::getReportingMonth,endDate);
                    boolean flag = update(updateWrapper);
                    if(!flag){
                        logger.info("-----------------------------------------收入分析更新数据失败,截止日期:"+endDate+"项目id"+profitIncomeVO.getProjectId()+"");
                        throw new BusinessException("收入分析更新数据失败！");
                    }
                }

            }else{
                //如果为空就是生成数据
                if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
                    Date executeDate = null;
                    try {
                        //方便手动调用接口日期
                        executeDate = DateUtils.parseDate(endDate,"yyyy-MM-dd");
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                    String dateDel =sdf.format(executeDate);
                    deleteByReportingMonth(dateDel);
                    saveOrUpdateBatch(BeanMapper.mapList(profitIncomeVOList, ProfitIncomeEntity.class));
                }
            }
        }
    }

    @Override
    public List<ProfitIncomeVO> queryProject(String endDate) {
        return baseMapper.getProject(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryCostanalysis(String endDate) {
        return baseMapper.getCostanalysis(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryEngineermeasurement(String endDate) {
        return baseMapper.getEngineermeasurement(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryProjects(String endDate) {
        return baseMapper.getProjects(endDate);
    }

    @Override
    public List<ProfitIncomeVO> getProjectList(String endDate, List<Long> idList) {
        return baseMapper.getProjectList(endDate,idList);
    }

    @Override
    public List<ProfitIncomeVO> processingList(List<ProfitIncomeVO> profitIncomeVOList) {
        //未开工
        BigDecimal realProduct1 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct1 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated1 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList1 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO1 = new ProfitIncomeVO();//小计行

        //在建
        BigDecimal realProduct2 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct2 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated2 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList2 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO2 = new ProfitIncomeVO();//小计行

        //停缓建
        BigDecimal realProduct3 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct3 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated3 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList3 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO3 = new ProfitIncomeVO();//小计行

        //竣工未结算
        BigDecimal realProduct4 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct4 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated4 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList4 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO4 = new ProfitIncomeVO();//小计行

        //竣工已结算
        BigDecimal realProduct5 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct5 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated5 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList5 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO5 = new ProfitIncomeVO();//小计行

        //完工
        BigDecimal realProduct6 = new BigDecimal("0"); //实际完成产值 小计
        BigDecimal notarizeProduct6 = new BigDecimal("0"); //业主确认产值 小计
        BigDecimal unliquidated6 = new BigDecimal("0"); //已完工未结算 小计
        List<ProfitIncomeVO> profitIncomeVOList6 = new ArrayList<>();//数据集合
        ProfitIncomeVO profitIncomeVO6 = new ProfitIncomeVO();//小计行

        //合计
        BigDecimal realProductTotoal = new BigDecimal("0");//实际完成产值 合计
        BigDecimal notarizeProductTotoal = new BigDecimal("0");//业主确认产值 合计
        BigDecimal unliquidatedTotoal = new BigDecimal("0");//已完工未结算 合计
        ProfitIncomeVO profitIncomeVO7 = new ProfitIncomeVO();//合计行

        for(ProfitIncomeVO profitIncomeVO : profitIncomeVOList){
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 1){
                realProduct1 = ComputeUtil.safeAdd(realProduct1,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0"):profitIncomeVO.getRealProduct());
                notarizeProduct1 = ComputeUtil.safeAdd(notarizeProduct1,profitIncomeVO.getNotarizeProduct()  == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct());
                unliquidated1 = ComputeUtil.safeAdd(unliquidated1,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList1.add(profitIncomeVO);
            }
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 2){
                realProduct2 = ComputeUtil.safeAdd(realProduct2,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") :profitIncomeVO.getRealProduct());
                notarizeProduct2 = ComputeUtil.safeAdd(notarizeProduct2,profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") :profitIncomeVO.getNotarizeProduct());
                unliquidated2 = ComputeUtil.safeAdd(unliquidated2,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList2.add(profitIncomeVO);
            }
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 3){
                realProduct3 = ComputeUtil.safeAdd(realProduct3,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") :profitIncomeVO.getRealProduct());
                notarizeProduct3 = ComputeUtil.safeAdd(notarizeProduct3,profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") :profitIncomeVO.getNotarizeProduct());
                unliquidated3 = ComputeUtil.safeAdd(unliquidated3,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList3.add(profitIncomeVO);
            }
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 4){
                realProduct4 = ComputeUtil.safeAdd(realProduct4,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") :profitIncomeVO.getRealProduct());
                notarizeProduct4 = ComputeUtil.safeAdd(notarizeProduct4,profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") :profitIncomeVO.getNotarizeProduct());
                unliquidated4 = ComputeUtil.safeAdd(unliquidated4,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList4.add(profitIncomeVO);
            }
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5){
                realProduct5 = ComputeUtil.safeAdd(realProduct5,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") :profitIncomeVO.getRealProduct());
                notarizeProduct5 = ComputeUtil.safeAdd(notarizeProduct5,profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") :profitIncomeVO.getNotarizeProduct());
                unliquidated5 = ComputeUtil.safeAdd(unliquidated5,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList5.add(profitIncomeVO);
            }
            if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 6){
                realProduct6 = ComputeUtil.safeAdd(realProduct6,profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") :profitIncomeVO.getRealProduct());
                notarizeProduct6 = ComputeUtil.safeAdd(notarizeProduct6,profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") :profitIncomeVO.getNotarizeProduct());
                unliquidated6 = ComputeUtil.safeAdd(unliquidated6,profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") :profitIncomeVO.getUnliquidated());
                profitIncomeVOList6.add(profitIncomeVO);
            }
        }

        realProductTotoal =  getBigDecimalSum(realProduct1,realProduct2,realProduct3,realProduct4,realProduct5,realProduct6);
        notarizeProductTotoal =  getBigDecimalSum(notarizeProduct1,notarizeProduct2,notarizeProduct3,notarizeProduct4,notarizeProduct5,notarizeProduct6);
        unliquidatedTotoal =  getBigDecimalSum(unliquidated1,unliquidated2,unliquidated3,unliquidated4,unliquidated5,unliquidated6);

        for (int i = 0; i < profitIncomeVOList1.size(); i++) {
            profitIncomeVOList1.get(i).setNumber(""+(i+1)+"");
        }
        for (int i = 0; i < profitIncomeVOList2.size(); i++) {
            profitIncomeVOList2.get(i).setNumber(""+(i+1)+"");
        }
        for (int i = 0; i < profitIncomeVOList3.size(); i++) {
            profitIncomeVOList3.get(i).setNumber(""+(i+1)+"");
        }
        for (int i = 0; i < profitIncomeVOList4.size(); i++) {
            profitIncomeVOList4.get(i).setNumber(""+(i+1)+"");
        }
        for (int i = 0; i < profitIncomeVOList5.size(); i++) {
            profitIncomeVOList5.get(i).setNumber(""+(i+1)+"");
        }
        for (int i = 0; i < profitIncomeVOList6.size(); i++) {
            profitIncomeVOList6.get(i).setNumber(""+(i+1)+"");
        }

        List<ProfitIncomeVO> profitIncomeVOS = new ArrayList<>();
        //中建科技集团有限公司  中建科技集团华南有限公司  中建科技集团华东有限公司  中建科技集团华北有限公司 中建科技集团西部有限公司  中建集成建筑有限公司

        //合计行
        profitIncomeVO7.setNumber("合计");
        profitIncomeVO7.setId(Long.parseLong("7"));
        profitIncomeVO7.setRealProduct(realProductTotoal);
        profitIncomeVO7.setNotarizeProduct(notarizeProductTotoal);
        profitIncomeVO7.setUnliquidated(unliquidatedTotoal);
        profitIncomeVOS.add(profitIncomeVO7);

        if(CollectionUtils.isNotEmpty(profitIncomeVOList1)){
            profitIncomeVO1.setId(Long.parseLong("1"));
            profitIncomeVO1.setNumber("小计");
            profitIncomeVO1.setRealProduct(realProduct1);
            profitIncomeVO1.setNotarizeProduct(notarizeProduct1);
            profitIncomeVO1.setUnliquidated(unliquidated1);
            profitIncomeVOS.add(profitIncomeVO1);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList1));
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList2)){
            profitIncomeVO2.setId(Long.parseLong("2"));
            profitIncomeVO2.setNumber("小计");
            profitIncomeVO2.setRealProduct(realProduct2);
            profitIncomeVO2.setNotarizeProduct(notarizeProduct2);
            profitIncomeVO2.setUnliquidated(unliquidated2);
            profitIncomeVOS.add(profitIncomeVO2);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList2));
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList3)){
            profitIncomeVO3.setId(Long.parseLong("3"));
            profitIncomeVO3.setNumber("小计");
            profitIncomeVO3.setRealProduct(realProduct3);
            profitIncomeVO3.setNotarizeProduct(notarizeProduct3);
            profitIncomeVO3.setUnliquidated(unliquidated3);
            profitIncomeVOS.add(profitIncomeVO3);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList3));
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList4)){
            profitIncomeVO4.setId(Long.parseLong("4"));
            profitIncomeVO4.setNumber("小计");
            profitIncomeVO4.setRealProduct(realProduct4);
            profitIncomeVO4.setNotarizeProduct(notarizeProduct4);
            profitIncomeVO4.setUnliquidated(unliquidated4);
            profitIncomeVOS.add(profitIncomeVO4);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList4));
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList5)){
            profitIncomeVO5.setId(Long.parseLong("5"));
            profitIncomeVO5.setNumber("小计");
            profitIncomeVO5.setRealProduct(realProduct5);
            profitIncomeVO5.setNotarizeProduct(notarizeProduct5);
            profitIncomeVO5.setUnliquidated(unliquidated5);
            profitIncomeVOS.add(profitIncomeVO5);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList5));
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList6)){
            profitIncomeVO6.setId(Long.parseLong("6"));
            profitIncomeVO6.setNumber("小计");
            profitIncomeVO6.setRealProduct(realProduct6);
            profitIncomeVO6.setNotarizeProduct(notarizeProduct6);
            profitIncomeVO6.setUnliquidated(unliquidated6);
            profitIncomeVOS.add(profitIncomeVO6);
            profitIncomeVOS.addAll(formatList(profitIncomeVOList6));
        }

        //万元显示
        for(ProfitIncomeVO profitIncomeVO : profitIncomeVOS){
            profitIncomeVO.setRealProduct(ComputeUtil.safeDiv(profitIncomeVO.getRealProduct(),new BigDecimal(10000)));
            profitIncomeVO.setNotarizeProduct(ComputeUtil.safeDiv(profitIncomeVO.getNotarizeProduct(),new BigDecimal(10000)));
            profitIncomeVO.setUnliquidated(ComputeUtil.safeDiv(profitIncomeVO.getUnliquidated(),new BigDecimal(10000)));
        }


        for (int i = 0; i < profitIncomeVOS.size(); i++) {
            if(!("小计").equals(profitIncomeVOS.get(i).getNumber()) && !("合计").equals(profitIncomeVOS.get(i).getNumber())){
                if(profitIncomeVOS.get(i).getProjectStatus() == 1){
                    profitIncomeVOS.get(i).setProjectStatusName("未开工");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 2){
                    profitIncomeVOS.get(i).setProjectStatusName("在建");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 3){
                    profitIncomeVOS.get(i).setProjectStatusName("停缓建");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 4){
                    profitIncomeVOS.get(i).setProjectStatusName("竣工未结算");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 5){
                    profitIncomeVOS.get(i).setProjectStatusName("竣工已结算");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 6){
                    profitIncomeVOS.get(i).setProjectStatusName("完工");
                }
            }


        }
        if(profitIncomeVOS.size() == 1){
            profitIncomeVOS = new ArrayList<>();
        }
        return profitIncomeVOS;
    }

    @Override
    public List<ProfitIncomeVO> queryListPage(Map<String, Object> paramMapper) {
        return mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
         mapper.deleteByReportingMonth(reportingMonth);
    }

    /**
     * 多个BigDecimal数相加和
     *
     * @param i
     * @param arg
     * @return
     */
    public static BigDecimal getBigDecimalSum(BigDecimal i, BigDecimal... arg) {
        BigDecimal sum = i;
        for (BigDecimal b : arg) {
            sum = sum.add(b);
        }
        return sum;
    }
    public List<ProfitIncomeVO>  formatList( List<ProfitIncomeVO> profitIncomeVOList) {
        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            //中建科技集团有限公司  中建科技集团华南有限公司  中建科技集团华东有限公司  中建科技集团华北有限公司 中建科技集团西部有限公司  中建集成建筑有限公司
            List<ProfitIncomeVO> profitIncomeVOList7 = new ArrayList<>();//其他数据集合

            //中建科技集团有限公司
            BigDecimal realProduct1 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct1 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated1 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList1 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO1 = new ProfitIncomeVO();//小计行

            //中建科技集团华南有限公司
            BigDecimal realProduct2 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct2 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated2 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList2 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO2 = new ProfitIncomeVO();//小计行

            //中建科技集团华东有限公司
            BigDecimal realProduct3 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct3 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated3 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList3 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO3 = new ProfitIncomeVO();//小计行

            //中建科技集团华北有限公司
            BigDecimal realProduct4 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct4 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated4 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList4 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO4 = new ProfitIncomeVO();//小计行

            //中建科技集团西部有限公司
            BigDecimal realProduct5 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct5 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated5 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList5 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO5 = new ProfitIncomeVO();//小计行

            //中建集成建筑有限公司
            BigDecimal realProduct6 = new BigDecimal("0"); //实际完成产值 小计
            BigDecimal notarizeProduct6 = new BigDecimal("0"); //业主确认产值 小计
            BigDecimal unliquidated6 = new BigDecimal("0"); //已完工未结算 小计
            List<ProfitIncomeVO> profitIncomeVOList6 = new ArrayList<>();//数据集合
            ProfitIncomeVO profitIncomeVO6 = new ProfitIncomeVO();//小计行

            for(ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                if (null != profitIncomeVO.getTwoOrgName() && "中建科技集团有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList1.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "中建科技集团华南有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList2.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "中建科技集团华东有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList3.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "中建科技集团华北有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList4.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "中建科技集团西部有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList5.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "中建集成建筑有限公司".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList6.add(profitIncomeVO);
                }else{
                    profitIncomeVOList7.add(profitIncomeVO);
                }
            }
            realProduct1 = profitIncomeVOList1.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct1 = profitIncomeVOList1.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated1 = profitIncomeVOList1.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);

            realProduct2 = profitIncomeVOList2.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct2 = profitIncomeVOList2.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated2 = profitIncomeVOList2.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);

            realProduct3 = profitIncomeVOList3.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct3 = profitIncomeVOList3.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated3 = profitIncomeVOList3.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);

            realProduct4 = profitIncomeVOList4.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct4 = profitIncomeVOList4.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated4 = profitIncomeVOList4.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);

            realProduct5 = profitIncomeVOList5.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct5 = profitIncomeVOList5.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated5 = profitIncomeVOList5.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);

            realProduct6 = profitIncomeVOList6.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            notarizeProduct6 = profitIncomeVOList6.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO,BigDecimal::add);
            unliquidated6 = profitIncomeVOList6.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO,BigDecimal::add);


            List<ProfitIncomeVO>  newList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(profitIncomeVOList1)){
                profitIncomeVO1.setId(IdWorker.getId());
                profitIncomeVO1.setNumber("小计");
                profitIncomeVO1.setRealProduct(realProduct1);
                profitIncomeVO1.setNotarizeProduct(notarizeProduct1);
                profitIncomeVO1.setUnliquidated(unliquidated1);
                newList.add(profitIncomeVO1);
                newList.addAll(profitIncomeVOList1);
            }

            if(CollectionUtils.isNotEmpty(profitIncomeVOList2)) {
                profitIncomeVO2.setId(IdWorker.getId());
                profitIncomeVO2.setNumber("小计");
                profitIncomeVO2.setRealProduct(realProduct2);
                profitIncomeVO2.setNotarizeProduct(notarizeProduct2);
                profitIncomeVO2.setUnliquidated(unliquidated2);
                newList.add(profitIncomeVO2);
                newList.addAll(profitIncomeVOList2);
            }

            if(CollectionUtils.isNotEmpty(profitIncomeVOList3)) {
                profitIncomeVO3.setId(IdWorker.getId());
                profitIncomeVO3.setNumber("小计");
                profitIncomeVO3.setRealProduct(realProduct3);
                profitIncomeVO3.setNotarizeProduct(notarizeProduct3);
                profitIncomeVO3.setUnliquidated(unliquidated3);
                newList.add(profitIncomeVO3);
                newList.addAll(profitIncomeVOList3);
            }

            if(CollectionUtils.isNotEmpty(profitIncomeVOList4)) {
                profitIncomeVO4.setId(IdWorker.getId());
                profitIncomeVO4.setNumber("小计");
                profitIncomeVO4.setRealProduct(realProduct4);
                profitIncomeVO4.setNotarizeProduct(notarizeProduct4);
                profitIncomeVO4.setUnliquidated(unliquidated4);
                newList.add(profitIncomeVO4);
                newList.addAll(profitIncomeVOList4);
            }

            if(CollectionUtils.isNotEmpty(profitIncomeVOList5)) {
                profitIncomeVO5.setId(IdWorker.getId());
                profitIncomeVO5.setNumber("小计");
                profitIncomeVO5.setRealProduct(realProduct5);
                profitIncomeVO5.setNotarizeProduct(notarizeProduct5);
                profitIncomeVO5.setUnliquidated(unliquidated5);
                newList.add(profitIncomeVO5);
                newList.addAll(profitIncomeVOList5);
            }
            if(CollectionUtils.isNotEmpty(profitIncomeVOList6)){
                profitIncomeVO6.setId(IdWorker.getId());
                profitIncomeVO6.setNumber("小计");
                profitIncomeVO6.setRealProduct(realProduct6);
                profitIncomeVO6.setNotarizeProduct(notarizeProduct6);
                profitIncomeVO6.setUnliquidated(unliquidated6);
                newList.add(profitIncomeVO6);
                newList.addAll(profitIncomeVOList6);
            }
            if(CollectionUtils.isNotEmpty(profitIncomeVOList7)){
                newList.addAll(profitIncomeVOList7);
            }

            return newList;
        }else{
            return null;
        }

    }
}
