/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"profitIncome"})
public class ProfitIncomeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProfitIncomeService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> saveOrUpdate(@RequestBody ProfitIncomeVO saveOrUpdateVO) {
        ProfitIncomeEntity entity = (ProfitIncomeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProfitIncomeEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ProfitIncomeVO vo = (ProfitIncomeVO)BeanMapper.map((Object)((Object)entity), ProfitIncomeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> queryDetail(Long id) {
        ProfitIncomeEntity entity = (ProfitIncomeEntity)((Object)this.service.selectById(id));
        ProfitIncomeVO vo = (ProfitIncomeVO)BeanMapper.map((Object)((Object)entity), ProfitIncomeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitIncomeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProfitIncomeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String searchText = null;
        String reportingMonth = null;
        ArrayList<Integer> projectStatus = new ArrayList<Integer>();
        if (param.getParams().get("reportingMonth") != null) {
            reportingMonth = ((Parameter)param.getParams().get("reportingMonth")).getValue().toString();
        }
        if (param.getParams().get("projectStatus") != null) {
            String[] strs;
            String status = ((Parameter)param.getParams().get("projectStatus")).getValue().toString();
            for (String s : strs = status.split(",")) {
                projectStatus.add(Integer.parseInt(s));
            }
        }
        if (param.getSearchText() != null) {
            searchText = param.getSearchText();
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, Object> paramMapper = new HashMap<String, Object>();
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("departmentIds", departmentIds);
        paramMapper.put("projectStatus", projectStatus);
        paramMapper.put("searchText", searchText);
        paramMapper.put("reportingMonth", reportingMonth);
        List<ProfitIncomeVO> profitIncomeVOList = this.service.queryListPage(paramMapper);
        List<ProfitIncomeVO> profitIncomeVOS = this.service.processingList(profitIncomeVOList);
        Page page = new Page();
        page = new Page(page.getCurrent(), (long)param.getPageSize(), (long)profitIncomeVOS.size());
        page.setRecords(profitIncomeVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String searchText = null;
        String reportingMonth = null;
        ArrayList<Integer> projectStatus = new ArrayList<Integer>();
        if (param.getParams().get("reportingMonth") != null) {
            reportingMonth = ((Parameter)param.getParams().get("reportingMonth")).getValue().toString();
        }
        if (param.getParams().get("projectStatus") != null) {
            String[] strs;
            String status = ((Parameter)param.getParams().get("projectStatus")).getValue().toString();
            for (String s : strs = status.split(",")) {
                projectStatus.add(Integer.parseInt(s));
            }
        }
        if (param.getSearchText() != null) {
            searchText = param.getSearchText();
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, Object> paramMapper = new HashMap<String, Object>();
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("departmentIds", departmentIds);
        paramMapper.put("projectStatus", projectStatus);
        paramMapper.put("searchText", searchText);
        paramMapper.put("reportingMonth", reportingMonth);
        List<ProfitIncomeVO> profitIncomeVOList = this.service.queryListPage(paramMapper);
        List<ProfitIncomeVO> profitIncomeVOS = this.service.processingList(profitIncomeVOList);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", profitIncomeVOS);
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            beans.put("dateFormat", dateFormat);
            beans.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource("excel/ProfitIncome.xlsx");
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), beans);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.getRow(0).getCell(0).setCellValue("\u622a\u81f3" + ProfitIncomeController.getdate(reportingMonth) + "\u9879\u76ee\u6536\u5165\u5206\u6790");
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception var18) {
            var18.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException var17) {
                    var17.printStackTrace();
                }
            }
        }
    }

    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "\u5e74" + date2[1] + "\u6708";
        return date4;
    }

    @RequestMapping(value={"/refProfitIncomeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProfitIncomeVO>> refProfitIncomeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProfitIncomeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        String day = request.getParameter("day");
        String date = request.getParameter("date");
        this.service.execute(null, day, date, null);
        return CommonResponse.success((String)"\u6536\u5165\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/executeTest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> executeTest(Integer inAdvanceFlag, @RequestParam(value="day", required=false) String day, @RequestParam(value="date") String date, @RequestParam(value="projectIdList", required=false) List<Long> projectIdList) {
        this.service.execute(inAdvanceFlag, day, date, projectIdList);
        return CommonResponse.success((String)"\u6536\u5165\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }
}

