/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.service.IProSignReserveService;
import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;

@Service(value="proSignReserveService")
public class ProSignReserveServiceImpl
extends BaseServiceImpl<ProSignReserveMapper, ProSignReserveEntity>
implements IProSignReserveService {
    @Override
    public void execute(String day, String date) {
        String endDate = null;
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            Date executeDate = null;
            try {
                executeDate = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths(executeDate, (int)-1), (String)"yyyy-MM-dd");
        } else {
            if (!day.equals(DateFormatUtils.format((Date)new Date(), (String)"d"))) {
                throw new BusinessException("\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u5339\u914d\u8bbe\u7f6e\u65e5\u671f");
            }
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths((Date)new Date(), (int)-1), (String)"yyyy-MM-dd");
        }
        ArrayList<ProSignReserveVO> vos = new ArrayList<ProSignReserveVO>();
        List<ProSignReserveVO> projectIdsList = this.queryProjectIds(endDate);
        for (ProSignReserveVO vo : projectIdsList) {
            List<ProSignReserveVO> proSignReserveIncontractVOS = this.queryIncontract(vo.getProjectId(), endDate);
            ArrayList<Date> incontractDateList = new ArrayList<Date>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveIncontractVOS) {
                incontractDateList.add(proSignReserveVO.getCreateTime());
            }
            Date incontractDate = (Date)Collections.min(incontractDateList);
            Object proSignReserveIncontractVO = null;
            for (ProSignReserveVO proSignReserveVO : proSignReserveIncontractVOS) {
                if (incontractDate == proSignReserveVO.getCreateTime()) {
                    vo.setContractSignTime(proSignReserveVO.getCreateTime());
                }
                vo.setContractAmount(ComputeUtil.safeAdd((BigDecimal)vo.getContractAmount(), (BigDecimal)proSignReserveVO.getContractAmount()));
                vo.setAcContractAmount(ComputeUtil.safeAdd((BigDecimal)vo.getAcContractAmount(), (BigDecimal)proSignReserveVO.getAcContractAmount()));
            }
            List<ProSignReserveVO> proSignReserveBookVOS = this.queryBook(vo.getProjectId());
            ArrayList<Date> booksDateList = new ArrayList<Date>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveBookVOS) {
                booksDateList.add(proSignReserveVO.getCreateTime());
            }
            Date booksDate = (Date)Collections.max(booksDateList);
            ProSignReserveVO proSignReserveBookVO = new ProSignReserveVO();
            for (ProSignReserveVO proSignReserveVO : proSignReserveBookVOS) {
                if (booksDate != proSignReserveVO.getCreateTime()) continue;
                vo.setResponsibilityCost(proSignReserveVO.getResponsibilityCost());
                vo.setUndertakingBenefits(proSignReserveVO.getUndertakingBenefits());
                vo.setUndertakingBenefitsRate(proSignReserveVO.getUndertakingBenefitsRate());
                vo.setOverallProfitMargin(proSignReserveVO.getOverallProfitMargin());
            }
            List<ProSignReserveVO> proSignReserveAllocateVOS = this.queryAllocate(vo.getProjectId());
            ArrayList<Date> allocateDateList = new ArrayList<Date>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveAllocateVOS) {
                allocateDateList.add(proSignReserveVO.getCreateTime());
            }
            Date allocateDate = (Date)Collections.max(allocateDateList);
            ProSignReserveVO proSignReserveAllocateVO = new ProSignReserveVO();
            for (ProSignReserveVO proSignReserveVO : proSignReserveAllocateVOS) {
                if (allocateDate != proSignReserveAllocateVO.getCreateTime()) continue;
                vo.setTrsReservedAmount(proSignReserveVO.getTrsReservedAmount());
                vo.setApprovedReservedAmount(proSignReserveVO.getApprovedReservedAmount());
                vo.setActualReservedAmount(proSignReserveVO.getActualReservedAmount());
                vo.setRiskReserve(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getActualReservedAmount(), (BigDecimal)vo.getApprovedReservedAmount()), (BigDecimal)BigDecimal.valueOf(100L)));
            }
            vos.add(vo);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            this.saveOrUpdateBatch(BeanMapper.mapList(vos, ProSignReserveEntity.class));
        }
    }

    @Override
    public void saveBatch(String endDate) {
        ((ProSignReserveMapper)this.baseMapper).saveBatch(endDate);
    }

    @Override
    public List<ProSignReserveVO> queryProjectIds(String endDate) {
        List<ProSignReserveVO> vos = ((ProSignReserveMapper)this.baseMapper).queryProjectIds(endDate);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryIncontract(Long id, String endDate) {
        List<ProSignReserveVO> vos = ((ProSignReserveMapper)this.baseMapper).queryIncontract(id, endDate);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryBook(Long id) {
        List<ProSignReserveVO> vos = ((ProSignReserveMapper)this.baseMapper).queryBook(id);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryAllocate(Long id) {
        List<ProSignReserveVO> vos = ((ProSignReserveMapper)this.baseMapper).queryAllocate(id);
        return vos;
    }
}

